/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.validation;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public final class Grep {
    private final String commandString;
    private final int exitCode;
    private final List<String> lines;
    private final Exception e;

    /*
     * Enabled aggressive exception aggregation
     */
    public static Grep execute(String pattern, String sourceDir) {
        String commandString = "grep -r -n -E '^" + pattern + "' " + sourceDir;
        try {
            Process process = new ProcessBuilder(new String[0]).redirectErrorStream(true).command("/usr/bin/grep", "-r", "-n", "-E", "^" + pattern, sourceDir).start();
            int exitCode = process.waitFor();
            try (InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());){
                Grep grep;
                try (BufferedReader reader = new BufferedReader(inputStreamReader);){
                    grep = new Grep(commandString, exitCode, reader.lines().collect(Collectors.toList()));
                }
                return grep;
            }
        }
        catch (Exception e) {
            return new Grep(commandString, e);
        }
    }

    private Grep(String commandString, Exception e) {
        this.commandString = commandString;
        this.exitCode = -1;
        this.lines = Collections.emptyList();
        this.e = e;
    }

    private Grep(String commandString, int exitCode, List<String> lines) {
        this.commandString = commandString;
        this.exitCode = exitCode;
        this.lines = lines;
        this.e = null;
    }

    public boolean success() {
        return this.success(true);
    }

    public boolean success(boolean expectOneLine) {
        if (this.e != null) {
            return false;
        }
        if (this.exitCode != 0) {
            return false;
        }
        return !expectOneLine || this.lines.size() == 1;
    }

    public String getCommandString() {
        return this.commandString;
    }

    public String getFilenameAndLine() {
        return this.getFilenameAndLine(0);
    }

    public String getFilenameAndLine(int lineNumber) {
        String[] pieces = this.lines.get(lineNumber).split(":");
        return pieces[0] + ":" + pieces[1];
    }

    public String getOutput() {
        return this.getOutput(0);
    }

    public String getOutput(int lineNumber) {
        return this.lines.get(lineNumber).split(":")[2];
    }

    public void forEach(BiConsumer<String, String> action) {
        for (int i = 0; i < this.lines.size(); ++i) {
            action.accept(this.getFilenameAndLine(i), this.getOutput(i));
        }
    }
}

