/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.DirectBuffer;


/**
 * Response to a vote request from a follower to the candidate.
 */
@SuppressWarnings("all")
public final class VoteDecoder
{
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 52;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final VoteDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public VoteDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public VoteDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public VoteDecoder sbeRewind()
    {
        return wrap(buffer, offset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int actingVersion()
    {
        return actingVersion;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int candidateTermIdId()
    {
        return 1;
    }

    public static int candidateTermIdSinceVersion()
    {
        return 0;
    }

    public static int candidateTermIdEncodingOffset()
    {
        return 0;
    }

    public static int candidateTermIdEncodingLength()
    {
        return 8;
    }

    public static String candidateTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long candidateTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long candidateTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long candidateTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long candidateTermId()
    {
        return buffer.getLong(offset + 0, BYTE_ORDER);
    }


    public static int logLeadershipTermIdId()
    {
        return 2;
    }

    public static int logLeadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int logLeadershipTermIdEncodingOffset()
    {
        return 8;
    }

    public static int logLeadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String logLeadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logLeadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logLeadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logLeadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logLeadershipTermId()
    {
        return buffer.getLong(offset + 8, BYTE_ORDER);
    }


    public static int logPositionId()
    {
        return 3;
    }

    public static int logPositionSinceVersion()
    {
        return 0;
    }

    public static int logPositionEncodingOffset()
    {
        return 16;
    }

    public static int logPositionEncodingLength()
    {
        return 8;
    }

    public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logPosition()
    {
        return buffer.getLong(offset + 16, BYTE_ORDER);
    }


    public static int candidateMemberIdId()
    {
        return 4;
    }

    public static int candidateMemberIdSinceVersion()
    {
        return 0;
    }

    public static int candidateMemberIdEncodingOffset()
    {
        return 24;
    }

    public static int candidateMemberIdEncodingLength()
    {
        return 4;
    }

    public static String candidateMemberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int candidateMemberIdNullValue()
    {
        return -2147483648;
    }

    public static int candidateMemberIdMinValue()
    {
        return -2147483647;
    }

    public static int candidateMemberIdMaxValue()
    {
        return 2147483647;
    }

    public int candidateMemberId()
    {
        return buffer.getInt(offset + 24, BYTE_ORDER);
    }


    public static int followerMemberIdId()
    {
        return 5;
    }

    public static int followerMemberIdSinceVersion()
    {
        return 0;
    }

    public static int followerMemberIdEncodingOffset()
    {
        return 28;
    }

    public static int followerMemberIdEncodingLength()
    {
        return 4;
    }

    public static String followerMemberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int followerMemberIdNullValue()
    {
        return -2147483648;
    }

    public static int followerMemberIdMinValue()
    {
        return -2147483647;
    }

    public static int followerMemberIdMaxValue()
    {
        return 2147483647;
    }

    public int followerMemberId()
    {
        return buffer.getInt(offset + 28, BYTE_ORDER);
    }


    public static int voteId()
    {
        return 6;
    }

    public static int voteSinceVersion()
    {
        return 0;
    }

    public static int voteEncodingOffset()
    {
        return 32;
    }

    public static int voteEncodingLength()
    {
        return 4;
    }

    public static String voteMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public int voteRaw()
    {
        return buffer.getInt(offset + 32, BYTE_ORDER);
    }

    public BooleanType vote()
    {
        return BooleanType.get(buffer.getInt(offset + 32, BYTE_ORDER));
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final VoteDecoder decoder = new VoteDecoder();
        decoder.wrap(buffer, offset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(offset + actingBlockLength);
        builder.append("[Vote](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("candidateTermId=");
        builder.append(this.candidateTermId());
        builder.append('|');
        builder.append("logLeadershipTermId=");
        builder.append(this.logLeadershipTermId());
        builder.append('|');
        builder.append("logPosition=");
        builder.append(this.logPosition());
        builder.append('|');
        builder.append("candidateMemberId=");
        builder.append(this.candidateMemberId());
        builder.append('|');
        builder.append("followerMemberId=");
        builder.append(this.followerMemberId());
        builder.append('|');
        builder.append("vote=");
        builder.append(this.vote());

        limit(originalLimit);

        return builder;
    }
    
    public VoteDecoder sbeSkip()
    {
        sbeRewind();

        return this;
    }
}
