/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.ControlSession;
import io.aeron.archive.Session;
import io.aeron.archive.client.ArchiveEvent;
import io.aeron.archive.codecs.RecordingSignal;
import java.io.File;
import java.util.ArrayDeque;
import org.agrona.AsciiEncoding;
import org.agrona.ErrorHandler;

class DeleteSegmentsSession
implements Session {
    private final long recordingId;
    private final long correlationId;
    private final long maxDeletePosition;
    private final ArrayDeque<File> files;
    private final ControlSession controlSession;
    private final ErrorHandler errorHandler;

    DeleteSegmentsSession(long recordingId, long correlationId, ArrayDeque<File> files, ControlSession controlSession, ErrorHandler errorHandler) {
        this.recordingId = recordingId;
        this.correlationId = correlationId;
        this.files = files;
        this.controlSession = controlSession;
        this.errorHandler = errorHandler;
        long maxSegmentPosition = Long.MIN_VALUE;
        int prefixLength = AsciiEncoding.digitCount(recordingId) + 1;
        for (File file : files) {
            String name = file.getName();
            int dotIndex = name.indexOf(46);
            maxSegmentPosition = Math.max(maxSegmentPosition, AsciiEncoding.parseLongAscii(name, prefixLength, dotIndex - prefixLength));
        }
        this.maxDeletePosition = maxSegmentPosition;
    }

    long maxDeletePosition() {
        return this.maxDeletePosition;
    }

    @Override
    public void close() {
        this.controlSession.archiveConductor().removeDeleteSegmentsSession(this);
        this.controlSession.sendSignal(this.correlationId, this.recordingId, -1L, -1L, RecordingSignal.DELETE);
    }

    @Override
    public void abort(String reason) {
    }

    @Override
    public boolean isDone() {
        return this.files.isEmpty();
    }

    @Override
    public long sessionId() {
        return this.recordingId;
    }

    @Override
    public int doWork() {
        int workCount = 0;
        File file = this.files.pollFirst();
        if (null != file) {
            if (!file.delete()) {
                File renamedFile;
                if (file.exists()) {
                    this.onDeleteError(file);
                } else if (!file.getName().endsWith(".del") && !(renamedFile = new File(file.getParent(), file.getName() + ".del")).delete() && renamedFile.exists()) {
                    this.onDeleteError(renamedFile);
                }
            }
            workCount = 1;
        }
        return workCount;
    }

    private void onDeleteError(File file) {
        String errorMessage = "unable to delete segment file: " + String.valueOf(file);
        this.controlSession.sendErrorResponse(this.correlationId, 0L, errorMessage);
        this.errorHandler.onError(new ArchiveEvent(errorMessage));
    }
}

