/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Publication;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.RecordingProgressEncoder;
import io.aeron.archive.codecs.RecordingStartedEncoder;
import io.aeron.archive.codecs.RecordingStoppedEncoder;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.CloseHelper;
import org.agrona.ExpandableArrayBuffer;

class RecordingEventsProxy
implements AutoCloseable {
    private static final int SEND_ATTEMPTS = 3;
    private final Publication publication;
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(1024);
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final RecordingStartedEncoder recordingStartedEncoder = new RecordingStartedEncoder();
    private final RecordingProgressEncoder recordingProgressEncoder = new RecordingProgressEncoder();
    private final RecordingStoppedEncoder recordingStoppedEncoder = new RecordingStoppedEncoder();

    RecordingEventsProxy(Publication publication) {
        this.publication = publication;
    }

    @Override
    public void close() {
        CloseHelper.close(this.publication);
    }

    void started(long recordingId, long startPosition, int sessionId, int streamId, String channel, String sourceIdentity) {
        long position;
        this.recordingStartedEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).recordingId(recordingId).startPosition(startPosition).sessionId(sessionId).streamId(streamId).channel(channel).sourceIdentity(sourceIdentity);
        int length = 8 + this.recordingStartedEncoder.encodedLength();
        int attempts = 3;
        while ((position = this.publication.offer(this.buffer, 0, length)) <= 0L && -1L != position) {
            RecordingEventsProxy.checkResult(position, this.publication);
            if (--attempts > 0) continue;
        }
    }

    boolean progress(long recordingId, long startPosition, long position) {
        int length = 32;
        long result = this.publication.tryClaim(32, this.bufferClaim);
        if (result > 0L) {
            this.recordingProgressEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).recordingId(recordingId).startPosition(startPosition).position(position);
            this.bufferClaim.commit();
            return true;
        }
        RecordingEventsProxy.checkResult(result, this.publication);
        return false;
    }

    void stopped(long recordingId, long startPosition, long stopPosition) {
        int length = 32;
        int attempts = 3;
        do {
            long position;
            if ((position = this.publication.tryClaim(32, this.bufferClaim)) > 0L) {
                this.recordingStoppedEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).recordingId(recordingId).startPosition(startPosition).stopPosition(stopPosition);
                this.bufferClaim.commit();
                break;
            }
            if (-1L == position) break;
            RecordingEventsProxy.checkResult(position, this.publication);
        } while (--attempts > 0);
    }

    private static void checkResult(long position, Publication publication) {
        if (position == -4L) {
            throw new ArchiveException("recording events publication is closed");
        }
        if (position == -5L) {
            throw new ArchiveException("recording events publication at max position, term-length=" + publication.termBufferLength());
        }
    }
}

