/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.exceptions.AeronException;

public class ArchiveException
extends AeronException {
    public static final int GENERIC = 0;
    public static final int ACTIVE_LISTING = 1;
    public static final int ACTIVE_RECORDING = 2;
    public static final int ACTIVE_SUBSCRIPTION = 3;
    public static final int UNKNOWN_SUBSCRIPTION = 4;
    public static final int UNKNOWN_RECORDING = 5;
    public static final int UNKNOWN_REPLAY = 6;
    public static final int MAX_REPLAYS = 7;
    public static final int MAX_RECORDINGS = 8;
    public static final int INVALID_EXTENSION = 9;
    public static final int AUTHENTICATION_REJECTED = 10;
    public static final int STORAGE_SPACE = 11;
    public static final int UNKNOWN_REPLICATION = 12;
    public static final int UNAUTHORISED_ACTION = 13;
    public static final int REPLICATION_CONNECTION_FAILURE = 14;
    private static final long serialVersionUID = 386758252787901080L;
    private final int errorCode;
    private final long correlationId;

    public ArchiveException() {
        this.errorCode = 0;
        this.correlationId = -1L;
    }

    public ArchiveException(String message) {
        super(message);
        this.errorCode = 0;
        this.correlationId = -1L;
    }

    public ArchiveException(String message, int errorCode) {
        super(message);
        this.errorCode = errorCode;
        this.correlationId = -1L;
    }

    public ArchiveException(String message, Throwable cause, int errorCode) {
        super(message, cause);
        this.errorCode = errorCode;
        this.correlationId = -1L;
    }

    public ArchiveException(String message, int errorCode, long correlationId) {
        super(message);
        this.errorCode = errorCode;
        this.correlationId = correlationId;
    }

    public ArchiveException(String message, AeronException.Category category) {
        super(message, category);
        this.errorCode = 0;
        this.correlationId = -1L;
    }

    public ArchiveException(String message, long correlationId, AeronException.Category category) {
        super(message, category);
        this.errorCode = 0;
        this.correlationId = correlationId;
    }

    public ArchiveException(String message, int errorCode, long correlationId, AeronException.Category category) {
        super(message, category);
        this.errorCode = errorCode;
        this.correlationId = correlationId;
    }

    public int errorCode() {
        return this.errorCode;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public static String errorCodeAsString(int errorCode) {
        return switch (errorCode) {
            case 0 -> "GENERIC";
            case 1 -> "ACTIVE_LISTING";
            case 2 -> "ACTIVE_RECORDING";
            case 3 -> "ACTIVE_SUBSCRIPTION";
            case 4 -> "UNKNOWN_SUBSCRIPTION";
            case 5 -> "UNKNOWN_RECORDING";
            case 6 -> "UNKNOWN_REPLAY";
            case 7 -> "MAX_REPLAYS";
            case 8 -> "MAX_RECORDINGS";
            case 9 -> "INVALID_EXTENSION";
            case 10 -> "AUTHENTICATION_REJECTED";
            case 11 -> "STORAGE_SPACE";
            case 12 -> "UNKNOWN_REPLICATION";
            case 13 -> "UNAUTHORISED_ACTION";
            case 14 -> "REPLICATION_CONNECTION_FAILURE";
            default -> "unknown error code: " + errorCode;
        };
    }
}

