/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class BoundedReplayRequestDecoder {
    public static final int BLOCK_LENGTH = 60;
    public static final int TEMPLATE_ID = 18;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 10;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final BoundedReplayRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 60;
    }

    public int sbeTemplateId() {
        return 18;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 10;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public BoundedReplayRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public BoundedReplayRequestDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (18 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public BoundedReplayRequestDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdId() {
        return 1;
    }

    public static int controlSessionIdSinceVersion() {
        return 0;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long controlSessionId() {
        return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 8, BYTE_ORDER);
    }

    public static int recordingIdId() {
        return 3;
    }

    public static int recordingIdSinceVersion() {
        return 0;
    }

    public static int recordingIdEncodingOffset() {
        return 16;
    }

    public static int recordingIdEncodingLength() {
        return 8;
    }

    public static String recordingIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long recordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long recordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long recordingId() {
        return this.buffer.getLong(this.offset + 16, BYTE_ORDER);
    }

    public static int positionId() {
        return 4;
    }

    public static int positionSinceVersion() {
        return 0;
    }

    public static int positionEncodingOffset() {
        return 24;
    }

    public static int positionEncodingLength() {
        return 8;
    }

    public static String positionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long positionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long positionMinValue() {
        return -9223372036854775807L;
    }

    public static long positionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long position() {
        return this.buffer.getLong(this.offset + 24, BYTE_ORDER);
    }

    public static int lengthId() {
        return 5;
    }

    public static int lengthSinceVersion() {
        return 0;
    }

    public static int lengthEncodingOffset() {
        return 32;
    }

    public static int lengthEncodingLength() {
        return 8;
    }

    public static String lengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long lengthNullValue() {
        return Long.MIN_VALUE;
    }

    public static long lengthMinValue() {
        return -9223372036854775807L;
    }

    public static long lengthMaxValue() {
        return Long.MAX_VALUE;
    }

    public long length() {
        return this.buffer.getLong(this.offset + 32, BYTE_ORDER);
    }

    public static int limitCounterIdId() {
        return 6;
    }

    public static int limitCounterIdSinceVersion() {
        return 0;
    }

    public static int limitCounterIdEncodingOffset() {
        return 40;
    }

    public static int limitCounterIdEncodingLength() {
        return 4;
    }

    public static String limitCounterIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int limitCounterIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int limitCounterIdMinValue() {
        return -2147483647;
    }

    public static int limitCounterIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int limitCounterId() {
        return this.buffer.getInt(this.offset + 40, BYTE_ORDER);
    }

    public static int replayStreamIdId() {
        return 7;
    }

    public static int replayStreamIdSinceVersion() {
        return 0;
    }

    public static int replayStreamIdEncodingOffset() {
        return 44;
    }

    public static int replayStreamIdEncodingLength() {
        return 4;
    }

    public static String replayStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int replayStreamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int replayStreamIdMinValue() {
        return -2147483647;
    }

    public static int replayStreamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int replayStreamId() {
        return this.buffer.getInt(this.offset + 44, BYTE_ORDER);
    }

    public static int fileIoMaxLengthId() {
        return 9;
    }

    public static int fileIoMaxLengthSinceVersion() {
        return 7;
    }

    public static int fileIoMaxLengthEncodingOffset() {
        return 48;
    }

    public static int fileIoMaxLengthEncodingLength() {
        return 4;
    }

    public static String fileIoMaxLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int fileIoMaxLengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int fileIoMaxLengthMinValue() {
        return -2147483647;
    }

    public static int fileIoMaxLengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int fileIoMaxLength() {
        if (this.parentMessage.actingVersion < 7) {
            return Integer.MIN_VALUE;
        }
        return this.buffer.getInt(this.offset + 48, BYTE_ORDER);
    }

    public static int replayTokenId() {
        return 10;
    }

    public static int replayTokenSinceVersion() {
        return 10;
    }

    public static int replayTokenEncodingOffset() {
        return 52;
    }

    public static int replayTokenEncodingLength() {
        return 8;
    }

    public static String replayTokenMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long replayTokenNullValue() {
        return Long.MIN_VALUE;
    }

    public static long replayTokenMinValue() {
        return -9223372036854775807L;
    }

    public static long replayTokenMaxValue() {
        return Long.MAX_VALUE;
    }

    public long replayToken() {
        if (this.parentMessage.actingVersion < 10) {
            return Long.MIN_VALUE;
        }
        return this.buffer.getLong(this.offset + 52, BYTE_ORDER);
    }

    public static int replayChannelId() {
        return 8;
    }

    public static int replayChannelSinceVersion() {
        return 0;
    }

    public static String replayChannelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String replayChannelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int replayChannelHeaderLength() {
        return 4;
    }

    public int replayChannelLength() {
        int limit = this.parentMessage.limit();
        return (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
    }

    public int skipReplayChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        return dataLength;
    }

    public int getReplayChannel(MutableDirectBuffer dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public int getReplayChannel(byte[] dst, int dstOffset, int length) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int bytesCopied = Math.min(length, dataLength);
        this.parentMessage.limit(limit + 4 + dataLength);
        this.buffer.getBytes(limit + 4, dst, dstOffset, bytesCopied);
        return bytesCopied;
    }

    public void wrapReplayChannel(DirectBuffer wrapBuffer) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        wrapBuffer.wrap(this.buffer, limit + 4, dataLength);
    }

    public String replayChannel() {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        this.parentMessage.limit(limit + 4 + dataLength);
        if (0 == dataLength) {
            return "";
        }
        byte[] tmp = new byte[dataLength];
        this.buffer.getBytes(limit + 4, tmp, 0, dataLength);
        return new String(tmp, StandardCharsets.US_ASCII);
    }

    public int getReplayChannel(Appendable appendable) {
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        int dataLength = (int)((long)this.buffer.getInt(limit, BYTE_ORDER) & 0xFFFFFFFFL);
        int dataOffset = limit + 4;
        this.parentMessage.limit(dataOffset + dataLength);
        this.buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);
        return dataLength;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        BoundedReplayRequestDecoder decoder = new BoundedReplayRequestDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[BoundedReplayRequest](sbeTemplateId=");
        builder.append(18);
        builder.append("|sbeSchemaId=");
        builder.append(101);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 10) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(10);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 60) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(60);
        builder.append("):");
        builder.append("controlSessionId=");
        builder.append(this.controlSessionId());
        builder.append('|');
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("recordingId=");
        builder.append(this.recordingId());
        builder.append('|');
        builder.append("position=");
        builder.append(this.position());
        builder.append('|');
        builder.append("length=");
        builder.append(this.length());
        builder.append('|');
        builder.append("limitCounterId=");
        builder.append(this.limitCounterId());
        builder.append('|');
        builder.append("replayStreamId=");
        builder.append(this.replayStreamId());
        builder.append('|');
        builder.append("fileIoMaxLength=");
        builder.append(this.fileIoMaxLength());
        builder.append('|');
        builder.append("replayToken=");
        builder.append(this.replayToken());
        builder.append('|');
        builder.append("replayChannel=");
        builder.append('\'');
        this.getReplayChannel(builder);
        builder.append('\'');
        this.limit(originalLimit);
        return builder;
    }

    public BoundedReplayRequestDecoder sbeSkip() {
        this.sbeRewind();
        this.skipReplayChannel();
        return this;
    }
}

