/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.codecs.AdminRequestDecoder;
import io.aeron.cluster.codecs.ChallengeResponseDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.SessionCloseRequestDecoder;
import io.aeron.cluster.codecs.SessionConnectRequestDecoder;
import io.aeron.cluster.codecs.SessionKeepAliveDecoder;
import io.aeron.cluster.codecs.SessionMessageHeaderDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.collections.ArrayUtil;

class IngressAdapter
implements AutoCloseable {
    private final int fragmentPollLimit;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionConnectRequestDecoder connectRequestDecoder = new SessionConnectRequestDecoder();
    private final SessionCloseRequestDecoder closeRequestDecoder = new SessionCloseRequestDecoder();
    private final SessionMessageHeaderDecoder sessionMessageHeaderDecoder = new SessionMessageHeaderDecoder();
    private final SessionKeepAliveDecoder sessionKeepAliveDecoder = new SessionKeepAliveDecoder();
    private final ChallengeResponseDecoder challengeResponseDecoder = new ChallengeResponseDecoder();
    private final AdminRequestDecoder adminRequestDecoder = new AdminRequestDecoder();
    private final ControlledFragmentAssembler fragmentAssembler = new ControlledFragmentAssembler(this::onMessage);
    private final ConsensusModuleAgent consensusModuleAgent;
    private Subscription subscription;
    private Subscription ipcSubscription;

    IngressAdapter(int fragmentPollLimit, ConsensusModuleAgent consensusModuleAgent) {
        this.fragmentPollLimit = fragmentPollLimit;
        this.consensusModuleAgent = consensusModuleAgent;
    }

    @Override
    public void close() {
        Subscription subscription = this.subscription;
        Subscription ipcSubscription = this.ipcSubscription;
        this.subscription = null;
        this.ipcSubscription = null;
        if (null != subscription) {
            subscription.close();
        }
        if (null != ipcSubscription) {
            ipcSubscription.close();
        }
        this.fragmentAssembler.clear();
    }

    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        int templateId = this.messageHeaderDecoder.templateId();
        int actingVersion = this.messageHeaderDecoder.version();
        int actingBlockLength = this.messageHeaderDecoder.blockLength();
        if (schemaId != 111) {
            return this.consensusModuleAgent.onExtensionMessage(actingBlockLength, templateId, schemaId, actingVersion, buffer, offset, length, header);
        }
        if (templateId == 1) {
            this.sessionMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), actingVersion);
            return this.consensusModuleAgent.onIngressMessage(this.sessionMessageHeaderDecoder.leadershipTermId(), this.sessionMessageHeaderDecoder.clusterSessionId(), buffer, offset + 32, length - 32);
        }
        switch (templateId) {
            case 3: {
                this.connectRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), actingVersion);
                String responseChannel = this.connectRequestDecoder.responseChannel();
                int credentialsLength = this.connectRequestDecoder.encodedCredentialsLength();
                byte[] credentials = ArrayUtil.EMPTY_BYTE_ARRAY;
                if (credentialsLength > 0) {
                    credentials = new byte[credentialsLength];
                    this.connectRequestDecoder.getEncodedCredentials(credentials, 0, credentialsLength);
                }
                this.consensusModuleAgent.onSessionConnect(this.connectRequestDecoder.correlationId(), this.connectRequestDecoder.responseStreamId(), this.connectRequestDecoder.version(), responseChannel, credentials);
                break;
            }
            case 4: {
                this.closeRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), actingVersion);
                this.consensusModuleAgent.onSessionClose(this.closeRequestDecoder.leadershipTermId(), this.closeRequestDecoder.clusterSessionId());
                break;
            }
            case 5: {
                this.sessionKeepAliveDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), actingVersion);
                this.consensusModuleAgent.onSessionKeepAlive(this.sessionKeepAliveDecoder.leadershipTermId(), this.sessionKeepAliveDecoder.clusterSessionId());
                break;
            }
            case 8: {
                this.challengeResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), actingVersion);
                byte[] credentials = new byte[this.challengeResponseDecoder.encodedCredentialsLength()];
                this.challengeResponseDecoder.getEncodedCredentials(credentials, 0, credentials.length);
                this.consensusModuleAgent.onIngressChallengeResponse(this.challengeResponseDecoder.correlationId(), this.challengeResponseDecoder.clusterSessionId(), credentials);
                break;
            }
            case 26: {
                this.adminRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), actingVersion);
                int payloadOffset = this.adminRequestDecoder.offset() + this.adminRequestDecoder.encodedLength() + AdminRequestDecoder.payloadHeaderLength();
                this.consensusModuleAgent.onAdminRequest(this.adminRequestDecoder.leadershipTermId(), this.adminRequestDecoder.clusterSessionId(), this.adminRequestDecoder.correlationId(), this.adminRequestDecoder.requestType(), buffer, payloadOffset, this.adminRequestDecoder.payloadLength());
                break;
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    void connect(Subscription subscription, Subscription ipcSubscription) {
        this.subscription = subscription;
        this.ipcSubscription = ipcSubscription;
    }

    int poll() {
        int fragmentsRead = 0;
        if (null != this.subscription) {
            fragmentsRead += this.subscription.controlledPoll(this.fragmentAssembler, this.fragmentPollLimit);
        }
        if (null != this.ipcSubscription) {
            fragmentsRead += this.ipcSubscription.controlledPoll(this.fragmentAssembler, this.fragmentPollLimit);
        }
        return fragmentsRead;
    }

    void freeSessionBuffer(int imageSessionId) {
        this.fragmentAssembler.freeSessionBuffer(imageSessionId);
    }
}

