/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.TimerService;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import org.agrona.collections.Long2ObjectHashMap;

final class PriorityHeapTimerService
implements TimerService {
    private static final Timer[] EMPTY_TIMERS = new Timer[0];
    private static final int MIN_CAPACITY = 8;
    private final TimerService.TimerHandler timerHandler;
    private final Long2ObjectHashMap<Timer> timerByCorrelationId = new Long2ObjectHashMap();
    private Timer[] timers = EMPTY_TIMERS;
    private Timer[] freeTimers = EMPTY_TIMERS;
    private int size;
    private int freeTimerCount;

    PriorityHeapTimerService(TimerService.TimerHandler timerHandler) {
        this.timerHandler = Objects.requireNonNull(timerHandler, "TimerHandler");
    }

    @Override
    public int poll(long now) {
        int expiredTimers = 0;
        Timer[] timers = this.timers;
        TimerService.TimerHandler timerHandler = this.timerHandler;
        while (this.size > 0 && expiredTimers < 20) {
            Timer timer = timers[0];
            if (timer.deadline > now || !timerHandler.onTimerEvent(timer.correlationId)) break;
            ++expiredTimers;
            int lastIndex = --this.size;
            Timer lastTimer = timers[lastIndex];
            timers[lastIndex] = null;
            if (0 != lastIndex) {
                PriorityHeapTimerService.shiftDown(timers, lastIndex, 0, lastTimer);
            }
            this.timerByCorrelationId.remove(timer.correlationId);
            this.addToFreeList(timer);
        }
        return expiredTimers;
    }

    @Override
    public void scheduleTimerForCorrelationId(long correlationId, long deadline) {
        Timer existingTimer = this.timerByCorrelationId.get(correlationId);
        if (null != existingTimer) {
            if (deadline < existingTimer.deadline) {
                existingTimer.deadline = deadline;
                PriorityHeapTimerService.shiftUp(this.timers, existingTimer.index, existingTimer);
            } else if (deadline > existingTimer.deadline) {
                existingTimer.deadline = deadline;
                PriorityHeapTimerService.shiftDown(this.timers, this.size, existingTimer.index, existingTimer);
            }
        } else {
            Timer timer;
            this.ensureCapacity(this.size + 1);
            int index = this.size++;
            if (this.freeTimerCount > 0) {
                int freeIndex = --this.freeTimerCount;
                timer = this.freeTimers[freeIndex];
                this.freeTimers[freeIndex] = null;
                timer.reset(correlationId, deadline, index);
            } else {
                timer = new Timer(correlationId, deadline, index);
            }
            this.timerByCorrelationId.put(correlationId, timer);
            PriorityHeapTimerService.shiftUp(this.timers, index, timer);
        }
    }

    @Override
    public boolean cancelTimerByCorrelationId(long correlationId) {
        Timer removedTimer = this.timerByCorrelationId.remove(correlationId);
        if (null == removedTimer) {
            return false;
        }
        int lastIndex = --this.size;
        Timer lastTimer = this.timers[lastIndex];
        this.timers[lastIndex] = null;
        if (lastIndex != removedTimer.index) {
            PriorityHeapTimerService.shiftDown(this.timers, lastIndex, removedTimer.index, lastTimer);
            if (this.timers[removedTimer.index] == lastTimer) {
                PriorityHeapTimerService.shiftUp(this.timers, removedTimer.index, lastTimer);
            }
        }
        this.addToFreeList(removedTimer);
        return true;
    }

    @Override
    public void snapshot(TimerService.TimerSnapshotTaker snapshotTaker) {
        Timer[] timers = this.timers;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            Timer timer = timers[i];
            snapshotTaker.snapshotTimer(timer.correlationId, timer.deadline);
        }
    }

    @Override
    public void currentTime(long now) {
    }

    void forEach(Consumer<Timer> consumer) {
        Timer[] timers = this.timers;
        int size = this.size;
        for (int i = 0; i < size; ++i) {
            consumer.accept(timers[i]);
        }
    }

    private static void shiftUp(Timer[] timers, int startIndex, Timer timer) {
        int index = startIndex;
        while (index > 0) {
            int prevIndex = index - 1 >>> 1;
            Timer prevTimer = timers[prevIndex];
            if (timer.deadline >= prevTimer.deadline) break;
            timers[index] = prevTimer;
            prevTimer.index = index;
            index = prevIndex;
        }
        timers[index] = timer;
        timer.index = index;
    }

    private static void shiftDown(Timer[] timers, int size, int startIndex, Timer timer) {
        int half = size >>> 1;
        int index = startIndex;
        while (index < half) {
            int nextIndex = (index << 1) + 1;
            int right = nextIndex + 1;
            Timer nextTimer = timers[nextIndex];
            if (right < size && nextTimer.deadline > timers[right].deadline) {
                nextIndex = right;
                nextTimer = timers[nextIndex];
            }
            if (timer.deadline < nextTimer.deadline) break;
            timers[index] = nextTimer;
            nextTimer.index = index;
            index = nextIndex;
        }
        timers[index] = timer;
        timer.index = index;
    }

    private void ensureCapacity(int requiredCapacity) {
        int currentCapacity = this.timers.length;
        if (requiredCapacity > currentCapacity) {
            if (requiredCapacity > 0x7FFFFFF7) {
                throw new IllegalStateException("max capacity reached: 2147483639");
            }
            if (EMPTY_TIMERS == this.timers) {
                this.timers = new Timer[8];
                this.freeTimers = new Timer[8];
            } else {
                int newCapacity = currentCapacity + (currentCapacity >> 1);
                if (newCapacity < 0 || newCapacity > 0x7FFFFFF7) {
                    newCapacity = 0x7FFFFFF7;
                }
                this.timers = Arrays.copyOf(this.timers, newCapacity);
                this.freeTimers = Arrays.copyOf(this.freeTimers, newCapacity);
            }
        }
    }

    private void addToFreeList(Timer timer) {
        timer.reset(-1L, -1L, -1);
        this.freeTimers[this.freeTimerCount++] = timer;
    }

    static final class Timer {
        long correlationId;
        long deadline;
        int index;

        Timer(long correlationId, long deadline, int index) {
            this.reset(correlationId, deadline, index);
        }

        void reset(long correlationId, long deadline, int index) {
            this.correlationId = correlationId;
            this.deadline = deadline;
            this.index = index;
        }

        public String toString() {
            return "PriorityHeapTimerService.Timer{correlationId=" + this.correlationId + ", deadline=" + this.deadline + ", index=" + this.index + "}";
        }
    }
}

