/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.counter;

import io.aeron.counter.AeronCounter;
import io.aeron.counter.CounterInfo;
import io.aeron.utility.ElementIO;
import io.aeron.utility.Processor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.aeron.counter.AeronCounter"})
public class CounterProcessor
extends Processor {
    @Override
    protected String getEnabledPropertyName() {
        return "aeron.build.counterProcessor.enabled";
    }

    @Override
    protected String getPrintNotesPropertyName() {
        return "aeron.build.counterProcessor.printNotes";
    }

    @Override
    protected String getFailOnErrorPropertyName() {
        return "aeron.build.counterProcessor.failOnError";
    }

    @Override
    public void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<String, CounterInfo> counterInfoMap = new HashMap<String, CounterInfo>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                try {
                    if (!(element instanceof VariableElement)) continue;
                    this.processElement(counterInfoMap, (VariableElement)element);
                }
                catch (Exception e) {
                    this.error("an error occurred processing an element: " + e.getMessage(), element);
                    e.printStackTrace(System.err);
                }
            }
        }
        if (!counterInfoMap.isEmpty()) {
            try {
                FileObject resourceFile = this.processingEnv.getFiler().createResource(StandardLocation.NATIVE_HEADER_OUTPUT, "", "counter-info.dat", new Element[0]);
                ElementIO.write(resourceFile, counterInfoMap.values());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "an error occurred while writing output: " + e.getMessage());
            }
        }
    }

    private void processElement(Map<String, CounterInfo> counterInfoMap, VariableElement element) {
        AeronCounter counter = element.getAnnotation(AeronCounter.class);
        if (Objects.isNull(counter)) {
            this.error("element found with no expected annotations", element);
            return;
        }
        Matcher matcher = Pattern.compile("^([A-Z_]+)_TYPE_ID$").matcher(element.toString());
        if (!matcher.find()) {
            this.error("unable to determine type and/or id", element);
            return;
        }
        CounterInfo counterInfo = new CounterInfo(matcher.group(1));
        if (null != counterInfoMap.put(counterInfo.name, counterInfo)) {
            this.error("duplicate counters found", element);
            return;
        }
        counterInfo.counterDescription = this.getDocComment(element);
        Object constantValue = element.getConstantValue();
        if (constantValue instanceof Integer) {
            counterInfo.id = (Integer)constantValue;
        } else {
            this.error("Counter value must be an Integer", element);
        }
        if (!counter.existsInC()) {
            this.note("Counter isn't expected to exist in C", element);
            counterInfo.existsInC = false;
        }
        if (counterInfo.existsInC) {
            StringBuilder builder = new StringBuilder();
            builder.append("AERON_COUNTER_");
            if (counter.expectedCName().isEmpty()) {
                builder.append(counterInfo.name.replaceAll("^DRIVER_", ""));
            } else {
                this.note("Counter's C name is overridden", element);
                builder.append(counter.expectedCName());
            }
            builder.append("_TYPE_ID");
            counterInfo.expectedCName = builder.toString();
        }
    }
}

