/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.media.NetworkInterfaceShim;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ProtocolFamily;
import java.net.SocketException;
import java.net.StandardProtocolFamily;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import org.agrona.BufferUtil;

public final class NetworkUtil {
    public static NetworkInterface[] filterBySubnet(InetAddress address, int subnetPrefix) throws SocketException {
        return NetworkUtil.filterBySubnet(NetworkInterfaceShim.DEFAULT, address, subnetPrefix);
    }

    public static ByteBuffer allocateDirectAlignedAndPadded(int capacity, int alignment) {
        ByteBuffer buffer = BufferUtil.allocateDirectAligned(capacity + alignment, alignment);
        buffer.limit(buffer.limit() - alignment);
        return buffer.slice();
    }

    public static String formatAddressAndPort(InetAddress address, int port) {
        if (address instanceof Inet6Address) {
            return "[" + address.getHostAddress() + "]:" + port;
        }
        return address.getHostAddress() + ":" + port;
    }

    public static ProtocolFamily getProtocolFamily(InetAddress address) {
        if (address instanceof Inet4Address) {
            return StandardProtocolFamily.INET;
        }
        if (address instanceof Inet6Address) {
            return StandardProtocolFamily.INET6;
        }
        throw new IllegalStateException("Unknown ProtocolFamily");
    }

    public static InetAddress findFirstMatchingLocalAddress(InetAddress address) throws SocketException {
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                if (!NetworkUtil.isMatchWithPrefix(address.getAddress(), interfaceAddress.getAddress().getAddress(), interfaceAddress.getNetworkPrefixLength())) continue;
                return interfaceAddress.getAddress();
            }
        }
        return null;
    }

    static NetworkInterface[] filterBySubnet(NetworkInterfaceShim shim, InetAddress address, int subnetPrefix) throws SocketException {
        ArrayList<FilterResult> filterResults = new ArrayList<FilterResult>();
        byte[] queryAddress = address.getAddress();
        Enumeration<NetworkInterface> interfaces = shim.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            InterfaceAddress interfaceAddress = NetworkUtil.findAddressOnInterface(shim, networkInterface, queryAddress, subnetPrefix);
            if (null == interfaceAddress) continue;
            filterResults.add(new FilterResult(interfaceAddress, networkInterface, shim.isLoopback(networkInterface)));
        }
        Collections.sort(filterResults);
        int size = filterResults.size();
        NetworkInterface[] results = new NetworkInterface[size];
        for (int i = 0; i < size; ++i) {
            results[i] = ((FilterResult)filterResults.get((int)i)).networkInterface;
        }
        return results;
    }

    static InetAddress findAddressOnInterface(NetworkInterface networkInterface, InetAddress address, int subnetPrefix) {
        InterfaceAddress interfaceAddress = NetworkUtil.findAddressOnInterface(NetworkInterfaceShim.DEFAULT, networkInterface, address.getAddress(), subnetPrefix);
        return null == interfaceAddress ? null : interfaceAddress.getAddress();
    }

    static InterfaceAddress findAddressOnInterface(NetworkInterfaceShim shim, NetworkInterface networkInterface, byte[] queryAddress, int prefixLength) {
        for (InterfaceAddress interfaceAddress : shim.getInterfaceAddresses(networkInterface)) {
            InetAddress address;
            if (null == interfaceAddress || null == (address = interfaceAddress.getAddress()) || !NetworkUtil.isMatchWithPrefix(address.getAddress(), queryAddress, prefixLength)) continue;
            return interfaceAddress;
        }
        return null;
    }

    public static boolean isMatchWithPrefix(byte[] candidate, byte[] expected, int prefixLength) {
        if (candidate.length != expected.length) {
            return false;
        }
        if (candidate.length == 4) {
            int mask = NetworkUtil.prefixLengthToIpV4Mask(prefixLength);
            return (NetworkUtil.toInt(candidate) & mask) == (NetworkUtil.toInt(expected) & mask);
        }
        if (candidate.length == 16) {
            long upperMask = NetworkUtil.prefixLengthToIpV6Mask(Math.min(prefixLength, 64));
            long lowerMask = NetworkUtil.prefixLengthToIpV6Mask(Math.max(prefixLength - 64, 0));
            return (upperMask & NetworkUtil.toLong(candidate, 0)) == (upperMask & NetworkUtil.toLong(expected, 0)) && (lowerMask & NetworkUtil.toLong(candidate, 8)) == (lowerMask & NetworkUtil.toLong(expected, 8));
        }
        throw new IllegalArgumentException("how many bytes does an IP address have again?");
    }

    static int prefixLengthToIpV4Mask(int subnetPrefix) {
        return 0 == subnetPrefix ? 0 : -(1 << 32 - subnetPrefix);
    }

    private static long prefixLengthToIpV6Mask(int subnetPrefix) {
        return 0 == subnetPrefix ? 0L : -(1L << 64 - subnetPrefix);
    }

    private static int toInt(byte[] b) {
        return (b[3] & 0xFF) + ((b[2] & 0xFF) << 8) + ((b[1] & 0xFF) << 16) + (b[0] << 24);
    }

    static long toLong(byte[] b, int offset) {
        return ((long)b[offset + 7] & 0xFFL) + (((long)b[offset + 6] & 0xFFL) << 8) + (((long)b[offset + 5] & 0xFFL) << 16) + (((long)b[offset + 4] & 0xFFL) << 24) + (((long)b[offset + 3] & 0xFFL) << 32) + (((long)b[offset + 2] & 0xFFL) << 40) + (((long)b[offset + 1] & 0xFFL) << 48) + ((long)b[offset] << 56);
    }

    static class FilterResult
    implements Comparable<FilterResult> {
        private final InterfaceAddress interfaceAddress;
        private final NetworkInterface networkInterface;
        private final boolean isLoopback;

        FilterResult(InterfaceAddress interfaceAddress, NetworkInterface networkInterface, boolean isLoopback) {
            this.interfaceAddress = interfaceAddress;
            this.networkInterface = networkInterface;
            this.isLoopback = isLoopback;
        }

        @Override
        public int compareTo(FilterResult other) {
            if (this.isLoopback == other.isLoopback) {
                return -Integer.compare(this.interfaceAddress.getNetworkPrefixLength(), other.interfaceAddress.getNetworkPrefixLength());
            }
            return Boolean.compare(this.isLoopback, other.isLoopback);
        }

        public boolean equals(Object o) {
            return o instanceof FilterResult && this.compareTo((FilterResult)o) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.interfaceAddress, this.networkInterface, this.isLoopback);
        }
    }
}

