/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.response;

import io.aeron.Aeron;
import io.aeron.ChannelUriStringBuilder;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.logbuffer.FragmentHandler;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.Agent;

public class ResponseClient
implements AutoCloseable,
Agent {
    private final Aeron aeron;
    private final FragmentHandler handler;
    private final String requestEndpoint;
    private final int requestStreamId;
    private final String responseControl;
    private final int responseStreamId;
    private final ChannelUriStringBuilder requestUriBuilder;
    private final ChannelUriStringBuilder responseUriBuilder;
    private Publication publication;
    private Subscription subscription;

    public ResponseClient(Aeron aeron, FragmentHandler handler, String requestEndpoint, int requestStreamId, String responseControl, int responseStreamId, String requestChannel, String responseChannel) {
        this.aeron = aeron;
        this.handler = handler;
        this.requestEndpoint = requestEndpoint;
        this.requestStreamId = requestStreamId;
        this.responseControl = responseControl;
        this.responseStreamId = responseStreamId;
        this.requestUriBuilder = null != requestChannel ? new ChannelUriStringBuilder(requestChannel) : new ChannelUriStringBuilder();
        this.requestUriBuilder.media("udp").endpoint(requestEndpoint);
        this.responseUriBuilder = null != responseChannel ? new ChannelUriStringBuilder(responseChannel) : new ChannelUriStringBuilder();
        this.responseUriBuilder.media("udp").controlMode("response").controlEndpoint(responseControl);
    }

    public ResponseClient(Aeron aeron, FragmentHandler handler, String requestEndpoint, int requestStreamId, String responseControl, int responseStreamId) {
        this(aeron, handler, requestEndpoint, requestStreamId, responseControl, responseStreamId, null, null);
    }

    @Override
    public int doWork() {
        int workCount = 0;
        if (null == this.subscription) {
            this.subscription = this.aeron.addSubscription(this.responseUriBuilder.build(), this.responseStreamId);
        }
        if (null == this.publication && null != this.subscription) {
            this.publication = this.aeron.addPublication(this.requestUriBuilder.responseCorrelationId(this.subscription.registrationId()).build(), this.requestStreamId);
            ++workCount;
        }
        if (null != this.subscription) {
            workCount += this.subscription.poll(this.handler, 10);
        }
        return workCount;
    }

    @Override
    public String roleName() {
        return "ResponseClient";
    }

    @Override
    public void close() {
    }

    public boolean isConnected() {
        return null != this.subscription && this.subscription.isConnected() && null != this.publication && this.publication.isConnected();
    }

    public long offer(DirectBuffer message) {
        return this.publication.offer(message);
    }

    public String responseControl() {
        return this.responseControl;
    }

    public String requestEndpoint() {
        return this.requestEndpoint;
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public Publication publication() {
        return this.publication;
    }

    public String toString() {
        return "ResponseClient{publication.isConnected=" + this.publication.isConnected() + ", subscription.isConnected=" + this.subscription.isConnected() + "}";
    }
}

