/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Describes a new image recording as a notification.
 */
@SuppressWarnings("all")
public final class RecordingStartedEncoder
{
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 101;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 10;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final RecordingStartedEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public RecordingStartedEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public RecordingStartedEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int recordingIdId()
    {
        return 1;
    }

    public static int recordingIdSinceVersion()
    {
        return 0;
    }

    public static int recordingIdEncodingOffset()
    {
        return 0;
    }

    public static int recordingIdEncodingLength()
    {
        return 8;
    }

    public static String recordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long recordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long recordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public RecordingStartedEncoder recordingId(final long value)
    {
        buffer.putLong(offset + 0, value, BYTE_ORDER);
        return this;
    }


    public static int startPositionId()
    {
        return 2;
    }

    public static int startPositionSinceVersion()
    {
        return 0;
    }

    public static int startPositionEncodingOffset()
    {
        return 8;
    }

    public static int startPositionEncodingLength()
    {
        return 8;
    }

    public static String startPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long startPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long startPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long startPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public RecordingStartedEncoder startPosition(final long value)
    {
        buffer.putLong(offset + 8, value, BYTE_ORDER);
        return this;
    }


    public static int sessionIdId()
    {
        return 3;
    }

    public static int sessionIdSinceVersion()
    {
        return 0;
    }

    public static int sessionIdEncodingOffset()
    {
        return 16;
    }

    public static int sessionIdEncodingLength()
    {
        return 4;
    }

    public static String sessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int sessionIdNullValue()
    {
        return -2147483648;
    }

    public static int sessionIdMinValue()
    {
        return -2147483647;
    }

    public static int sessionIdMaxValue()
    {
        return 2147483647;
    }

    public RecordingStartedEncoder sessionId(final int value)
    {
        buffer.putInt(offset + 16, value, BYTE_ORDER);
        return this;
    }


    public static int streamIdId()
    {
        return 4;
    }

    public static int streamIdSinceVersion()
    {
        return 0;
    }

    public static int streamIdEncodingOffset()
    {
        return 20;
    }

    public static int streamIdEncodingLength()
    {
        return 4;
    }

    public static String streamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int streamIdNullValue()
    {
        return -2147483648;
    }

    public static int streamIdMinValue()
    {
        return -2147483647;
    }

    public static int streamIdMaxValue()
    {
        return 2147483647;
    }

    public RecordingStartedEncoder streamId(final int value)
    {
        buffer.putInt(offset + 20, value, BYTE_ORDER);
        return this;
    }


    public static int channelId()
    {
        return 5;
    }

    public static String channelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String channelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int channelHeaderLength()
    {
        return 4;
    }

    public RecordingStartedEncoder putChannel(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public RecordingStartedEncoder putChannel(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public RecordingStartedEncoder channel(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public RecordingStartedEncoder channel(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public static int sourceIdentityId()
    {
        return 6;
    }

    public static String sourceIdentityCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String sourceIdentityMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int sourceIdentityHeaderLength()
    {
        return 4;
    }

    public RecordingStartedEncoder putSourceIdentity(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public RecordingStartedEncoder putSourceIdentity(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public RecordingStartedEncoder sourceIdentity(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public RecordingStartedEncoder sourceIdentity(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final RecordingStartedDecoder decoder = new RecordingStartedDecoder();
        decoder.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
