/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Response to backup query that includes all relevant information for backup operation.
 */
@SuppressWarnings("all")
public final class BackupResponseDecoder
{
    public static final int BLOCK_LENGTH = 60;
    public static final int TEMPLATE_ID = 78;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final BackupResponseDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public BackupResponseDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public BackupResponseDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public BackupResponseDecoder sbeRewind()
    {
        return wrap(buffer, offset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int actingVersion()
    {
        return actingVersion;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int correlationIdId()
    {
        return 1;
    }

    public static int correlationIdSinceVersion()
    {
        return 0;
    }

    public static int correlationIdEncodingOffset()
    {
        return 0;
    }

    public static int correlationIdEncodingLength()
    {
        return 8;
    }

    public static String correlationIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long correlationIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long correlationIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long correlationId()
    {
        return buffer.getLong(offset + 0, BYTE_ORDER);
    }


    public static int logRecordingIdId()
    {
        return 2;
    }

    public static int logRecordingIdSinceVersion()
    {
        return 0;
    }

    public static int logRecordingIdEncodingOffset()
    {
        return 8;
    }

    public static int logRecordingIdEncodingLength()
    {
        return 8;
    }

    public static String logRecordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logRecordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logRecordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logRecordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logRecordingId()
    {
        return buffer.getLong(offset + 8, BYTE_ORDER);
    }


    public static int logLeadershipTermIdId()
    {
        return 3;
    }

    public static int logLeadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int logLeadershipTermIdEncodingOffset()
    {
        return 16;
    }

    public static int logLeadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String logLeadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logLeadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logLeadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logLeadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logLeadershipTermId()
    {
        return buffer.getLong(offset + 16, BYTE_ORDER);
    }


    public static int logTermBaseLogPositionId()
    {
        return 4;
    }

    public static int logTermBaseLogPositionSinceVersion()
    {
        return 0;
    }

    public static int logTermBaseLogPositionEncodingOffset()
    {
        return 24;
    }

    public static int logTermBaseLogPositionEncodingLength()
    {
        return 8;
    }

    public static String logTermBaseLogPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logTermBaseLogPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logTermBaseLogPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logTermBaseLogPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logTermBaseLogPosition()
    {
        return buffer.getLong(offset + 24, BYTE_ORDER);
    }


    public static int lastLeadershipTermIdId()
    {
        return 5;
    }

    public static int lastLeadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int lastLeadershipTermIdEncodingOffset()
    {
        return 32;
    }

    public static int lastLeadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String lastLeadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long lastLeadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long lastLeadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long lastLeadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long lastLeadershipTermId()
    {
        return buffer.getLong(offset + 32, BYTE_ORDER);
    }


    public static int lastTermBaseLogPositionId()
    {
        return 6;
    }

    public static int lastTermBaseLogPositionSinceVersion()
    {
        return 0;
    }

    public static int lastTermBaseLogPositionEncodingOffset()
    {
        return 40;
    }

    public static int lastTermBaseLogPositionEncodingLength()
    {
        return 8;
    }

    public static String lastTermBaseLogPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long lastTermBaseLogPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long lastTermBaseLogPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long lastTermBaseLogPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public long lastTermBaseLogPosition()
    {
        return buffer.getLong(offset + 40, BYTE_ORDER);
    }


    public static int commitPositionCounterIdId()
    {
        return 7;
    }

    public static int commitPositionCounterIdSinceVersion()
    {
        return 0;
    }

    public static int commitPositionCounterIdEncodingOffset()
    {
        return 48;
    }

    public static int commitPositionCounterIdEncodingLength()
    {
        return 4;
    }

    public static String commitPositionCounterIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int commitPositionCounterIdNullValue()
    {
        return -2147483648;
    }

    public static int commitPositionCounterIdMinValue()
    {
        return -2147483647;
    }

    public static int commitPositionCounterIdMaxValue()
    {
        return 2147483647;
    }

    public int commitPositionCounterId()
    {
        return buffer.getInt(offset + 48, BYTE_ORDER);
    }


    public static int leaderMemberIdId()
    {
        return 8;
    }

    public static int leaderMemberIdSinceVersion()
    {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset()
    {
        return 52;
    }

    public static int leaderMemberIdEncodingLength()
    {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int leaderMemberIdNullValue()
    {
        return -2147483648;
    }

    public static int leaderMemberIdMinValue()
    {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue()
    {
        return 2147483647;
    }

    public int leaderMemberId()
    {
        return buffer.getInt(offset + 52, BYTE_ORDER);
    }


    public static int memberIdId()
    {
        return 17;
    }

    public static int memberIdSinceVersion()
    {
        return 10;
    }

    public static int memberIdEncodingOffset()
    {
        return 56;
    }

    public static int memberIdEncodingLength()
    {
        return 4;
    }

    public static String memberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int memberIdNullValue()
    {
        return -2147483648;
    }

    public static int memberIdMinValue()
    {
        return -2147483647;
    }

    public static int memberIdMaxValue()
    {
        return 2147483647;
    }

    public int memberId()
    {
        if (parentMessage.actingVersion < 10)
        {
            return -2147483648;
        }

        return buffer.getInt(offset + 56, BYTE_ORDER);
    }


    private final SnapshotsDecoder snapshots = new SnapshotsDecoder(this);

    public static long snapshotsDecoderId()
    {
        return 9;
    }

    public static int snapshotsDecoderSinceVersion()
    {
        return 0;
    }

    /**
     * Snapshots of state for the consensus module and services.
     *
     * @return SnapshotsDecoder : Snapshots of state for the consensus module and services.
     */
    public SnapshotsDecoder snapshots()
    {
        snapshots.wrap(buffer);
        return snapshots;
    }

    /**
     * Snapshots of state for the consensus module and services.
     */

    public static final class SnapshotsDecoder
        implements Iterable<SnapshotsDecoder>, java.util.Iterator<SnapshotsDecoder>
    {
        public static final int HEADER_SIZE = 4;
        private final BackupResponseDecoder parentMessage;
        private DirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int blockLength;

        SnapshotsDecoder(final BackupResponseDecoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final DirectBuffer buffer)
        {
            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + HEADER_SIZE);
            blockLength = (buffer.getShort(limit + 0, BYTE_ORDER) & 0xFFFF);
            count = (buffer.getShort(limit + 2, BYTE_ORDER) & 0xFFFF);
        }

        public SnapshotsDecoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + blockLength);
            ++index;

            return this;
        }

        public static int countMinValue()
        {
            return 0;
        }

        public static int countMaxValue()
        {
            return 65534;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 44;
        }

        public int actingBlockLength()
        {
            return blockLength;
        }

        public int actingVersion()
        {
            return parentMessage.actingVersion;
        }

        public int count()
        {
            return count;
        }

        public java.util.Iterator<SnapshotsDecoder> iterator()
        {
            return this;
        }

        public void remove()
        {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext()
        {
            return index < count;
        }

        public static int recordingIdId()
        {
            return 10;
        }

        public static int recordingIdSinceVersion()
        {
            return 0;
        }

        public static int recordingIdEncodingOffset()
        {
            return 0;
        }

        public static int recordingIdEncodingLength()
        {
            return 8;
        }

        public static String recordingIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long recordingIdNullValue()
        {
            return -9223372036854775808L;
        }

        public static long recordingIdMinValue()
        {
            return -9223372036854775807L;
        }

        public static long recordingIdMaxValue()
        {
            return 9223372036854775807L;
        }

        public long recordingId()
        {
            return buffer.getLong(offset + 0, BYTE_ORDER);
        }


        public static int leadershipTermIdId()
        {
            return 11;
        }

        public static int leadershipTermIdSinceVersion()
        {
            return 0;
        }

        public static int leadershipTermIdEncodingOffset()
        {
            return 8;
        }

        public static int leadershipTermIdEncodingLength()
        {
            return 8;
        }

        public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long leadershipTermIdNullValue()
        {
            return -9223372036854775808L;
        }

        public static long leadershipTermIdMinValue()
        {
            return -9223372036854775807L;
        }

        public static long leadershipTermIdMaxValue()
        {
            return 9223372036854775807L;
        }

        public long leadershipTermId()
        {
            return buffer.getLong(offset + 8, BYTE_ORDER);
        }


        public static int termBaseLogPositionId()
        {
            return 12;
        }

        public static int termBaseLogPositionSinceVersion()
        {
            return 0;
        }

        public static int termBaseLogPositionEncodingOffset()
        {
            return 16;
        }

        public static int termBaseLogPositionEncodingLength()
        {
            return 8;
        }

        public static String termBaseLogPositionMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long termBaseLogPositionNullValue()
        {
            return -9223372036854775808L;
        }

        public static long termBaseLogPositionMinValue()
        {
            return -9223372036854775807L;
        }

        public static long termBaseLogPositionMaxValue()
        {
            return 9223372036854775807L;
        }

        public long termBaseLogPosition()
        {
            return buffer.getLong(offset + 16, BYTE_ORDER);
        }


        public static int logPositionId()
        {
            return 13;
        }

        public static int logPositionSinceVersion()
        {
            return 0;
        }

        public static int logPositionEncodingOffset()
        {
            return 24;
        }

        public static int logPositionEncodingLength()
        {
            return 8;
        }

        public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long logPositionNullValue()
        {
            return -9223372036854775808L;
        }

        public static long logPositionMinValue()
        {
            return -9223372036854775807L;
        }

        public static long logPositionMaxValue()
        {
            return 9223372036854775807L;
        }

        public long logPosition()
        {
            return buffer.getLong(offset + 24, BYTE_ORDER);
        }


        public static int timestampId()
        {
            return 14;
        }

        public static int timestampSinceVersion()
        {
            return 0;
        }

        public static int timestampEncodingOffset()
        {
            return 32;
        }

        public static int timestampEncodingLength()
        {
            return 8;
        }

        public static String timestampMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long timestampNullValue()
        {
            return -9223372036854775808L;
        }

        public static long timestampMinValue()
        {
            return -9223372036854775807L;
        }

        public static long timestampMaxValue()
        {
            return 9223372036854775807L;
        }

        public long timestamp()
        {
            return buffer.getLong(offset + 32, BYTE_ORDER);
        }


        public static int serviceIdId()
        {
            return 15;
        }

        public static int serviceIdSinceVersion()
        {
            return 0;
        }

        public static int serviceIdEncodingOffset()
        {
            return 40;
        }

        public static int serviceIdEncodingLength()
        {
            return 4;
        }

        public static String serviceIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int serviceIdNullValue()
        {
            return -2147483648;
        }

        public static int serviceIdMinValue()
        {
            return -2147483647;
        }

        public static int serviceIdMaxValue()
        {
            return 2147483647;
        }

        public int serviceId()
        {
            return buffer.getInt(offset + 40, BYTE_ORDER);
        }


        public StringBuilder appendTo(final StringBuilder builder)
        {
            if (null == buffer)
            {
                return builder;
            }

            builder.append('(');
            builder.append("recordingId=");
            builder.append(this.recordingId());
            builder.append('|');
            builder.append("leadershipTermId=");
            builder.append(this.leadershipTermId());
            builder.append('|');
            builder.append("termBaseLogPosition=");
            builder.append(this.termBaseLogPosition());
            builder.append('|');
            builder.append("logPosition=");
            builder.append(this.logPosition());
            builder.append('|');
            builder.append("timestamp=");
            builder.append(this.timestamp());
            builder.append('|');
            builder.append("serviceId=");
            builder.append(this.serviceId());
            builder.append(')');

            return builder;
        }
        
        public SnapshotsDecoder sbeSkip()
        {

            return this;
        }
    }

    public static int clusterMembersId()
    {
        return 16;
    }

    public static int clusterMembersSinceVersion()
    {
        return 0;
    }

    public static String clusterMembersCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String clusterMembersMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int clusterMembersHeaderLength()
    {
        return 4;
    }

    public int clusterMembersLength()
    {
        final int limit = parentMessage.limit();
        return (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
    }

    public int skipClusterMembers()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;
        parentMessage.limit(dataOffset + dataLength);

        return dataLength;
    }

    public int getClusterMembers(final MutableDirectBuffer dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public int getClusterMembers(final byte[] dst, final int dstOffset, final int length)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int bytesCopied = Math.min(length, dataLength);
        parentMessage.limit(limit + headerLength + dataLength);
        buffer.getBytes(limit + headerLength, dst, dstOffset, bytesCopied);

        return bytesCopied;
    }

    public void wrapClusterMembers(final DirectBuffer wrapBuffer)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);
        wrapBuffer.wrap(buffer, limit + headerLength, dataLength);
    }

    public String clusterMembers()
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        parentMessage.limit(limit + headerLength + dataLength);

        if (0 == dataLength)
        {
            return "";
        }

        final byte[] tmp = new byte[dataLength];
        buffer.getBytes(limit + headerLength, tmp, 0, dataLength);

        return new String(tmp, java.nio.charset.StandardCharsets.US_ASCII);
    }

    public int getClusterMembers(final Appendable appendable)
    {
        final int headerLength = 4;
        final int limit = parentMessage.limit();
        final int dataLength = (int)(buffer.getInt(limit, BYTE_ORDER) & 0xFFFF_FFFFL);
        final int dataOffset = limit + headerLength;

        parentMessage.limit(dataOffset + dataLength);
        buffer.getStringWithoutLengthAscii(dataOffset, dataLength, appendable);

        return dataLength;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final BackupResponseDecoder decoder = new BackupResponseDecoder();
        decoder.wrap(buffer, offset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(offset + actingBlockLength);
        builder.append("[BackupResponse](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("correlationId=");
        builder.append(this.correlationId());
        builder.append('|');
        builder.append("logRecordingId=");
        builder.append(this.logRecordingId());
        builder.append('|');
        builder.append("logLeadershipTermId=");
        builder.append(this.logLeadershipTermId());
        builder.append('|');
        builder.append("logTermBaseLogPosition=");
        builder.append(this.logTermBaseLogPosition());
        builder.append('|');
        builder.append("lastLeadershipTermId=");
        builder.append(this.lastLeadershipTermId());
        builder.append('|');
        builder.append("lastTermBaseLogPosition=");
        builder.append(this.lastTermBaseLogPosition());
        builder.append('|');
        builder.append("commitPositionCounterId=");
        builder.append(this.commitPositionCounterId());
        builder.append('|');
        builder.append("leaderMemberId=");
        builder.append(this.leaderMemberId());
        builder.append('|');
        builder.append("memberId=");
        builder.append(this.memberId());
        builder.append('|');
        builder.append("snapshots=[");
        final int snapshotsOriginalOffset = snapshots.offset;
        final int snapshotsOriginalIndex = snapshots.index;
        final SnapshotsDecoder snapshots = this.snapshots();
        if (snapshots.count() > 0)
        {
            while (snapshots.hasNext())
            {
                snapshots.next().appendTo(builder);
                builder.append(',');
            }
            builder.setLength(builder.length() - 1);
        }
        snapshots.offset = snapshotsOriginalOffset;
        snapshots.index = snapshotsOriginalIndex;
        builder.append(']');
        builder.append('|');
        builder.append("clusterMembers=");
        builder.append('\'');
        getClusterMembers(builder);
        builder.append('\'');

        limit(originalLimit);

        return builder;
    }
    
    public BackupResponseDecoder sbeSkip()
    {
        sbeRewind();
        SnapshotsDecoder snapshots = this.snapshots();
        if (snapshots.count() > 0)
        {
            while (snapshots.hasNext())
            {
                snapshots.next();
                snapshots.sbeSkip();
            }
        }
        skipClusterMembers();

        return this;
    }
}
