/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.logbuffer.Header;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class BufferBuilder {
    static final int MAX_CAPACITY = 0x7FFFFFF7;
    static final int INIT_MIN_CAPACITY = 4096;
    private final boolean isDirect;
    private int limit;
    private int nextTermOffset = -1;
    private final UnsafeBuffer buffer = new UnsafeBuffer();
    final UnsafeBuffer headerBuffer = new UnsafeBuffer();
    final Header completeHeader = new Header(0, 0);

    public BufferBuilder() {
        this(0, false);
    }

    public BufferBuilder(int initialCapacity) {
        this(initialCapacity, false);
    }

    public BufferBuilder(int initialCapacity, boolean isDirect) {
        if (initialCapacity < 0 || initialCapacity > 0x7FFFFFF7) {
            throw new IllegalArgumentException("initialCapacity outside range 0 - 2147483639: initialCapacity=" + initialCapacity);
        }
        this.isDirect = isDirect;
        if (isDirect) {
            if (initialCapacity > 0) {
                this.buffer.wrap(BufferBuilder.newDirectBuffer(initialCapacity));
            }
            this.headerBuffer.wrap(BufferBuilder.newDirectBuffer(32));
        } else {
            if (initialCapacity > 0) {
                this.buffer.wrap(new byte[initialCapacity]);
            }
            this.headerBuffer.wrap(new byte[32]);
        }
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        if (limit < 0 || limit >= this.buffer.capacity()) {
            throw new IllegalArgumentException("limit outside range: capacity=" + this.buffer.capacity() + " limit=" + limit);
        }
        this.limit = limit;
    }

    public int nextTermOffset() {
        return this.nextTermOffset;
    }

    public void nextTermOffset(int offset) {
        this.nextTermOffset = offset;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public BufferBuilder reset() {
        this.limit = 0;
        this.nextTermOffset = -1;
        this.completeHeader.context(null).fragmentedFrameLength(-1);
        return this;
    }

    public BufferBuilder compact() {
        int newCapacity = Math.max(4096, this.limit);
        if (newCapacity < this.buffer.capacity()) {
            this.resize(newCapacity);
        }
        return this;
    }

    public BufferBuilder append(DirectBuffer srcBuffer, int srcOffset, int length) {
        this.ensureCapacity(length);
        this.buffer.putBytes(this.limit, srcBuffer, srcOffset, length);
        this.limit += length;
        return this;
    }

    public BufferBuilder captureHeader(Header header) {
        this.completeHeader.initialTermId(header.initialTermId()).positionBitsToShift(header.positionBitsToShift()).offset(0).buffer(this.headerBuffer);
        this.headerBuffer.putBytes(0, header.buffer(), header.offset(), 32);
        return this;
    }

    public Header completeHeader(Header header) {
        int firstFrameLength = this.headerBuffer.getInt(0, ByteOrder.LITTLE_ENDIAN);
        int fragmentedFrameLength = LogBufferDescriptor.computeFragmentedFrameLength(this.limit, firstFrameLength - 32);
        this.completeHeader.context(header.context()).fragmentedFrameLength(fragmentedFrameLength);
        this.headerBuffer.putInt(0, 32 + this.limit, ByteOrder.LITTLE_ENDIAN);
        this.headerBuffer.putByte(5, (byte)(this.headerBuffer.getByte(5) | header.flags()));
        return this.completeHeader;
    }

    private void ensureCapacity(int additionalLength) {
        long requiredCapacity = (long)this.limit + (long)additionalLength;
        int capacity = this.buffer.capacity();
        if (requiredCapacity > (long)capacity) {
            if (requiredCapacity > 0x7FFFFFF7L) {
                throw new IllegalStateException("insufficient capacity: maxCapacity=2147483639 limit=" + this.limit + " additionalLength=" + additionalLength);
            }
            this.resize(BufferBuilder.findSuitableCapacity(capacity, requiredCapacity));
        }
    }

    private void resize(int newCapacity) {
        if (this.isDirect) {
            ByteBuffer byteBuffer = BufferBuilder.newDirectBuffer(newCapacity);
            this.buffer.getBytes(0, byteBuffer, 0, this.limit);
            this.buffer.wrap(byteBuffer);
        } else {
            this.buffer.wrap(Arrays.copyOf(this.buffer.byteArray(), newCapacity));
        }
    }

    private static ByteBuffer newDirectBuffer(int newCapacity) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(newCapacity);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer;
    }

    static int findSuitableCapacity(int capacity, long requiredCapacity) {
        long newCapacity = Math.max(capacity, 4096);
        while (newCapacity < requiredCapacity) {
            if ((newCapacity += newCapacity >> 1) <= 0x7FFFFFF7L) continue;
            newCapacity = 0x7FFFFFF7L;
            break;
        }
        return (int)newCapacity;
    }
}

