/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.ChannelUriStringBuilder;
import io.aeron.ExclusivePublication;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.Catalog;
import io.aeron.archive.ControlSession;
import io.aeron.archive.RecordingSummary;
import io.aeron.archive.Session;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.client.ArchiveProxy;
import io.aeron.archive.client.ControlResponsePoller;
import io.aeron.archive.client.RecordingDescriptorConsumer;
import io.aeron.archive.client.RecordingDescriptorPoller;
import io.aeron.archive.client.ReplayParams;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.TimeoutException;
import java.util.concurrent.TimeUnit;
import org.agrona.CloseHelper;
import org.agrona.Strings;
import org.agrona.concurrent.CachedEpochClock;
import org.agrona.concurrent.CountedErrorHandler;

class ReplicationSession
implements Session,
RecordingDescriptorConsumer {
    private static final int REPLAY_REMOVE_THRESHOLD = 0;
    private static final int RETRY_ATTEMPTS = 3;
    private final int replicationSessionId;
    private long activeCorrelationId = -1L;
    private long srcReplaySessionId = -1L;
    private long replayPosition = -1L;
    private long srcStopPosition = -1L;
    private long srcRecordingPosition = -1L;
    private final long dstStopPosition;
    private final boolean isDestinationRecordingEmpty;
    private long timeOfLastActionMs;
    private final long actionTimeoutMs;
    private final long replicationId;
    private final long channelTagId;
    private final long subscriptionTagId;
    private final long srcRecordingId;
    private long dstRecordingId;
    private int replayStreamId;
    private int replaySessionId;
    private int retryAttempts = 3;
    private boolean isLiveAdded;
    private final boolean isTagged;
    private final String replicationChannel;
    private final String liveDestination;
    private String replayDestination;
    private final CachedEpochClock epochClock;
    private final ArchiveConductor conductor;
    private final ControlSession controlSession;
    private final Catalog catalog;
    private final int fileIoMaxLength;
    private final Aeron aeron;
    private final AeronArchive.Context context;
    private AeronArchive.AsyncConnect asyncConnect;
    private AeronArchive srcArchive;
    private Subscription recordingSubscription;
    private Image image;
    private State state = State.CONNECT;
    private long replayToken = -1L;
    private long responsePublicationRegistrationId = -1L;
    private ExclusivePublication responsePublication = null;
    private ArchiveProxy responseArchiveProxy = null;

    ReplicationSession(long srcRecordingId, long dstRecordingId, long channelTagId, long subscriptionTagId, long replicationId, long stopPosition, String liveDestination, String replicationChannel, int fileIoMaxLength, int replicationSessionId, RecordingSummary recordingSummary, AeronArchive.Context context, CachedEpochClock epochClock, Catalog catalog, ControlSession controlSession) {
        this.replicationId = replicationId;
        this.srcRecordingId = srcRecordingId;
        this.dstRecordingId = dstRecordingId;
        this.liveDestination = Strings.isEmpty(liveDestination) ? null : liveDestination;
        this.replicationChannel = replicationChannel;
        this.fileIoMaxLength = fileIoMaxLength;
        this.replicationSessionId = replicationSessionId;
        this.aeron = context.aeron();
        this.context = context;
        this.catalog = catalog;
        this.epochClock = epochClock;
        this.conductor = controlSession.archiveConductor();
        this.controlSession = controlSession;
        this.actionTimeoutMs = TimeUnit.NANOSECONDS.toMillis(context.messageTimeoutNs());
        this.dstStopPosition = stopPosition;
        this.isTagged = -1L != channelTagId || -1L != subscriptionTagId;
        this.channelTagId = -1L == channelTagId ? replicationId : channelTagId;
        long l = this.subscriptionTagId = -1L == subscriptionTagId ? replicationId : subscriptionTagId;
        if (null != recordingSummary) {
            this.replayPosition = recordingSummary.stopPosition;
            this.replayStreamId = recordingSummary.streamId;
            this.isDestinationRecordingEmpty = recordingSummary.startPosition == recordingSummary.stopPosition;
        } else {
            this.isDestinationRecordingEmpty = false;
        }
    }

    @Override
    public long sessionId() {
        return this.replicationId;
    }

    @Override
    public boolean isDone() {
        return this.state == State.DONE;
    }

    @Override
    public void abort(String reason) {
        this.state(State.DONE, "abort");
    }

    @Override
    public void close() {
        ArchiveConductor archiveConductor = this.controlSession.archiveConductor();
        CountedErrorHandler countedErrorHandler = archiveConductor.context().countedErrorHandler();
        this.stopRecording();
        this.stopReplaySession(countedErrorHandler);
        CloseHelper.close(countedErrorHandler, this.asyncConnect);
        CloseHelper.close(countedErrorHandler, this.srcArchive);
        CloseHelper.close(countedErrorHandler, this.responsePublication);
        archiveConductor.removeReplicationSession(this);
        this.signal(-1L, RecordingSignal.REPLICATE_END);
    }

    @Override
    public int doWork() {
        int workCount = 0;
        try {
            if (null != this.recordingSubscription && this.recordingSubscription.isClosed()) {
                this.state(State.DONE, "recording subscription closed");
                return 1;
            }
            switch (this.state) {
                case CONNECT: {
                    workCount += this.connect();
                    break;
                }
                case REPLICATE_DESCRIPTOR: {
                    workCount += this.replicateDescriptor();
                    break;
                }
                case SRC_RECORDING_POSITION: {
                    workCount += this.srcRecordingPosition();
                    break;
                }
                case EXTEND: {
                    workCount += this.extend();
                    break;
                }
                case REPLAY_TOKEN: {
                    workCount += this.replayToken();
                    break;
                }
                case GET_ARCHIVE_PROXY: {
                    workCount += this.getArchiveProxy();
                    break;
                }
                case REPLAY: {
                    workCount += this.replay();
                    break;
                }
                case AWAIT_IMAGE: {
                    workCount += this.awaitImage();
                    break;
                }
                case REPLICATE: {
                    workCount += this.replicate();
                    break;
                }
                case CATCHUP: {
                    workCount += this.catchup();
                    break;
                }
                case ATTEMPT_LIVE_JOIN: {
                    workCount += this.attemptLiveJoin();
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.state(State.DONE, ex.getMessage());
            this.error(ex.getMessage(), 0);
            throw ex;
        }
        return workCount;
    }

    @Override
    public void onRecordingDescriptor(long controlSessionId, long correlationId, long recordingId, long startTimestamp, long stopTimestamp, long startPosition, long stopPosition, int initialTermId, int segmentFileLength, int termBufferLength, int mtuLength, int sessionId, int streamId, String strippedChannel, String originalChannel, String sourceIdentity) {
        this.srcStopPosition = stopPosition;
        this.replayStreamId = streamId;
        this.replaySessionId = null == this.liveDestination && -1 != this.replicationSessionId ? this.replicationSessionId : sessionId;
        if (-1 != this.fileIoMaxLength && this.fileIoMaxLength < mtuLength) {
            String errorMsg = "Replication fileIoMaxLength (" + this.fileIoMaxLength + ") is less than than the recording mtuLength (" + mtuLength + ")";
            this.state(State.DONE, errorMsg);
            this.error(errorMsg, 0);
            return;
        }
        if (-1L == this.dstRecordingId) {
            this.replayPosition = startPosition;
            this.dstRecordingId = this.catalog.addNewRecording(startPosition, startPosition, startTimestamp, startTimestamp, initialTermId, segmentFileLength, termBufferLength, mtuLength, sessionId, streamId, strippedChannel, originalChannel, sourceIdentity);
            this.signal(startPosition, RecordingSignal.REPLICATE);
        } else if (this.isDestinationRecordingEmpty) {
            this.replayPosition = startPosition;
            this.catalog.replaceRecording(this.dstRecordingId, startPosition, startPosition, startTimestamp, startTimestamp, initialTermId, segmentFileLength, termBufferLength, mtuLength, sessionId, streamId, strippedChannel, originalChannel, sourceIdentity);
        }
        State nextState = State.EXTEND;
        Object reason = "";
        if (null != this.liveDestination) {
            if (-1L != stopPosition) {
                String errorMsg = "cannot live merge without active source recording";
                this.state(State.DONE, "cannot live merge without active source recording");
                this.error("cannot live merge without active source recording", 0);
                return;
            }
            nextState = State.SRC_RECORDING_POSITION;
            reason = "liveDestination=" + this.liveDestination;
        }
        if (startPosition == stopPosition || -1L != this.dstRecordingId && stopPosition == this.catalog.stopPosition(this.dstRecordingId)) {
            this.signal(stopPosition, RecordingSignal.SYNC);
            nextState = State.DONE;
            reason = "in sync";
        }
        this.state(nextState, (String)reason);
    }

    private int connect() {
        int workCount = 0;
        if (null == this.asyncConnect) {
            this.asyncConnect = AeronArchive.asyncConnect(this.context);
            ++workCount;
        } else {
            int step = this.asyncConnect.step();
            try {
                AeronArchive archive = this.asyncConnect.poll();
                if (null == archive) {
                    if (this.asyncConnect.step() != step) {
                        ++workCount;
                    }
                } else {
                    this.srcArchive = archive;
                    this.asyncConnect = null;
                    this.state(State.REPLICATE_DESCRIPTOR, "connected to the Archive");
                    ++workCount;
                }
            }
            catch (AeronException ex) {
                this.state(State.DONE, ex.getMessage());
                this.error("Replication connection failed=" + ex.getMessage(), 14);
            }
        }
        return workCount;
    }

    private int replicateDescriptor() {
        int workCount = 0;
        if (-1L == this.activeCorrelationId) {
            long correlationId = this.aeron.nextCorrelationId();
            if (this.srcArchive.archiveProxy().listRecording(this.srcRecordingId, correlationId, this.srcArchive.controlSessionId())) {
                workCount += this.trackAction(correlationId);
                this.srcArchive.recordingDescriptorPoller().reset(correlationId, 1, this);
            } else if (this.epochClock.time() >= this.timeOfLastActionMs + this.actionTimeoutMs) {
                throw new TimeoutException("failed to list remote recording descriptor");
            }
        } else {
            RecordingDescriptorPoller poller = this.srcArchive.recordingDescriptorPoller();
            int fragments = poller.poll();
            if (poller.isDispatchComplete() && poller.remainingRecordCount() > 0) {
                String errorMsg = "unknown src recording id " + this.srcRecordingId;
                this.state(State.DONE, errorMsg);
                this.error(errorMsg, 5);
            }
            if (0 == fragments && this.epochClock.time() >= this.timeOfLastActionMs + this.actionTimeoutMs) {
                throw new TimeoutException("failed to fetch remote recording descriptor");
            }
            workCount += fragments;
        }
        return workCount;
    }

    private int srcRecordingPosition() {
        int workCount = 0;
        if (-1L == this.activeCorrelationId) {
            long correlationId = this.aeron.nextCorrelationId();
            long controlSessionId = this.srcArchive.controlSessionId();
            if (this.srcArchive.archiveProxy().getRecordingPosition(this.srcRecordingId, correlationId, controlSessionId)) {
                workCount += this.trackAction(correlationId);
            } else if (this.epochClock.time() >= this.timeOfLastActionMs + this.actionTimeoutMs) {
                throw new TimeoutException("failed to send recording position request");
            }
        } else {
            ControlResponsePoller poller = this.srcArchive.controlResponsePoller();
            workCount += poller.poll();
            if (this.hasResponse(poller)) {
                this.srcRecordingPosition = poller.relevantId();
                if (-1L == this.srcRecordingPosition && null != this.liveDestination) {
                    throw new ArchiveException("cannot live merge without active source recording");
                }
                this.state(State.EXTEND, "");
            } else if (this.epochClock.time() >= this.timeOfLastActionMs + this.actionTimeoutMs) {
                throw new TimeoutException("failed to get recording position");
            }
        }
        return workCount;
    }

    private int extend() {
        String channel;
        Object recordingSubscriptionOrErrorMsg;
        boolean isMds = this.isTagged || null != this.liveDestination;
        ChannelUri channelUri = ChannelUri.parse(this.replicationChannel);
        String endpoint = channelUri.get("endpoint");
        channelUri.put("rejoin", "false");
        if (!channelUri.hasControlModeResponse()) {
            channelUri.put("session-id", Integer.toString(this.replaySessionId));
        }
        if (isMds) {
            channelUri.remove("endpoint");
            channelUri.put("tags", this.channelTagId + "," + this.subscriptionTagId);
            channelUri.put("control-mode", "manual");
        }
        if ((recordingSubscriptionOrErrorMsg = this.conductor.extendRecording(this.replicationId, this.dstRecordingId, this.replayStreamId, SourceLocation.REMOTE, true, channel = channelUri.toString(), this.controlSession)) instanceof Subscription) {
            this.recordingSubscription = (Subscription)recordingSubscriptionOrErrorMsg;
            if (isMds) {
                this.replayDestination = ChannelUri.createDestinationUri(this.replicationChannel, endpoint);
                this.recordingSubscription.asyncAddDestination(this.replayDestination);
                this.state(State.REPLAY_TOKEN, "replay destination added: " + this.replayDestination);
            } else {
                this.state(State.REPLAY_TOKEN, "replay destination added");
            }
        } else {
            this.state(State.DONE, (String)recordingSubscriptionOrErrorMsg);
        }
        return 1;
    }

    private int replayToken() {
        int workCount = 0;
        if (-1L != this.replayToken || !ChannelUri.parse(this.replicationChannel).hasControlModeResponse()) {
            this.state(State.GET_ARCHIVE_PROXY, "");
            return ++workCount;
        }
        if (-1L == this.activeCorrelationId) {
            long lastCorrelationId = this.aeron.nextCorrelationId();
            if (this.srcArchive.archiveProxy().requestReplayToken(lastCorrelationId, this.srcArchive.controlSessionId(), this.srcRecordingId)) {
                ++workCount;
                this.activeCorrelationId = lastCorrelationId;
            } else {
                return workCount;
            }
        }
        ControlResponsePoller poller = this.srcArchive.controlResponsePoller();
        workCount += poller.poll();
        if (this.hasResponse(poller)) {
            this.replayToken = poller.relevantId();
            this.state(State.GET_ARCHIVE_PROXY, "");
        }
        return workCount;
    }

    private int getArchiveProxy() {
        int workCount = 0;
        if (-1L == this.replayToken) {
            this.state(State.REPLAY, "");
            return ++workCount;
        }
        if (-1L == this.responsePublicationRegistrationId) {
            String uri = new ChannelUriStringBuilder(this.context.controlRequestChannel()).responseCorrelationId(this.recordingSubscription.registrationId()).termId((Integer)null).initialTermId((Integer)null).termOffset((Integer)null).termLength(65536).build();
            int controlRequestStreamId = this.srcArchive.context().controlRequestStreamId();
            this.responsePublicationRegistrationId = this.aeron.asyncAddExclusivePublication(uri, controlRequestStreamId);
        }
        if (null == this.responsePublication) {
            this.responsePublication = this.aeron.getExclusivePublication(this.responsePublicationRegistrationId);
            if (null != this.responsePublication) {
                ++workCount;
            } else {
                return workCount;
            }
        }
        if (this.responsePublication.isConnected()) {
            ++workCount;
        } else {
            return workCount;
        }
        if (0L >= this.responsePublication.availableWindow()) {
            return workCount;
        }
        this.responseArchiveProxy = new ArchiveProxy(this.responsePublication);
        this.state(State.REPLAY, "ArchiveProxy created");
        return ++workCount;
    }

    private int replay() {
        int workCount = 0;
        if (-1L == this.activeCorrelationId) {
            ArchiveProxy archiveProxy;
            String resolvedEndpoint = this.recordingSubscription.resolvedEndpoint();
            if (null == resolvedEndpoint) {
                if (this.epochClock.time() >= this.timeOfLastActionMs + this.actionTimeoutMs) {
                    throw new TimeoutException("failed to resolve subscription endpoint: channel=" + this.recordingSubscription.channel());
                }
                return workCount;
            }
            ChannelUri channelUri = ChannelUri.parse(this.replicationChannel);
            channelUri.put("session-id", Integer.toString(this.replaySessionId));
            String endpoint = channelUri.get("endpoint");
            if (null != endpoint) {
                channelUri.replaceEndpointWildcardPort(resolvedEndpoint);
            }
            if (null != this.liveDestination) {
                channelUri.put("linger", "0");
                channelUri.put("eos", "false");
            }
            if (channelUri.hasControlModeResponse()) {
                channelUri.put("response-correlation-id", String.valueOf(this.recordingSubscription.registrationId()));
            }
            long correlationId = this.aeron.nextCorrelationId();
            ReplayParams replayParams = new ReplayParams().position(this.replayPosition).length(-1L == this.dstStopPosition ? -1L : this.dstStopPosition - this.replayPosition).fileIoMaxLength(this.fileIoMaxLength).replayToken(this.replayToken);
            ArchiveProxy archiveProxy2 = archiveProxy = null != this.responseArchiveProxy ? this.responseArchiveProxy : this.srcArchive.archiveProxy();
            if (archiveProxy.replay(this.srcRecordingId, channelUri.toString(), this.replayStreamId, replayParams, correlationId, this.srcArchive.controlSessionId())) {
                workCount += this.trackAction(correlationId);
            } else if (this.epochClock.time() >= this.timeOfLastActionMs + this.actionTimeoutMs) {
                throw new TimeoutException("failed to send replay request");
            }
        } else {
            ControlResponsePoller poller = this.srcArchive.controlResponsePoller();
            workCount += poller.poll();
            if (this.hasResponse(poller)) {
                this.srcReplaySessionId = poller.relevantId();
                this.state(State.AWAIT_IMAGE, "srcReplaySessionId=" + this.srcReplaySessionId);
            } else if (this.epochClock.time() >= this.timeOfLastActionMs + this.actionTimeoutMs) {
                throw new TimeoutException("failed get acknowledgement of replay request to: " + this.replicationChannel);
            }
        }
        return workCount;
    }

    private int awaitImage() {
        int workCount = 0;
        Image image = this.recordingSubscription.imageBySessionId(this.replaySessionId);
        if (null != image) {
            this.image = image;
            this.state(null == this.liveDestination ? State.REPLICATE : State.CATCHUP, "image.correlationId=" + image.correlationId() + ", image.sessionId=" + image.sessionId() + ", image.joinPosition=" + image.joinPosition());
            ++workCount;
        } else if (this.epochClock.time() >= this.timeOfLastActionMs + this.actionTimeoutMs) {
            throw new TimeoutException("failed get replay image for sessionId " + this.replaySessionId + " on channel " + this.recordingSubscription.channel());
        }
        return workCount;
    }

    private int replicate() {
        boolean isSynced;
        int workCount = 0;
        boolean isClosed = this.image.isClosed();
        boolean isEndOfStream = this.image.isEndOfStream();
        long position = this.image.position();
        boolean bl = isSynced = -1L != this.srcStopPosition && position >= this.srcStopPosition;
        if (isSynced || -1L != this.dstStopPosition && position >= this.dstStopPosition || isEndOfStream || isClosed) {
            this.logReplicationSessionDone(this.controlSession.sessionId(), this.replicationId, this.srcRecordingId, this.replayPosition, this.srcStopPosition, this.dstRecordingId, this.dstStopPosition, position, isClosed, isEndOfStream, isSynced);
            if (isSynced) {
                this.signal(position, RecordingSignal.SYNC);
            }
            this.srcReplaySessionId = -1L;
            this.state(State.DONE, isSynced ? "sync" : "done");
            ++workCount;
        }
        return workCount;
    }

    private int catchup() {
        int workCount = 0;
        if (this.image.position() >= this.srcRecordingPosition) {
            this.state(State.ATTEMPT_LIVE_JOIN, "image position (" + this.image.position() + ") >= srcRecordingPosition (" + this.srcRecordingPosition + ")");
            ++workCount;
        } else if (this.image.isClosed()) {
            throw new ArchiveException("replication image closed unexpectedly");
        }
        return workCount;
    }

    private int attemptLiveJoin() {
        int workCount = 0;
        if (-1L == this.activeCorrelationId) {
            long correlationId = this.aeron.nextCorrelationId();
            if (this.srcArchive.archiveProxy().getRecordingPosition(this.srcRecordingId, correlationId, this.srcArchive.controlSessionId())) {
                workCount += this.trackAction(correlationId);
            } else if (this.epochClock.time() >= this.timeOfLastActionMs + this.actionTimeoutMs) {
                throw new TimeoutException("failed to send recording position request");
            }
        } else {
            ControlResponsePoller poller = this.srcArchive.controlResponsePoller();
            workCount += poller.poll();
            if (this.hasResponse(poller)) {
                this.trackAction(-1L);
                this.retryAttempts = 3;
                this.srcRecordingPosition = poller.relevantId();
                if (-1L == this.srcRecordingPosition && null != this.liveDestination) {
                    throw new ArchiveException("cannot live merge without active source recording");
                }
                long position = this.image.position();
                if (this.shouldAddLiveDestination(position)) {
                    this.recordingSubscription.asyncAddDestination(this.liveDestination);
                    this.isLiveAdded = true;
                } else if (this.shouldStopReplay(position)) {
                    this.recordingSubscription.asyncRemoveDestination(this.replayDestination);
                    this.replayDestination = null;
                    this.recordingSubscription = null;
                    this.signal(position, RecordingSignal.MERGE);
                    this.state(State.DONE, "merge");
                }
                ++workCount;
            } else {
                if (this.image.isClosed()) {
                    throw new ArchiveException("replication image closed unexpectedly");
                }
                if (this.epochClock.time() >= this.timeOfLastActionMs + this.actionTimeoutMs) {
                    if (--this.retryAttempts == 0) {
                        throw new TimeoutException("failed to get recording position");
                    }
                    this.trackAction(-1L);
                }
            }
        }
        return workCount;
    }

    private boolean hasResponse(ControlResponsePoller poller) {
        if (poller.isPollComplete() && poller.controlSessionId() == this.srcArchive.controlSessionId()) {
            ControlResponseCode code = poller.code();
            if (ControlResponseCode.ERROR == code) {
                throw new ArchiveException(poller.errorMessage(), (int)poller.relevantId());
            }
            return poller.correlationId() == this.activeCorrelationId && ControlResponseCode.OK == code;
        }
        return false;
    }

    private void error(String msg, int errorCode) {
        this.controlSession.sendErrorResponse(this.replicationId, errorCode, msg);
    }

    private void signal(long position, RecordingSignal recordingSignal) {
        long subscriptionId = null != this.recordingSubscription ? this.recordingSubscription.registrationId() : -1L;
        this.controlSession.sendSignal(this.replicationId, this.dstRecordingId, subscriptionId, position, recordingSignal);
    }

    private void stopReplaySession(CountedErrorHandler countedErrorHandler) {
        if (-1L != this.srcReplaySessionId) {
            try {
                this.srcArchive.archiveProxy().stopReplay(this.srcReplaySessionId, this.aeron.nextCorrelationId(), this.srcArchive.controlSessionId());
            }
            catch (Exception ex) {
                countedErrorHandler.onError(ex);
            }
            this.srcReplaySessionId = -1L;
        }
    }

    private void stopRecording() {
        if (null != this.recordingSubscription) {
            this.conductor.stopRecordingSubscription(this.recordingSubscription.registrationId());
            this.recordingSubscription = null;
        }
    }

    private boolean shouldAddLiveDestination(long position) {
        return !this.isLiveAdded && this.srcRecordingPosition - position <= (long)Math.min(this.image.termBufferLength() >> 2, 0x2000000);
    }

    private boolean shouldStopReplay(long position) {
        return this.isLiveAdded && this.srcRecordingPosition - position <= 0L && this.image.activeTransportCount() >= 2;
    }

    private int trackAction(long correlationId) {
        this.timeOfLastActionMs = this.epochClock.time();
        this.activeCorrelationId = correlationId;
        return 1;
    }

    private void state(State newState, String reason) {
        this.logStateChange(this.state, newState, this.replicationId, this.srcRecordingId, this.dstRecordingId, null != this.image ? this.image.position() : -1L, null == reason ? "" : reason);
        this.state = newState;
        this.activeCorrelationId = -1L;
        this.timeOfLastActionMs = this.epochClock.time();
    }

    private void logStateChange(State oldState, State newState, long replicationId, long srcRecordingId, long dstRecordingId, long position, String reason) {
    }

    private void logReplicationSessionDone(long controlSessionId, long replicationId, long srcRecordingId, long replayPosition, long srcStopPosition, long dstRecordingId, long dstStopPosition, long position, boolean isClosed, boolean isEndOfStream, boolean isSynced) {
    }

    static enum State {
        CONNECT,
        REPLICATE_DESCRIPTOR,
        SRC_RECORDING_POSITION,
        EXTEND,
        REPLAY_TOKEN,
        GET_ARCHIVE_PROXY,
        REPLAY,
        AWAIT_IMAGE,
        REPLICATE,
        CATCHUP,
        ATTEMPT_LIVE_JOIN,
        DONE;

    }
}

