/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.checksum;

import io.aeron.archive.checksum.Checksum;
import org.agrona.Strings;
import org.agrona.checksum.Crc32;
import org.agrona.checksum.Crc32c;

public final class Checksums {
    private static final Checksum CRC_32 = Crc32.INSTANCE::compute;
    private static final Checksum CRC_32C = Crc32c.INSTANCE::compute;

    public static Checksum crc32() {
        return CRC_32;
    }

    public static Checksum crc32c() {
        return CRC_32C;
    }

    public static Checksum newInstance(String className) {
        Checksum checksum;
        if (Strings.isEmpty(className)) {
            throw new IllegalArgumentException("className is empty");
        }
        switch (className) {
            case "CRC-32": 
            case "io.aeron.archive.checksum.Crc32": 
            case "org.agrona.checksum.Crc32": {
                Checksum checksum2;
                checksum = checksum2 = Checksums.crc32();
                break;
            }
            case "CRC-32C": 
            case "io.aeron.archive.checksum.Crc32c": 
            case "org.agrona.checksum.Crc32c": {
                Checksum checksum3;
                checksum = checksum3 = Checksums.crc32c();
                break;
            }
            default: {
                try {
                    Checksum checksum4;
                    Class<?> klass = Class.forName(className);
                    Object instance = klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    checksum = checksum4 = (Checksum)instance;
                    break;
                }
                catch (ReflectiveOperationException ex) {
                    throw new IllegalArgumentException("failed to create Checksum instance for class: " + className, ex);
                }
            }
        }
        return checksum;
    }
}

