/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.BooleanType;
import io.aeron.archive.codecs.ListRecordingSubscriptionsRequestDecoder;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class ListRecordingSubscriptionsRequestEncoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 17;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 10;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ListRecordingSubscriptionsRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 17;
    }

    public int sbeSchemaId() {
        return 101;
    }

    public int sbeSchemaVersion() {
        return 10;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ListRecordingSubscriptionsRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 32);
        return this;
    }

    public ListRecordingSubscriptionsRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(32).templateId(17).schemaId(101).version(10);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdId() {
        return 1;
    }

    public static int controlSessionIdSinceVersion() {
        return 0;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ListRecordingSubscriptionsRequestEncoder controlSessionId(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ListRecordingSubscriptionsRequestEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int pseudoIndexId() {
        return 3;
    }

    public static int pseudoIndexSinceVersion() {
        return 0;
    }

    public static int pseudoIndexEncodingOffset() {
        return 16;
    }

    public static int pseudoIndexEncodingLength() {
        return 4;
    }

    public static String pseudoIndexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int pseudoIndexNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int pseudoIndexMinValue() {
        return -2147483647;
    }

    public static int pseudoIndexMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ListRecordingSubscriptionsRequestEncoder pseudoIndex(int value) {
        this.buffer.putInt(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public static int subscriptionCountId() {
        return 4;
    }

    public static int subscriptionCountSinceVersion() {
        return 0;
    }

    public static int subscriptionCountEncodingOffset() {
        return 20;
    }

    public static int subscriptionCountEncodingLength() {
        return 4;
    }

    public static String subscriptionCountMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int subscriptionCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int subscriptionCountMinValue() {
        return -2147483647;
    }

    public static int subscriptionCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ListRecordingSubscriptionsRequestEncoder subscriptionCount(int value) {
        this.buffer.putInt(this.offset + 20, value, BYTE_ORDER);
        return this;
    }

    public static int applyStreamIdId() {
        return 5;
    }

    public static int applyStreamIdSinceVersion() {
        return 0;
    }

    public static int applyStreamIdEncodingOffset() {
        return 24;
    }

    public static int applyStreamIdEncodingLength() {
        return 4;
    }

    public static String applyStreamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public ListRecordingSubscriptionsRequestEncoder applyStreamId(BooleanType value) {
        this.buffer.putInt(this.offset + 24, value.value(), BYTE_ORDER);
        return this;
    }

    public static int streamIdId() {
        return 6;
    }

    public static int streamIdSinceVersion() {
        return 0;
    }

    public static int streamIdEncodingOffset() {
        return 28;
    }

    public static int streamIdEncodingLength() {
        return 4;
    }

    public static String streamIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int streamIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int streamIdMinValue() {
        return -2147483647;
    }

    public static int streamIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ListRecordingSubscriptionsRequestEncoder streamId(int value) {
        this.buffer.putInt(this.offset + 28, value, BYTE_ORDER);
        return this;
    }

    public static int channelId() {
        return 7;
    }

    public static String channelCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String channelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int channelHeaderLength() {
        return 4;
    }

    public ListRecordingSubscriptionsRequestEncoder putChannel(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public ListRecordingSubscriptionsRequestEncoder putChannel(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public ListRecordingSubscriptionsRequestEncoder channel(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public ListRecordingSubscriptionsRequestEncoder channel(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ListRecordingSubscriptionsRequestDecoder decoder = new ListRecordingSubscriptionsRequestDecoder();
        decoder.wrap(this.buffer, this.offset, 32, 10);
        return decoder.appendTo(builder);
    }
}

