/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.cluster.ConsensusModuleAgent;
import io.aeron.cluster.StandbySnapshotEntry;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.AppendPositionDecoder;
import io.aeron.cluster.codecs.BackupQueryDecoder;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.CanvassPositionDecoder;
import io.aeron.cluster.codecs.CatchupPositionDecoder;
import io.aeron.cluster.codecs.ChallengeResponseDecoder;
import io.aeron.cluster.codecs.CommitPositionDecoder;
import io.aeron.cluster.codecs.HeartbeatRequestDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.NewLeadershipTermDecoder;
import io.aeron.cluster.codecs.RequestVoteDecoder;
import io.aeron.cluster.codecs.StandbySnapshotDecoder;
import io.aeron.cluster.codecs.StopCatchupDecoder;
import io.aeron.cluster.codecs.TerminationAckDecoder;
import io.aeron.cluster.codecs.TerminationPositionDecoder;
import io.aeron.cluster.codecs.VoteDecoder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.ArrayList;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.collections.ArrayUtil;

class ConsensusAdapter
implements FragmentHandler,
AutoCloseable {
    static final int FRAGMENT_LIMIT = 10;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final CanvassPositionDecoder canvassPositionDecoder = new CanvassPositionDecoder();
    private final RequestVoteDecoder requestVoteDecoder = new RequestVoteDecoder();
    private final VoteDecoder voteDecoder = new VoteDecoder();
    private final NewLeadershipTermDecoder newLeadershipTermDecoder = new NewLeadershipTermDecoder();
    private final AppendPositionDecoder appendPositionDecoder = new AppendPositionDecoder();
    private final CommitPositionDecoder commitPositionDecoder = new CommitPositionDecoder();
    private final CatchupPositionDecoder catchupPositionDecoder = new CatchupPositionDecoder();
    private final StopCatchupDecoder stopCatchupDecoder = new StopCatchupDecoder();
    private final TerminationPositionDecoder terminationPositionDecoder = new TerminationPositionDecoder();
    private final TerminationAckDecoder terminationAckDecoder = new TerminationAckDecoder();
    private final BackupQueryDecoder backupQueryDecoder = new BackupQueryDecoder();
    private final ChallengeResponseDecoder challengeResponseDecoder = new ChallengeResponseDecoder();
    private final HeartbeatRequestDecoder heartbeatRequestDecoder = new HeartbeatRequestDecoder();
    private final StandbySnapshotDecoder standbySnapshotDecoder = new StandbySnapshotDecoder();
    private final FragmentAssembler fragmentAssembler = new FragmentAssembler(this);
    private final Subscription subscription;
    private final ConsensusModuleAgent consensusModuleAgent;

    ConsensusAdapter(Subscription subscription, ConsensusModuleAgent consensusModuleAgent) {
        this.subscription = subscription;
        this.consensusModuleAgent = consensusModuleAgent;
    }

    @Override
    public void close() {
        CloseHelper.close(this.subscription);
    }

    public int poll() {
        return this.subscription.poll(this.fragmentAssembler, 10);
    }

    public int poll(int limit) {
        return this.subscription.poll(this.fragmentAssembler, limit);
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        switch (this.messageHeaderDecoder.templateId()) {
            case 50: {
                this.canvassPositionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onCanvassPosition(this.canvassPositionDecoder.logLeadershipTermId(), this.canvassPositionDecoder.logPosition(), this.canvassPositionDecoder.leadershipTermId(), this.canvassPositionDecoder.followerMemberId(), this.canvassPositionDecoder.protocolVersion());
                break;
            }
            case 51: {
                this.requestVoteDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onRequestVote(this.requestVoteDecoder.logLeadershipTermId(), this.requestVoteDecoder.logPosition(), this.requestVoteDecoder.candidateTermId(), this.requestVoteDecoder.candidateMemberId(), this.requestVoteDecoder.protocolVersion());
                break;
            }
            case 52: {
                this.voteDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onVote(this.voteDecoder.candidateTermId(), this.voteDecoder.logLeadershipTermId(), this.voteDecoder.logPosition(), this.voteDecoder.candidateMemberId(), this.voteDecoder.followerMemberId(), this.voteDecoder.vote() == BooleanType.TRUE);
                break;
            }
            case 53: {
                this.newLeadershipTermDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onNewLeadershipTerm(this.newLeadershipTermDecoder.logLeadershipTermId(), this.newLeadershipTermDecoder.nextLeadershipTermId(), this.newLeadershipTermDecoder.nextTermBaseLogPosition(), this.newLeadershipTermDecoder.nextLogPosition(), this.newLeadershipTermDecoder.leadershipTermId(), this.newLeadershipTermDecoder.termBaseLogPosition(), this.newLeadershipTermDecoder.logPosition(), this.newLeadershipTermDecoder.leaderRecordingId(), this.newLeadershipTermDecoder.timestamp(), this.newLeadershipTermDecoder.leaderMemberId(), this.newLeadershipTermDecoder.logSessionId(), this.newLeadershipTermDecoder.appVersion(), this.newLeadershipTermDecoder.isStartup() == BooleanType.TRUE);
                break;
            }
            case 54: {
                this.appendPositionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                short flagsDecodedValue = this.appendPositionDecoder.flags();
                short flags = AppendPositionDecoder.flagsNullValue() == flagsDecodedValue ? (short)0 : flagsDecodedValue;
                this.consensusModuleAgent.onAppendPosition(this.appendPositionDecoder.leadershipTermId(), this.appendPositionDecoder.logPosition(), this.appendPositionDecoder.followerMemberId(), flags);
                break;
            }
            case 55: {
                this.commitPositionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onCommitPosition(this.commitPositionDecoder.leadershipTermId(), this.commitPositionDecoder.logPosition(), this.commitPositionDecoder.leaderMemberId());
                break;
            }
            case 56: {
                this.catchupPositionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onCatchupPosition(this.catchupPositionDecoder.leadershipTermId(), this.catchupPositionDecoder.logPosition(), this.catchupPositionDecoder.followerMemberId(), this.catchupPositionDecoder.catchupEndpoint());
                break;
            }
            case 57: {
                this.stopCatchupDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onStopCatchup(this.stopCatchupDecoder.leadershipTermId(), this.stopCatchupDecoder.followerMemberId());
                break;
            }
            case 75: {
                this.terminationPositionDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onTerminationPosition(this.terminationPositionDecoder.leadershipTermId(), this.terminationPositionDecoder.logPosition());
                break;
            }
            case 76: {
                this.terminationAckDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.consensusModuleAgent.onTerminationAck(this.terminationAckDecoder.leadershipTermId(), this.terminationAckDecoder.logPosition(), this.terminationAckDecoder.memberId());
                break;
            }
            case 77: {
                byte[] credentials;
                this.backupQueryDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                String responseChannel = this.backupQueryDecoder.responseChannel();
                int credentialsLength = this.backupQueryDecoder.encodedCredentialsLength();
                if (credentialsLength > 0) {
                    credentials = new byte[credentialsLength];
                    this.backupQueryDecoder.getEncodedCredentials(credentials, 0, credentials.length);
                } else {
                    credentials = ArrayUtil.EMPTY_BYTE_ARRAY;
                }
                this.consensusModuleAgent.onBackupQuery(this.backupQueryDecoder.correlationId(), this.backupQueryDecoder.responseStreamId(), this.backupQueryDecoder.version(), responseChannel, credentials);
                break;
            }
            case 8: {
                this.challengeResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                byte[] credentials = new byte[this.challengeResponseDecoder.encodedCredentialsLength()];
                this.challengeResponseDecoder.getEncodedCredentials(credentials, 0, credentials.length);
                this.consensusModuleAgent.onConsensusChallengeResponse(this.challengeResponseDecoder.correlationId(), this.challengeResponseDecoder.clusterSessionId(), credentials);
                break;
            }
            case 79: {
                byte[] credentials;
                this.heartbeatRequestDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                String responseChannel = this.heartbeatRequestDecoder.responseChannel();
                int credentialsLength = this.heartbeatRequestDecoder.encodedCredentialsLength();
                if (credentialsLength > 0) {
                    credentials = new byte[credentialsLength];
                    this.heartbeatRequestDecoder.getEncodedCredentials(credentials, 0, credentials.length);
                } else {
                    credentials = ArrayUtil.EMPTY_BYTE_ARRAY;
                }
                this.consensusModuleAgent.onHeartbeatRequest(this.heartbeatRequestDecoder.correlationId(), this.heartbeatRequestDecoder.responseStreamId(), responseChannel, credentials);
                break;
            }
            case 81: {
                byte[] encodedCredentials;
                this.standbySnapshotDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long correlationId = this.standbySnapshotDecoder.correlationId();
                int version = this.standbySnapshotDecoder.version();
                int responseStreamId = this.standbySnapshotDecoder.responseStreamId();
                ArrayList<StandbySnapshotEntry> standbySnapshotEntries = new ArrayList<StandbySnapshotEntry>();
                for (StandbySnapshotDecoder.SnapshotsDecoder standbySnapshot : this.standbySnapshotDecoder.snapshots()) {
                    standbySnapshotEntries.add(new StandbySnapshotEntry(standbySnapshot.recordingId(), standbySnapshot.leadershipTermId(), standbySnapshot.termBaseLogPosition(), standbySnapshot.logPosition(), standbySnapshot.timestamp(), standbySnapshot.serviceId(), standbySnapshot.archiveEndpoint()));
                }
                String responseChannel = this.standbySnapshotDecoder.responseChannel();
                if (0 == this.standbySnapshotDecoder.encodedCredentialsLength()) {
                    encodedCredentials = ArrayUtil.EMPTY_BYTE_ARRAY;
                } else {
                    encodedCredentials = new byte[this.standbySnapshotDecoder.encodedCredentialsLength()];
                    this.standbySnapshotDecoder.getEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
                }
                this.consensusModuleAgent.onStandbySnapshot(correlationId, version, standbySnapshotEntries, responseStreamId, responseChannel, encodedCredentials);
            }
        }
    }
}

