/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.ConsensusModuleDecoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public final class ConsensusModuleEncoder {
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 105;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ConsensusModuleEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 28;
    }

    public int sbeTemplateId() {
        return 105;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ConsensusModuleEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 28);
        return this;
    }

    public ConsensusModuleEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(28).templateId(105).schemaId(111).version(12);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int nextSessionIdId() {
        return 1;
    }

    public static int nextSessionIdSinceVersion() {
        return 0;
    }

    public static int nextSessionIdEncodingOffset() {
        return 0;
    }

    public static int nextSessionIdEncodingLength() {
        return 8;
    }

    public static String nextSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long nextSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long nextSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long nextSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ConsensusModuleEncoder nextSessionId(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int nextServiceSessionIdId() {
        return 2;
    }

    public static int nextServiceSessionIdSinceVersion() {
        return 3;
    }

    public static int nextServiceSessionIdEncodingOffset() {
        return 8;
    }

    public static int nextServiceSessionIdEncodingLength() {
        return 8;
    }

    public static String nextServiceSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long nextServiceSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long nextServiceSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long nextServiceSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ConsensusModuleEncoder nextServiceSessionId(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int logServiceSessionIdId() {
        return 3;
    }

    public static int logServiceSessionIdSinceVersion() {
        return 3;
    }

    public static int logServiceSessionIdEncodingOffset() {
        return 16;
    }

    public static int logServiceSessionIdEncodingLength() {
        return 8;
    }

    public static String logServiceSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long logServiceSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logServiceSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long logServiceSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ConsensusModuleEncoder logServiceSessionId(long value) {
        this.buffer.putLong(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public static int pendingMessageCapacityId() {
        return 4;
    }

    public static int pendingMessageCapacitySinceVersion() {
        return 3;
    }

    public static int pendingMessageCapacityEncodingOffset() {
        return 24;
    }

    public static int pendingMessageCapacityEncodingLength() {
        return 4;
    }

    public static String pendingMessageCapacityMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int pendingMessageCapacityNullValue() {
        return 0;
    }

    public static int pendingMessageCapacityMinValue() {
        return -2147483647;
    }

    public static int pendingMessageCapacityMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ConsensusModuleEncoder pendingMessageCapacity(int value) {
        this.buffer.putInt(this.offset + 24, value, BYTE_ORDER);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ConsensusModuleDecoder decoder = new ConsensusModuleDecoder();
        decoder.wrap(this.buffer, this.offset, 28, 12);
        return decoder.appendTo(builder);
    }
}

