/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.ClusterTimeUnit;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import io.aeron.cluster.codecs.NewLeadershipTermEventDecoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public final class NewLeadershipTermEventEncoder {
    public static final int BLOCK_LENGTH = 48;
    public static final int TEMPLATE_ID = 24;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 12;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NewLeadershipTermEventEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 48;
    }

    public int sbeTemplateId() {
        return 24;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 12;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public NewLeadershipTermEventEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 48);
        return this;
    }

    public NewLeadershipTermEventEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(48).templateId(24).schemaId(111).version(12);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int leadershipTermIdId() {
        return 1;
    }

    public static int leadershipTermIdSinceVersion() {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset() {
        return 0;
    }

    public static int leadershipTermIdEncodingLength() {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long leadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long leadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public NewLeadershipTermEventEncoder leadershipTermId(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int logPositionId() {
        return 2;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 8;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public NewLeadershipTermEventEncoder logPosition(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int timestampId() {
        return 3;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 16;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return Long.MIN_VALUE;
    }

    public static long timestampMinValue() {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue() {
        return Long.MAX_VALUE;
    }

    public NewLeadershipTermEventEncoder timestamp(long value) {
        this.buffer.putLong(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public static int termBaseLogPositionId() {
        return 4;
    }

    public static int termBaseLogPositionSinceVersion() {
        return 0;
    }

    public static int termBaseLogPositionEncodingOffset() {
        return 24;
    }

    public static int termBaseLogPositionEncodingLength() {
        return 8;
    }

    public static String termBaseLogPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long termBaseLogPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long termBaseLogPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long termBaseLogPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public NewLeadershipTermEventEncoder termBaseLogPosition(long value) {
        this.buffer.putLong(this.offset + 24, value, BYTE_ORDER);
        return this;
    }

    public static int leaderMemberIdId() {
        return 5;
    }

    public static int leaderMemberIdSinceVersion() {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset() {
        return 32;
    }

    public static int leaderMemberIdEncodingLength() {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int leaderMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int leaderMemberIdMinValue() {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public NewLeadershipTermEventEncoder leaderMemberId(int value) {
        this.buffer.putInt(this.offset + 32, value, BYTE_ORDER);
        return this;
    }

    public static int logSessionIdId() {
        return 6;
    }

    public static int logSessionIdSinceVersion() {
        return 0;
    }

    public static int logSessionIdEncodingOffset() {
        return 36;
    }

    public static int logSessionIdEncodingLength() {
        return 4;
    }

    public static String logSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int logSessionIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int logSessionIdMinValue() {
        return -2147483647;
    }

    public static int logSessionIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public NewLeadershipTermEventEncoder logSessionId(int value) {
        this.buffer.putInt(this.offset + 36, value, BYTE_ORDER);
        return this;
    }

    public static int timeUnitId() {
        return 7;
    }

    public static int timeUnitSinceVersion() {
        return 4;
    }

    public static int timeUnitEncodingOffset() {
        return 40;
    }

    public static int timeUnitEncodingLength() {
        return 4;
    }

    public static String timeUnitMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public NewLeadershipTermEventEncoder timeUnit(ClusterTimeUnit value) {
        this.buffer.putInt(this.offset + 40, value.value(), BYTE_ORDER);
        return this;
    }

    public static int appVersionId() {
        return 8;
    }

    public static int appVersionSinceVersion() {
        return 4;
    }

    public static int appVersionEncodingOffset() {
        return 44;
    }

    public static int appVersionEncodingLength() {
        return 4;
    }

    public static String appVersionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int appVersionNullValue() {
        return 0;
    }

    public static int appVersionMinValue() {
        return 1;
    }

    public static int appVersionMaxValue() {
        return 0xFFFFFF;
    }

    public NewLeadershipTermEventEncoder appVersion(int value) {
        this.buffer.putInt(this.offset + 44, value, BYTE_ORDER);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        NewLeadershipTermEventDecoder decoder = new NewLeadershipTermEventDecoder();
        decoder.wrap(this.buffer, this.offset, 48, 12);
        return decoder.appendTo(builder);
    }
}

