/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum DefaultType {
    UNDEFINED("", "", false),
    BOOLEAN("java.lang.Boolean", "Boolean", false),
    INT("java.lang.Integer", "Integer", true),
    LONG("java.lang.Long", "Long", true),
    DOUBLE("java.lang.Double", "Double", true),
    STRING("java.lang.String", "String", false);

    private static final Map<String, DefaultType> BY_CANONICAL_NAME;
    private final String canonicalName;
    private final String simpleName;
    private final boolean numeric;

    public static DefaultType fromCanonicalName(String canonicalName) {
        return BY_CANONICAL_NAME.getOrDefault(canonicalName, UNDEFINED);
    }

    public static boolean isUndefined(DefaultType defaultType) {
        return Objects.isNull((Object)defaultType) || UNDEFINED == defaultType;
    }

    private DefaultType(String canonicalName, String simpleName, boolean numeric) {
        this.canonicalName = canonicalName;
        this.simpleName = simpleName;
        this.numeric = numeric;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    static {
        BY_CANONICAL_NAME = new HashMap<String, DefaultType>();
        for (DefaultType t : DefaultType.values()) {
            BY_CANONICAL_NAME.put(t.canonicalName, t);
        }
    }
}

