/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.driver.Configuration;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.IpcPublication;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.NetworkPublication;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.exceptions.InvalidChannelException;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.BitUtil;
import org.agrona.SystemUtil;

final class PublicationParams {
    long lingerTimeoutNs;
    long entityTag = -1L;
    long untetheredWindowLimitTimeoutNs;
    long untetheredRestingTimeoutNs;
    long responseCorrelationId = -1L;
    int termLength;
    int mtuLength;
    int publicationWindowLength;
    int initialTermId;
    int termId;
    int termOffset;
    int sessionId;
    int streamId;
    int maxResend;
    boolean hasPosition;
    boolean isSessionIdTagged;
    boolean signalEos;
    boolean isSparse;
    boolean spiesSimulateConnection;
    boolean isResponse;

    PublicationParams() {
    }

    static PublicationParams getPublicationParams(ChannelUri channelUri, MediaDriver.Context ctx, DriverConductor driverConductor, int streamId, String canonicalForm) {
        PublicationParams params = new PublicationParams();
        params.termLength = channelUri.isIpc() ? ctx.ipcTermBufferLength() : ctx.publicationTermBufferLength();
        params.mtuLength = channelUri.isIpc() ? ctx.ipcMtuLength() : ctx.mtuLength();
        params.getStreamId(channelUri, streamId);
        params.getEntityTag(channelUri, driverConductor);
        params.getSessionId(channelUri, driverConductor, streamId, canonicalForm);
        params.getTermBufferLength(channelUri);
        params.getMtuLength(channelUri);
        params.getPublicationWindowLength(channelUri, ctx);
        params.getLingerTimeoutNs(channelUri, ctx);
        params.getEos(channelUri);
        params.getSparse(channelUri, ctx);
        params.getSpiesSimulateConnection(channelUri, ctx);
        params.getUntetheredWindowLimitTimeout(channelUri, ctx);
        params.getUntetheredRestingTimeout(channelUri, ctx);
        params.getMaxResend(channelUri, ctx);
        int count = 0;
        String initialTermIdStr = channelUri.get("init-term-id");
        count = initialTermIdStr != null ? count + 1 : count;
        String termIdStr = channelUri.get("term-id");
        count = termIdStr != null ? count + 1 : count;
        String termOffsetStr = channelUri.get("term-offset");
        int n = count = termOffsetStr != null ? count + 1 : count;
        if (count > 0) {
            if (count < 3) {
                throw new InvalidChannelException("params must be used as a complete set: init-term-id term-id term-offset channel=" + String.valueOf(channelUri));
            }
            params.initialTermId = Integer.parseInt(initialTermIdStr);
            params.termId = Integer.parseInt(termIdStr);
            params.termOffset = Integer.parseInt(termOffsetStr);
            if (params.termOffset > params.termLength) {
                throw new InvalidChannelException("term-offset=" + params.termOffset + " > term-length=" + params.termLength + ": channel=" + String.valueOf(channelUri));
            }
            if (params.termOffset < 0 || params.termOffset > 0x40000000) {
                throw new InvalidChannelException("term-offset=" + params.termOffset + " out of range: channel=" + String.valueOf(channelUri));
            }
            if ((params.termOffset & 0x1F) != 0) {
                throw new InvalidChannelException("term-offset=" + params.termOffset + " must be a multiple of FRAME_ALIGNMENT: channel=" + String.valueOf(channelUri));
            }
            if (params.termId - params.initialTermId < 0) {
                throw new InvalidChannelException("difference greater than 2^31 - 1: init-term-id=" + params.initialTermId + " when term-id=" + params.termId + " channel=" + String.valueOf(channelUri));
            }
            params.hasPosition = true;
        } else {
            params.termId = params.initialTermId = BitUtil.generateRandomisedId();
            params.termOffset = 0;
        }
        params.isResponse = "response".equals(channelUri.get("control-mode"));
        params.responseCorrelationId = Long.parseLong(channelUri.get("response-correlation-id", "-1"));
        return params;
    }

    private void getPublicationWindowLength(ChannelUri channelUri, MediaDriver.Context ctx) {
        String pubWindowParam = channelUri.get("pub-wnd");
        if (null != pubWindowParam) {
            long pubWindow = SystemUtil.parseSize("pub-wnd", pubWindowParam);
            if (pubWindow < (long)this.mtuLength) {
                throw new InvalidChannelException("pub-wnd=" + pubWindow + " cannot be less than the mtu=" + this.mtuLength);
            }
            if (pubWindow > (long)(this.termLength >> 1)) {
                throw new InvalidChannelException("pub-wnd=" + pubWindow + " must not exceed half the term-length=" + this.termLength);
            }
            this.publicationWindowLength = (int)pubWindow;
        } else {
            this.publicationWindowLength = Configuration.producerWindowLength(this.termLength, channelUri.isIpc() ? ctx.ipcPublicationTermWindowLength() : ctx.publicationTermWindowLength());
        }
    }

    private void getStreamId(ChannelUri channelUri, int streamId) {
        String streamIdParam = channelUri.get("stream-id");
        if (null != streamIdParam) {
            int configuredStreamId;
            try {
                configuredStreamId = Integer.parseInt(streamIdParam);
            }
            catch (NumberFormatException ex) {
                throw new InvalidChannelException("invalid stream-id, must be a number", (Exception)ex);
            }
            if (streamId != configuredStreamId) {
                throw new InvalidChannelException("stream-id=" + configuredStreamId + " does not match provided streamId=" + streamId);
            }
        }
        this.streamId = streamId;
    }

    private void getEntityTag(ChannelUri channelUri, DriverConductor driverConductor) {
        String tagParam = channelUri.entityTag();
        if (null != tagParam) {
            this.entityTag = PublicationParams.parseEntityTag(tagParam, driverConductor, channelUri);
        }
    }

    private void getTermBufferLength(ChannelUri channelUri) {
        String termLengthParam = channelUri.get("term-length");
        if (null != termLengthParam) {
            int termLength = (int)SystemUtil.parseSize("term-length", termLengthParam);
            LogBufferDescriptor.checkTermLength(termLength);
            PublicationParams.validateTermLength(this, termLength, channelUri);
            this.termLength = termLength;
        }
    }

    private void getMtuLength(ChannelUri channelUri) {
        int maxMessageLength;
        String mtuParam = channelUri.get("mtu");
        if (null != mtuParam) {
            int mtuLength = (int)SystemUtil.parseSize("mtu", mtuParam);
            Configuration.validateMtuLength(mtuLength);
            PublicationParams.validateMtuLength(this, mtuLength, channelUri);
            this.mtuLength = mtuLength;
        }
        if (this.mtuLength > (maxMessageLength = FrameDescriptor.computeMaxMessageLength(this.termLength))) {
            throw new InvalidChannelException("MTU greater than max message length for term length: mtu=" + this.mtuLength + " maxMessageLength=" + maxMessageLength + " termLength=" + this.termLength + " channel=" + String.valueOf(channelUri));
        }
    }

    static void validateTermLength(PublicationParams params, int explicitTermLength, ChannelUri channelUri) {
        if (params.isSessionIdTagged && explicitTermLength != params.termLength) {
            throw new InvalidChannelException("term-length=" + explicitTermLength + " does not match session-id tag value: channel=" + String.valueOf(channelUri));
        }
    }

    static void validateMtuLength(PublicationParams params, int explicitMtuLength, ChannelUri channelUri) {
        if (params.isSessionIdTagged && explicitMtuLength != params.mtuLength) {
            throw new InvalidChannelException("mtu=" + explicitMtuLength + " does not match session-id tag value: channel=" + String.valueOf(channelUri));
        }
    }

    private static String formatMatchError(String paramName, String existingValue, String newValue, String existingChannelUri, String newChannelUri) {
        return "existing publication has different '" + paramName + "': existing=" + existingValue + " requested=" + newValue + " existingChannel=" + existingChannelUri + " channel=" + newChannelUri;
    }

    static void confirmMatch(ChannelUri channelUri, PublicationParams params, RawLog rawLog, int existingSessionId, String existingChannel, int existingInitialTermId, int existingTermId, int existingTermOffset) {
        int mtuLength = LogBufferDescriptor.mtuLength(rawLog.metaData());
        if (channelUri.containsKey("mtu") && mtuLength != params.mtuLength) {
            throw new IllegalStateException(PublicationParams.formatMatchError("mtu", String.valueOf(mtuLength), String.valueOf(params.mtuLength), existingChannel, channelUri.toString()));
        }
        if (channelUri.containsKey("term-length") && rawLog.termLength() != params.termLength) {
            throw new IllegalStateException(PublicationParams.formatMatchError("term-length", String.valueOf(rawLog.termLength()), String.valueOf(params.termLength), existingChannel, channelUri.toString()));
        }
        if (channelUri.containsKey("session-id") && params.sessionId != existingSessionId) {
            throw new IllegalStateException(PublicationParams.formatMatchError("session-id", String.valueOf(existingSessionId), String.valueOf(params.sessionId), existingChannel, channelUri.toString()));
        }
        if (channelUri.containsKey("init-term-id") && params.initialTermId != existingInitialTermId) {
            throw new IllegalStateException(PublicationParams.formatMatchError("init-term-id", String.valueOf(existingInitialTermId), String.valueOf(params.initialTermId), existingChannel, channelUri.toString()));
        }
        if (channelUri.containsKey("term-id") && params.termId != existingTermId) {
            throw new IllegalStateException(PublicationParams.formatMatchError("term-id", String.valueOf(existingTermId), String.valueOf(params.termId), existingChannel, channelUri.toString()));
        }
        if (channelUri.containsKey("term-offset") && params.termOffset != existingTermOffset) {
            throw new IllegalStateException(PublicationParams.formatMatchError("term-offset", String.valueOf(existingTermOffset), String.valueOf(params.termOffset), existingChannel, channelUri.toString()));
        }
    }

    static void validateSpiesSimulateConnection(PublicationParams params, boolean existingSpiesSimulateConnection, String channel, String existingChannel) {
        if (params.spiesSimulateConnection != existingSpiesSimulateConnection) {
            throw new IllegalStateException("existing publication has different spiesSimulateConnection: existing=" + existingSpiesSimulateConnection + " requested=" + params.spiesSimulateConnection + " existingChannel=" + existingChannel + " channel=" + channel);
        }
    }

    static void validateMtuForSndbuf(PublicationParams params, int channelSocketSndbufLength, MediaDriver.Context ctx, String channel, String existingChannel) {
        if (0 != channelSocketSndbufLength && params.mtuLength > channelSocketSndbufLength) {
            throw new IllegalStateException("MTU greater than SO_SNDBUF for channel: mtu=" + params.mtuLength + " so-sndbuf=" + channelSocketSndbufLength + (String)(null == existingChannel ? "" : " existingChannel=" + existingChannel) + " channel=" + channel);
        }
        if (0 == channelSocketSndbufLength && params.mtuLength > ctx.osDefaultSocketSndbufLength()) {
            throw new IllegalStateException("MTU greater than SO_SNDBUF for channel: mtu=" + params.mtuLength + " so-sndbuf=" + ctx.osDefaultSocketSndbufLength() + " (OS default)" + (String)(null == existingChannel ? "" : " existingChannel=" + existingChannel) + " channel=" + channel);
        }
    }

    private void getLingerTimeoutNs(ChannelUri channelUri, MediaDriver.Context ctx) {
        String lingerParam = channelUri.get("linger");
        this.lingerTimeoutNs = null != lingerParam ? SystemUtil.parseDuration("linger", lingerParam) : ctx.publicationLingerTimeoutNs();
    }

    private void getSessionId(ChannelUri channelUri, DriverConductor driverConductor, int streamId, String canonicalForm) {
        String sessionIdStr = channelUri.get("session-id");
        if (null != sessionIdStr) {
            this.isSessionIdTagged = ChannelUri.isTagged(sessionIdStr);
            if (this.isSessionIdTagged) {
                long tag;
                try {
                    tag = ChannelUri.getTag(sessionIdStr);
                }
                catch (RuntimeException ex) {
                    throw new InvalidChannelException("session-id=" + sessionIdStr + " has an invalid tag: channel=" + String.valueOf(channelUri), (Exception)ex);
                }
                if (channelUri.isIpc()) {
                    IpcPublication publication = driverConductor.findIpcPublicationByTag(tag);
                    if (null == publication) {
                        throw new InvalidChannelException("session-id=" + sessionIdStr + " must reference an IPC publication: channel=" + String.valueOf(channelUri));
                    }
                    this.sessionId = publication.sessionId();
                    this.mtuLength = publication.mtuLength();
                    this.termLength = publication.termBufferLength();
                } else {
                    NetworkPublication publication = driverConductor.findNetworkPublicationByTag(tag);
                    if (null == publication) {
                        throw new InvalidChannelException("session-id=" + sessionIdStr + " must reference a network publication: channel=" + String.valueOf(channelUri));
                    }
                    this.sessionId = publication.sessionId();
                    this.mtuLength = publication.mtuLength();
                    this.termLength = publication.termBufferLength();
                }
            } else {
                this.sessionId = Integer.parseInt(sessionIdStr);
            }
        } else {
            this.sessionId = driverConductor.nextAvailableSessionId(streamId, canonicalForm);
        }
    }

    private void getEos(ChannelUri channelUri) {
        String eosStr = channelUri.get("eos");
        this.signalEos = null == eosStr || "true".equals(eosStr);
    }

    private void getSparse(ChannelUri channelUri, MediaDriver.Context ctx) {
        String sparseStr = channelUri.get("sparse");
        this.isSparse = null != sparseStr ? "true".equals(sparseStr) : ctx.termBufferSparseFile();
    }

    private void getSpiesSimulateConnection(ChannelUri channelUri, MediaDriver.Context ctx) {
        String sscStr = channelUri.get("ssc");
        this.spiesSimulateConnection = null != sscStr ? "true".equals(sscStr) : ctx.spiesSimulateConnection();
    }

    private long getTimeoutNs(ChannelUri channelUri, String paramName, long defaultValue) {
        String timeoutString = channelUri.get(paramName);
        return null != timeoutString ? SystemUtil.parseDuration(paramName, timeoutString) : defaultValue;
    }

    private void getUntetheredWindowLimitTimeout(ChannelUri channelUri, MediaDriver.Context ctx) {
        this.untetheredWindowLimitTimeoutNs = this.getTimeoutNs(channelUri, "untethered-window-limit-timeout", ctx.untetheredWindowLimitTimeoutNs());
    }

    private void getUntetheredRestingTimeout(ChannelUri channelUri, MediaDriver.Context ctx) {
        this.untetheredRestingTimeoutNs = this.getTimeoutNs(channelUri, "untethered-resting-timeout", ctx.untetheredRestingTimeoutNs());
    }

    private void getMaxResend(ChannelUri channelUri, MediaDriver.Context ctx) {
        String maxRetransmtsString = channelUri.get("max-resend");
        if (maxRetransmtsString == null) {
            this.maxResend = ctx.maxResend();
        } else {
            try {
                this.maxResend = Integer.parseInt(maxRetransmtsString);
            }
            catch (NumberFormatException ex) {
                throw new InvalidChannelException("invalid max-resend, must be a number", (Exception)ex);
            }
            if (this.maxResend <= 0 || this.maxResend > 256) {
                throw new InvalidChannelException("invalid max-resend=" + this.maxResend + ", must be > 0 and <= 256");
            }
        }
    }

    private static long parseEntityTag(String tagParam, DriverConductor driverConductor, ChannelUri channelUri) {
        long entityTag;
        try {
            entityTag = Long.parseLong(tagParam);
        }
        catch (NumberFormatException ex) {
            throw new InvalidChannelException("invalid entity tag, must be a number", (Exception)ex);
        }
        if (-1L == entityTag) {
            throw new InvalidChannelException("-1 tag is reserved: channel=" + String.valueOf(channelUri));
        }
        NetworkPublication networkPublication = driverConductor.findNetworkPublicationByTag(entityTag);
        if (null != networkPublication) {
            throw new InvalidChannelException(entityTag + " entityTag already in use: existingChannel=" + networkPublication.channel() + " channel=" + String.valueOf(channelUri));
        }
        IpcPublication ipcPublication = driverConductor.findIpcPublicationByTag(entityTag);
        if (null != ipcPublication) {
            throw new InvalidChannelException(entityTag + " entityTag already in use: existingChannel=" + ipcPublication.channel() + " channel=" + String.valueOf(channelUri));
        }
        return entityTag;
    }

    public String toString() {
        return "PublicationParams{lingerTimeoutNs=" + this.lingerTimeoutNs + ", entityTag=" + this.entityTag + ", termLength=" + this.termLength + ", mtuLength=" + this.mtuLength + ", initialTermId=" + this.initialTermId + ", termId=" + this.termId + ", termOffset=" + this.termOffset + ", streamId=" + this.streamId + ", sessionId=" + this.sessionId + ", hasPosition=" + this.hasPosition + ", isSessionIdTagged=" + this.isSessionIdTagged + ", isSparse=" + this.isSparse + ", signalEos=" + this.signalEos + ", spiesSimulateConnection=" + this.spiesSimulateConnection + ", maxResend=" + this.maxResend + ", publicationWindowLength=" + this.publicationWindowLength + "}";
    }
}

