/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AbstractMinMulticastFlowControl;
import io.aeron.driver.PreferredMulticastFlowControl;
import io.aeron.protocol.ErrorFlyweight;
import io.aeron.protocol.StatusMessageFlyweight;
import java.net.InetSocketAddress;

public class TaggedMulticastFlowControl
extends AbstractMinMulticastFlowControl {
    public static final String FC_PARAM_VALUE = "tagged";

    TaggedMulticastFlowControl() {
        super(true);
    }

    @Override
    public long onStatusMessage(StatusMessageFlyweight flyweight, InetSocketAddress receiverAddress, long senderLimit, int initialTermId, int positionBitsToShift, long timeNs) {
        return this.processStatusMessage(flyweight, senderLimit, initialTermId, positionBitsToShift, timeNs, this.matchesTag(flyweight));
    }

    @Override
    public void onTriggerSendSetup(StatusMessageFlyweight flyweight, InetSocketAddress receiverAddress, long timeNs) {
        this.processSendSetupTrigger(flyweight, receiverAddress, timeNs, this.matchesTag(flyweight));
    }

    @Override
    public void onError(ErrorFlyweight errorFlyweight, InetSocketAddress receiverAddress, long timeNs) {
        this.processError(errorFlyweight, receiverAddress, timeNs, this.matchesTag(errorFlyweight));
    }

    private boolean matchesTag(StatusMessageFlyweight flyweight) {
        int offset;
        int asfLength = flyweight.asfLength();
        boolean result = false;
        if (asfLength == 8) {
            if (flyweight.groupTag() == super.groupTag()) {
                result = true;
            }
        } else if (asfLength >= 4 && flyweight.getByte(offset = StatusMessageFlyweight.groupTagFieldOffset()) == PreferredMulticastFlowControl.PREFERRED_ASF_BYTES[0] && flyweight.getByte(offset + 1) == PreferredMulticastFlowControl.PREFERRED_ASF_BYTES[1] && flyweight.getByte(offset + 2) == PreferredMulticastFlowControl.PREFERRED_ASF_BYTES[2] && flyweight.getByte(offset + 3) == PreferredMulticastFlowControl.PREFERRED_ASF_BYTES[3]) {
            result = true;
        }
        return result;
    }

    private boolean matchesTag(ErrorFlyweight errorFlyweight) {
        return errorFlyweight.hasGroupTag() && errorFlyweight.groupTag() == super.groupTag();
    }
}

