/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.stress;

import io.aeron.ChannelUriStringBuilder;
import io.aeron.Image;
import io.aeron.samples.stress.CRC64;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.agrona.DirectBuffer;

public class StressUtil {
    static final int BASE_PORT = 9000;
    static final int BASE_STREAM_ID = 10000;
    static final int UNICAST_REQ_OFFSET = 1;
    static final int UNICAST_RSP_OFFSET = 2;
    static final int UNICAST_STREAM_ID_OFFSET = 1;
    static final int MDC_STREAM_ID_OFFSET = 2;
    static final int UNICAST_STREAM_ID = 10001;
    static final int MDC_STREAM_ID = 10002;
    static final int MDC_REQ_OFFSET_1 = 3;
    static final int MDC_REQ_OFFSET_2 = 4;
    static final int MDC_REQ_CONTROL_OFFSET = 5;
    static final int MDC_RSP_OFFSET_1 = 6;
    static final int MDC_RSP_OFFSET_2 = 7;
    static final int MDC_RSP_CONTROL_OFFSET = 8;
    static final long RSP_GROUP_TAG = 1001L;
    static final long REQ_GROUP_TAG = 1002L;
    static final int SERVER_RECV_COUNT = 1000;
    static final int SERVER_SEND_COUNT = 1001;
    static final int CLIENT_RECV_COUNT = 1002;
    static final int CLIENT_SEND_COUNT = 1003;
    static final List<Integer> MTU_LENGTHS = Arrays.asList(1408, 4000, 8192, 16384, 32768, 65504);

    public static void info(String message) {
        System.out.println(message);
    }

    public static ChannelUriStringBuilder unicastReqChannel(String serverAddress) {
        return new ChannelUriStringBuilder().media("udp").endpoint(serverAddress + ":9001");
    }

    public static ChannelUriStringBuilder unicastRspChannel(String clientAddress) {
        return new ChannelUriStringBuilder().media("udp").endpoint(clientAddress + ":9002");
    }

    private static ChannelUriStringBuilder mdcChannel(String endpointAddress, int endpointOffset, String controlAddress, int controlOffset) {
        return new ChannelUriStringBuilder().media("udp").endpoint(endpointAddress + ":" + (9000 + endpointOffset)).controlEndpoint(controlAddress + ":" + (9000 + controlOffset));
    }

    static ChannelUriStringBuilder mdcReqSubChannel1(String serverAddress, String clientAddress) {
        return StressUtil.mdcChannel(serverAddress, 3, clientAddress, 5).groupTag(1002L).alias("req_sub1");
    }

    static ChannelUriStringBuilder mdcReqSubChannel2(String serverAddress, String clientAddress) {
        return StressUtil.mdcChannel(serverAddress, 4, clientAddress, 5).groupTag(1002L).alias("req_sub2");
    }

    static ChannelUriStringBuilder mdcReqPubChannel(String clientAddress) {
        return new ChannelUriStringBuilder().media("udp").controlEndpoint(clientAddress + ":9005").taggedFlowControl(1002L, 2, "5s").alias("req_pub");
    }

    static ChannelUriStringBuilder mdcRspSubChannel1(String serverAddress, String clientAddress) {
        return StressUtil.mdcChannel(clientAddress, 6, serverAddress, 8).groupTag(1001L).alias("rsp_sub1");
    }

    static ChannelUriStringBuilder mdcRspSubChannel2(String serverAddress, String clientAddress) {
        return StressUtil.mdcChannel(clientAddress, 7, serverAddress, 8).groupTag(1001L).alias("rsp_sub2");
    }

    static ChannelUriStringBuilder mdcRspPubChannel(String serverAddress) {
        return new ChannelUriStringBuilder().media("udp").controlEndpoint(serverAddress + ":9008").taggedFlowControl(1001L, 2, "5s").alias("rsp_pub");
    }

    static void imageAvailable(Image image) {
        StressUtil.info("Available image=" + String.valueOf(image));
    }

    static void imageUnavailable(Image image) {
        StressUtil.info("Unavailable image=" + String.valueOf(image));
    }

    static void error(String message) {
        System.err.println(message);
    }

    static String serverAddress() {
        return System.getProperty("aeron.stress.server.address", "localhost");
    }

    static String clientAddress() {
        return System.getProperty("aeron.stress.client.address", "localhost");
    }

    static boolean crcMatches(DirectBuffer msg, int offset, int length, CRC64 crc) {
        long recvCrc = msg.getLong(offset, ByteOrder.LITTLE_ENDIAN);
        long calcCrc = crc.recalculate(msg, offset + 8, length - 8);
        return calcCrc == recvCrc;
    }

    static void validateMessage(CRC64 crc, DirectBuffer msg, int offset, int length, long correlationId) {
        long recvCrc = msg.getLong(offset, ByteOrder.LITTLE_ENDIAN);
        long calcCrc = crc.recalculate(msg, offset + 8, length - 8);
        if (calcCrc != recvCrc) {
            throw new RuntimeException("CRC validation failed, correlationId=" + correlationId + ", length=" + length + ", calc=" + calcCrc + ", recv=" + recvCrc);
        }
    }
}

