/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.DirectBuffer;


/**
 * Serialised state of the Consensus Module.
 */
@SuppressWarnings("all")
public final class ConsensusModuleDecoder
{
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 105;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 13;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final ConsensusModuleDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public ConsensusModuleDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public ConsensusModuleDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public ConsensusModuleDecoder sbeRewind()
    {
        return wrap(buffer, offset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int actingVersion()
    {
        return actingVersion;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int nextSessionIdId()
    {
        return 1;
    }

    public static int nextSessionIdSinceVersion()
    {
        return 0;
    }

    public static int nextSessionIdEncodingOffset()
    {
        return 0;
    }

    public static int nextSessionIdEncodingLength()
    {
        return 8;
    }

    public static String nextSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long nextSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long nextSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long nextSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long nextSessionId()
    {
        return buffer.getLong(offset + 0, BYTE_ORDER);
    }


    public static int nextServiceSessionIdId()
    {
        return 2;
    }

    public static int nextServiceSessionIdSinceVersion()
    {
        return 3;
    }

    public static int nextServiceSessionIdEncodingOffset()
    {
        return 8;
    }

    public static int nextServiceSessionIdEncodingLength()
    {
        return 8;
    }

    public static String nextServiceSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static long nextServiceSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long nextServiceSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long nextServiceSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long nextServiceSessionId()
    {
        if (parentMessage.actingVersion < 3)
        {
            return -9223372036854775808L;
        }

        return buffer.getLong(offset + 8, BYTE_ORDER);
    }


    public static int logServiceSessionIdId()
    {
        return 3;
    }

    public static int logServiceSessionIdSinceVersion()
    {
        return 3;
    }

    public static int logServiceSessionIdEncodingOffset()
    {
        return 16;
    }

    public static int logServiceSessionIdEncodingLength()
    {
        return 8;
    }

    public static String logServiceSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static long logServiceSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logServiceSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logServiceSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logServiceSessionId()
    {
        if (parentMessage.actingVersion < 3)
        {
            return -9223372036854775808L;
        }

        return buffer.getLong(offset + 16, BYTE_ORDER);
    }


    public static int pendingMessageCapacityId()
    {
        return 4;
    }

    public static int pendingMessageCapacitySinceVersion()
    {
        return 3;
    }

    public static int pendingMessageCapacityEncodingOffset()
    {
        return 24;
    }

    public static int pendingMessageCapacityEncodingLength()
    {
        return 4;
    }

    public static String pendingMessageCapacityMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static int pendingMessageCapacityNullValue()
    {
        return 0;
    }

    public static int pendingMessageCapacityMinValue()
    {
        return -2147483647;
    }

    public static int pendingMessageCapacityMaxValue()
    {
        return 2147483647;
    }

    public int pendingMessageCapacity()
    {
        if (parentMessage.actingVersion < 3)
        {
            return 0;
        }

        return buffer.getInt(offset + 24, BYTE_ORDER);
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final ConsensusModuleDecoder decoder = new ConsensusModuleDecoder();
        decoder.wrap(buffer, offset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(offset + actingBlockLength);
        builder.append("[ConsensusModule](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("nextSessionId=");
        builder.append(this.nextSessionId());
        builder.append('|');
        builder.append("nextServiceSessionId=");
        builder.append(this.nextServiceSessionId());
        builder.append('|');
        builder.append("logServiceSessionId=");
        builder.append(this.logServiceSessionId());
        builder.append('|');
        builder.append("pendingMessageCapacity=");
        builder.append(this.pendingMessageCapacity());

        limit(originalLimit);

        return builder;
    }
    
    public ConsensusModuleDecoder sbeSkip()
    {
        sbeRewind();

        return this;
    }
}
