/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.DirectBuffer;


/**
 * Mark the beginning, end, or section index of a snapshot.
 */
@SuppressWarnings("all")
public final class SnapshotMarkerDecoder
{
    public static final int BLOCK_LENGTH = 40;
    public static final int TEMPLATE_ID = 100;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 13;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final SnapshotMarkerDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public SnapshotMarkerDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public SnapshotMarkerDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public SnapshotMarkerDecoder sbeRewind()
    {
        return wrap(buffer, offset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int actingVersion()
    {
        return actingVersion;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int typeIdId()
    {
        return 1;
    }

    public static int typeIdSinceVersion()
    {
        return 0;
    }

    public static int typeIdEncodingOffset()
    {
        return 0;
    }

    public static int typeIdEncodingLength()
    {
        return 8;
    }

    public static String typeIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long typeIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long typeIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long typeIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long typeId()
    {
        return buffer.getLong(offset + 0, BYTE_ORDER);
    }


    public static int logPositionId()
    {
        return 2;
    }

    public static int logPositionSinceVersion()
    {
        return 0;
    }

    public static int logPositionEncodingOffset()
    {
        return 8;
    }

    public static int logPositionEncodingLength()
    {
        return 8;
    }

    public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public long logPosition()
    {
        return buffer.getLong(offset + 8, BYTE_ORDER);
    }


    public static int leadershipTermIdId()
    {
        return 3;
    }

    public static int leadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset()
    {
        return 16;
    }

    public static int leadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long leadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long leadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long leadershipTermId()
    {
        return buffer.getLong(offset + 16, BYTE_ORDER);
    }


    public static int indexId()
    {
        return 4;
    }

    public static int indexSinceVersion()
    {
        return 0;
    }

    public static int indexEncodingOffset()
    {
        return 24;
    }

    public static int indexEncodingLength()
    {
        return 4;
    }

    public static String indexMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int indexNullValue()
    {
        return -2147483648;
    }

    public static int indexMinValue()
    {
        return -2147483647;
    }

    public static int indexMaxValue()
    {
        return 2147483647;
    }

    public int index()
    {
        return buffer.getInt(offset + 24, BYTE_ORDER);
    }


    public static int markId()
    {
        return 5;
    }

    public static int markSinceVersion()
    {
        return 0;
    }

    public static int markEncodingOffset()
    {
        return 28;
    }

    public static int markEncodingLength()
    {
        return 4;
    }

    public static String markMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public int markRaw()
    {
        return buffer.getInt(offset + 28, BYTE_ORDER);
    }

    public SnapshotMark mark()
    {
        return SnapshotMark.get(buffer.getInt(offset + 28, BYTE_ORDER));
    }


    public static int timeUnitId()
    {
        return 6;
    }

    public static int timeUnitSinceVersion()
    {
        return 4;
    }

    public static int timeUnitEncodingOffset()
    {
        return 32;
    }

    public static int timeUnitEncodingLength()
    {
        return 4;
    }

    public static String timeUnitMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public int timeUnitRaw()
    {
        if (parentMessage.actingVersion < 4)
        {
            return -2147483648;
        }

        return buffer.getInt(offset + 32, BYTE_ORDER);
    }

    public ClusterTimeUnit timeUnit()
    {
        if (parentMessage.actingVersion < 4)
        {
            return ClusterTimeUnit.NULL_VAL;
        }

        return ClusterTimeUnit.get(buffer.getInt(offset + 32, BYTE_ORDER));
    }


    public static int appVersionId()
    {
        return 7;
    }

    public static int appVersionSinceVersion()
    {
        return 4;
    }

    public static int appVersionEncodingOffset()
    {
        return 36;
    }

    public static int appVersionEncodingLength()
    {
        return 4;
    }

    public static String appVersionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static int appVersionNullValue()
    {
        return 0;
    }

    public static int appVersionMinValue()
    {
        return 1;
    }

    public static int appVersionMaxValue()
    {
        return 16777215;
    }

    public int appVersion()
    {
        if (parentMessage.actingVersion < 4)
        {
            return 0;
        }

        return buffer.getInt(offset + 36, BYTE_ORDER);
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final SnapshotMarkerDecoder decoder = new SnapshotMarkerDecoder();
        decoder.wrap(buffer, offset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(offset + actingBlockLength);
        builder.append("[SnapshotMarker](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("typeId=");
        builder.append(this.typeId());
        builder.append('|');
        builder.append("logPosition=");
        builder.append(this.logPosition());
        builder.append('|');
        builder.append("leadershipTermId=");
        builder.append(this.leadershipTermId());
        builder.append('|');
        builder.append("index=");
        builder.append(this.index());
        builder.append('|');
        builder.append("mark=");
        builder.append(this.mark());
        builder.append('|');
        builder.append("timeUnit=");
        builder.append(this.timeUnit());
        builder.append('|');
        builder.append("appVersion=");
        builder.append(this.appVersion());

        limit(originalLimit);

        return builder;
    }
    
    public SnapshotMarkerDecoder sbeSkip()
    {
        sbeRewind();

        return this;
    }
}
