/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.MutableDirectBuffer;


/**
 * Used as first element in Catalog to set the version and alignment of entries.
 */
@SuppressWarnings("all")
public final class CatalogHeaderEncoder
{
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 20;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 13;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final CatalogHeaderEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public CatalogHeaderEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public CatalogHeaderEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int versionId()
    {
        return 1;
    }

    public static int versionSinceVersion()
    {
        return 0;
    }

    public static int versionEncodingOffset()
    {
        return 0;
    }

    public static int versionEncodingLength()
    {
        return 4;
    }

    public static String versionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int versionNullValue()
    {
        return -2147483648;
    }

    public static int versionMinValue()
    {
        return -2147483647;
    }

    public static int versionMaxValue()
    {
        return 2147483647;
    }

    public CatalogHeaderEncoder version(final int value)
    {
        buffer.putInt(offset + 0, value, BYTE_ORDER);
        return this;
    }


    public static int lengthId()
    {
        return 2;
    }

    public static int lengthSinceVersion()
    {
        return 0;
    }

    public static int lengthEncodingOffset()
    {
        return 4;
    }

    public static int lengthEncodingLength()
    {
        return 4;
    }

    public static String lengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int lengthNullValue()
    {
        return -2147483648;
    }

    public static int lengthMinValue()
    {
        return -2147483647;
    }

    public static int lengthMaxValue()
    {
        return 2147483647;
    }

    public CatalogHeaderEncoder length(final int value)
    {
        buffer.putInt(offset + 4, value, BYTE_ORDER);
        return this;
    }


    public static int nextRecordingIdId()
    {
        return 3;
    }

    public static int nextRecordingIdSinceVersion()
    {
        return 0;
    }

    public static int nextRecordingIdEncodingOffset()
    {
        return 8;
    }

    public static int nextRecordingIdEncodingLength()
    {
        return 8;
    }

    public static String nextRecordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long nextRecordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long nextRecordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long nextRecordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public CatalogHeaderEncoder nextRecordingId(final long value)
    {
        buffer.putLong(offset + 8, value, BYTE_ORDER);
        return this;
    }


    public static int alignmentId()
    {
        return 4;
    }

    public static int alignmentSinceVersion()
    {
        return 0;
    }

    public static int alignmentEncodingOffset()
    {
        return 16;
    }

    public static int alignmentEncodingLength()
    {
        return 4;
    }

    public static String alignmentMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int alignmentNullValue()
    {
        return -2147483648;
    }

    public static int alignmentMinValue()
    {
        return -2147483647;
    }

    public static int alignmentMaxValue()
    {
        return 2147483647;
    }

    public CatalogHeaderEncoder alignment(final int value)
    {
        buffer.putInt(offset + 16, value, BYTE_ORDER);
        return this;
    }


    public static int reservedId()
    {
        return 5;
    }

    public static int reservedSinceVersion()
    {
        return 0;
    }

    public static int reservedEncodingOffset()
    {
        return 31;
    }

    public static int reservedEncodingLength()
    {
        return 1;
    }

    public static String reservedMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static byte reservedNullValue()
    {
        return (byte)-128;
    }

    public static byte reservedMinValue()
    {
        return (byte)-127;
    }

    public static byte reservedMaxValue()
    {
        return (byte)127;
    }

    public CatalogHeaderEncoder reserved(final byte value)
    {
        buffer.putByte(offset + 31, value);
        return this;
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final CatalogHeaderDecoder decoder = new CatalogHeaderDecoder();
        decoder.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
