/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.MutableDirectBuffer;


/**
 * Detach segments from a recording to give a new start position.
 */
@SuppressWarnings("all")
public final class DetachSegmentsRequestEncoder
{
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 53;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 13;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final DetachSegmentsRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public DetachSegmentsRequestEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public DetachSegmentsRequestEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int controlSessionIdId()
    {
        return 1;
    }

    public static int controlSessionIdSinceVersion()
    {
        return 0;
    }

    public static int controlSessionIdEncodingOffset()
    {
        return 0;
    }

    public static int controlSessionIdEncodingLength()
    {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long controlSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long controlSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public DetachSegmentsRequestEncoder controlSessionId(final long value)
    {
        buffer.putLong(offset + 0, value, BYTE_ORDER);
        return this;
    }


    public static int correlationIdId()
    {
        return 2;
    }

    public static int correlationIdSinceVersion()
    {
        return 0;
    }

    public static int correlationIdEncodingOffset()
    {
        return 8;
    }

    public static int correlationIdEncodingLength()
    {
        return 8;
    }

    public static String correlationIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long correlationIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long correlationIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public DetachSegmentsRequestEncoder correlationId(final long value)
    {
        buffer.putLong(offset + 8, value, BYTE_ORDER);
        return this;
    }


    public static int recordingIdId()
    {
        return 3;
    }

    public static int recordingIdSinceVersion()
    {
        return 0;
    }

    public static int recordingIdEncodingOffset()
    {
        return 16;
    }

    public static int recordingIdEncodingLength()
    {
        return 8;
    }

    public static String recordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long recordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long recordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public DetachSegmentsRequestEncoder recordingId(final long value)
    {
        buffer.putLong(offset + 16, value, BYTE_ORDER);
        return this;
    }


    public static int newStartPositionId()
    {
        return 4;
    }

    public static int newStartPositionSinceVersion()
    {
        return 0;
    }

    public static int newStartPositionEncodingOffset()
    {
        return 24;
    }

    public static int newStartPositionEncodingLength()
    {
        return 8;
    }

    public static String newStartPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long newStartPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long newStartPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long newStartPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public DetachSegmentsRequestEncoder newStartPosition(final long value)
    {
        buffer.putLong(offset + 24, value, BYTE_ORDER);
        return this;
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final DetachSegmentsRequestDecoder decoder = new DetachSegmentsRequestDecoder();
        decoder.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
