/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.archive.codecs;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;


/**
 * Describes a recording in the catalog.
 */
@SuppressWarnings("all")
public final class RecordingDescriptorEncoder
{
    public static final int BLOCK_LENGTH = 80;
    public static final int TEMPLATE_ID = 22;
    public static final int SCHEMA_ID = 101;
    public static final int SCHEMA_VERSION = 13;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final RecordingDescriptorEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public RecordingDescriptorEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public RecordingDescriptorEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int controlSessionIdId()
    {
        return 1;
    }

    public static int controlSessionIdSinceVersion()
    {
        return 0;
    }

    public static int controlSessionIdEncodingOffset()
    {
        return 0;
    }

    public static int controlSessionIdEncodingLength()
    {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long controlSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long controlSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public RecordingDescriptorEncoder controlSessionId(final long value)
    {
        buffer.putLong(offset + 0, value, BYTE_ORDER);
        return this;
    }


    public static int correlationIdId()
    {
        return 2;
    }

    public static int correlationIdSinceVersion()
    {
        return 0;
    }

    public static int correlationIdEncodingOffset()
    {
        return 8;
    }

    public static int correlationIdEncodingLength()
    {
        return 8;
    }

    public static String correlationIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long correlationIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long correlationIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public RecordingDescriptorEncoder correlationId(final long value)
    {
        buffer.putLong(offset + 8, value, BYTE_ORDER);
        return this;
    }


    public static int recordingIdId()
    {
        return 3;
    }

    public static int recordingIdSinceVersion()
    {
        return 0;
    }

    public static int recordingIdEncodingOffset()
    {
        return 16;
    }

    public static int recordingIdEncodingLength()
    {
        return 8;
    }

    public static String recordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long recordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long recordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long recordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public RecordingDescriptorEncoder recordingId(final long value)
    {
        buffer.putLong(offset + 16, value, BYTE_ORDER);
        return this;
    }


    public static int startTimestampId()
    {
        return 4;
    }

    public static int startTimestampSinceVersion()
    {
        return 0;
    }

    public static int startTimestampEncodingOffset()
    {
        return 24;
    }

    public static int startTimestampEncodingLength()
    {
        return 8;
    }

    public static String startTimestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long startTimestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long startTimestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long startTimestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public RecordingDescriptorEncoder startTimestamp(final long value)
    {
        buffer.putLong(offset + 24, value, BYTE_ORDER);
        return this;
    }


    public static int stopTimestampId()
    {
        return 5;
    }

    public static int stopTimestampSinceVersion()
    {
        return 0;
    }

    public static int stopTimestampEncodingOffset()
    {
        return 32;
    }

    public static int stopTimestampEncodingLength()
    {
        return 8;
    }

    public static String stopTimestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long stopTimestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long stopTimestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long stopTimestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public RecordingDescriptorEncoder stopTimestamp(final long value)
    {
        buffer.putLong(offset + 32, value, BYTE_ORDER);
        return this;
    }


    public static int startPositionId()
    {
        return 6;
    }

    public static int startPositionSinceVersion()
    {
        return 0;
    }

    public static int startPositionEncodingOffset()
    {
        return 40;
    }

    public static int startPositionEncodingLength()
    {
        return 8;
    }

    public static String startPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long startPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long startPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long startPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public RecordingDescriptorEncoder startPosition(final long value)
    {
        buffer.putLong(offset + 40, value, BYTE_ORDER);
        return this;
    }


    public static int stopPositionId()
    {
        return 7;
    }

    public static int stopPositionSinceVersion()
    {
        return 0;
    }

    public static int stopPositionEncodingOffset()
    {
        return 48;
    }

    public static int stopPositionEncodingLength()
    {
        return 8;
    }

    public static String stopPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long stopPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long stopPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long stopPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public RecordingDescriptorEncoder stopPosition(final long value)
    {
        buffer.putLong(offset + 48, value, BYTE_ORDER);
        return this;
    }


    public static int initialTermIdId()
    {
        return 8;
    }

    public static int initialTermIdSinceVersion()
    {
        return 0;
    }

    public static int initialTermIdEncodingOffset()
    {
        return 56;
    }

    public static int initialTermIdEncodingLength()
    {
        return 4;
    }

    public static String initialTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int initialTermIdNullValue()
    {
        return -2147483648;
    }

    public static int initialTermIdMinValue()
    {
        return -2147483647;
    }

    public static int initialTermIdMaxValue()
    {
        return 2147483647;
    }

    public RecordingDescriptorEncoder initialTermId(final int value)
    {
        buffer.putInt(offset + 56, value, BYTE_ORDER);
        return this;
    }


    public static int segmentFileLengthId()
    {
        return 9;
    }

    public static int segmentFileLengthSinceVersion()
    {
        return 0;
    }

    public static int segmentFileLengthEncodingOffset()
    {
        return 60;
    }

    public static int segmentFileLengthEncodingLength()
    {
        return 4;
    }

    public static String segmentFileLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int segmentFileLengthNullValue()
    {
        return -2147483648;
    }

    public static int segmentFileLengthMinValue()
    {
        return -2147483647;
    }

    public static int segmentFileLengthMaxValue()
    {
        return 2147483647;
    }

    public RecordingDescriptorEncoder segmentFileLength(final int value)
    {
        buffer.putInt(offset + 60, value, BYTE_ORDER);
        return this;
    }


    public static int termBufferLengthId()
    {
        return 10;
    }

    public static int termBufferLengthSinceVersion()
    {
        return 0;
    }

    public static int termBufferLengthEncodingOffset()
    {
        return 64;
    }

    public static int termBufferLengthEncodingLength()
    {
        return 4;
    }

    public static String termBufferLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int termBufferLengthNullValue()
    {
        return -2147483648;
    }

    public static int termBufferLengthMinValue()
    {
        return -2147483647;
    }

    public static int termBufferLengthMaxValue()
    {
        return 2147483647;
    }

    public RecordingDescriptorEncoder termBufferLength(final int value)
    {
        buffer.putInt(offset + 64, value, BYTE_ORDER);
        return this;
    }


    public static int mtuLengthId()
    {
        return 11;
    }

    public static int mtuLengthSinceVersion()
    {
        return 0;
    }

    public static int mtuLengthEncodingOffset()
    {
        return 68;
    }

    public static int mtuLengthEncodingLength()
    {
        return 4;
    }

    public static String mtuLengthMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int mtuLengthNullValue()
    {
        return -2147483648;
    }

    public static int mtuLengthMinValue()
    {
        return -2147483647;
    }

    public static int mtuLengthMaxValue()
    {
        return 2147483647;
    }

    public RecordingDescriptorEncoder mtuLength(final int value)
    {
        buffer.putInt(offset + 68, value, BYTE_ORDER);
        return this;
    }


    public static int sessionIdId()
    {
        return 12;
    }

    public static int sessionIdSinceVersion()
    {
        return 0;
    }

    public static int sessionIdEncodingOffset()
    {
        return 72;
    }

    public static int sessionIdEncodingLength()
    {
        return 4;
    }

    public static String sessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int sessionIdNullValue()
    {
        return -2147483648;
    }

    public static int sessionIdMinValue()
    {
        return -2147483647;
    }

    public static int sessionIdMaxValue()
    {
        return 2147483647;
    }

    public RecordingDescriptorEncoder sessionId(final int value)
    {
        buffer.putInt(offset + 72, value, BYTE_ORDER);
        return this;
    }


    public static int streamIdId()
    {
        return 13;
    }

    public static int streamIdSinceVersion()
    {
        return 0;
    }

    public static int streamIdEncodingOffset()
    {
        return 76;
    }

    public static int streamIdEncodingLength()
    {
        return 4;
    }

    public static String streamIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int streamIdNullValue()
    {
        return -2147483648;
    }

    public static int streamIdMinValue()
    {
        return -2147483647;
    }

    public static int streamIdMaxValue()
    {
        return 2147483647;
    }

    public RecordingDescriptorEncoder streamId(final int value)
    {
        buffer.putInt(offset + 76, value, BYTE_ORDER);
        return this;
    }


    public static int strippedChannelId()
    {
        return 14;
    }

    public static String strippedChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String strippedChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int strippedChannelHeaderLength()
    {
        return 4;
    }

    public RecordingDescriptorEncoder putStrippedChannel(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public RecordingDescriptorEncoder putStrippedChannel(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public RecordingDescriptorEncoder strippedChannel(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public RecordingDescriptorEncoder strippedChannel(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public static int originalChannelId()
    {
        return 15;
    }

    public static String originalChannelCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String originalChannelMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int originalChannelHeaderLength()
    {
        return 4;
    }

    public RecordingDescriptorEncoder putOriginalChannel(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public RecordingDescriptorEncoder putOriginalChannel(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public RecordingDescriptorEncoder originalChannel(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public RecordingDescriptorEncoder originalChannel(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public static int sourceIdentityId()
    {
        return 16;
    }

    public static String sourceIdentityCharacterEncoding()
    {
        return java.nio.charset.StandardCharsets.US_ASCII.name();
    }

    public static String sourceIdentityMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int sourceIdentityHeaderLength()
    {
        return 4;
    }

    public RecordingDescriptorEncoder putSourceIdentity(final DirectBuffer src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public RecordingDescriptorEncoder putSourceIdentity(final byte[] src, final int srcOffset, final int length)
    {
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putBytes(limit + headerLength, src, srcOffset, length);

        return this;
    }

    public RecordingDescriptorEncoder sourceIdentity(final String value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public RecordingDescriptorEncoder sourceIdentity(final CharSequence value)
    {
        final int length = null == value ? 0 : value.length();
        if (length > 1073741824)
        {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }

        final int headerLength = 4;
        final int limit = parentMessage.limit();
        parentMessage.limit(limit + headerLength + length);
        buffer.putInt(limit, length, BYTE_ORDER);
        buffer.putStringWithoutLengthAscii(limit + headerLength, value);

        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final RecordingDescriptorDecoder decoder = new RecordingDescriptorDecoder();
        decoder.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
