/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.CncFileDescriptor;
import io.aeron.DriverProxy;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.SemanticVersion;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.DistinctErrorLog;
import org.agrona.concurrent.errors.ErrorConsumer;
import org.agrona.concurrent.errors.ErrorLogReader;
import org.agrona.concurrent.errors.LoggingErrorHandler;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBufferDescriptor;

public class CommonContext
implements Cloneable {
    public static final String PRINT_CONFIGURATION_ON_START_PROP_NAME = "aeron.print.configuration";
    public static final String DRIVER_TIMEOUT_PROP_NAME = "aeron.driver.timeout";
    public static final String DEBUG_TIMEOUT_PROP_NAME = "aeron.debug.timeout";
    public static final long DEFAULT_DRIVER_TIMEOUT_MS = 10000L;
    public static final long DRIVER_TIMEOUT_MS;
    public static final int NULL_SESSION_ID = -1;
    public static final String AERON_DIR_PROP_NAME = "aeron.dir";
    public static final String AERON_DIR_PROP_DEFAULT;
    public static final String ENABLE_EXPERIMENTAL_FEATURES_PROP_NAME = "aeron.enable.experimental.features";
    public static final String FALLBACK_LOGGER_PROP_NAME = "aeron.fallback.logger";
    public static final String IPC_MEDIA = "ipc";
    public static final String UDP_MEDIA = "udp";
    public static final String IPC_CHANNEL = "aeron:ipc";
    public static final String UDP_CHANNEL = "aeron:udp";
    public static final String SPY_PREFIX = "aeron-spy:";
    public static final String ENDPOINT_PARAM_NAME = "endpoint";
    public static final String INTERFACE_PARAM_NAME = "interface";
    public static final String INITIAL_TERM_ID_PARAM_NAME = "init-term-id";
    public static final String TERM_ID_PARAM_NAME = "term-id";
    public static final String TERM_OFFSET_PARAM_NAME = "term-offset";
    public static final String TERM_LENGTH_PARAM_NAME = "term-length";
    public static final String MTU_LENGTH_PARAM_NAME = "mtu";
    public static final String TTL_PARAM_NAME = "ttl";
    public static final String MDC_CONTROL_PARAM_NAME = "control";
    public static final String MDC_CONTROL_MODE_PARAM_NAME = "control-mode";
    public static final String MDC_CONTROL_MODE_MANUAL = "manual";
    public static final String MDC_CONTROL_MODE_DYNAMIC = "dynamic";
    public static final String CONTROL_MODE_RESPONSE = "response";
    public static final String SESSION_ID_PARAM_NAME = "session-id";
    public static final String LINGER_PARAM_NAME = "linger";
    public static final String RELIABLE_STREAM_PARAM_NAME = "reliable";
    public static final String TAGS_PARAM_NAME = "tags";
    public static final String TAG_PREFIX = "tag:";
    public static final String SPARSE_PARAM_NAME = "sparse";
    public static final String ALIAS_PARAM_NAME = "alias";
    public static final String EOS_PARAM_NAME = "eos";
    public static final String TETHER_PARAM_NAME = "tether";
    public static final String GROUP_PARAM_NAME = "group";
    public static final String REJOIN_PARAM_NAME = "rejoin";
    public static final String CONGESTION_CONTROL_PARAM_NAME = "cc";
    public static final String FLOW_CONTROL_PARAM_NAME = "fc";
    public static final String GROUP_TAG_PARAM_NAME = "gtag";
    public static final String SPIES_SIMULATE_CONNECTION_PARAM_NAME = "ssc";
    public static final String SOCKET_SNDBUF_PARAM_NAME = "so-sndbuf";
    public static final String SOCKET_RCVBUF_PARAM_NAME = "so-rcvbuf";
    public static final String RECEIVER_WINDOW_LENGTH_PARAM_NAME = "rcv-wnd";
    public static final String MEDIA_RCV_TIMESTAMP_OFFSET_PARAM_NAME = "media-rcv-ts-offset";
    public static final String CHANNEL_RECEIVE_TIMESTAMP_OFFSET_PARAM_NAME = "channel-rcv-ts-offset";
    public static final String CHANNEL_SEND_TIMESTAMP_OFFSET_PARAM_NAME = "channel-snd-ts-offset";
    public static final String RESERVED_OFFSET = "reserved";
    public static final String RESPONSE_ENDPOINT_PARAM_NAME = "response-endpoint";
    public static final String RESPONSE_CORRELATION_ID_PARAM_NAME = "response-correlation-id";
    public static final String PROTOTYPE_CORRELATION_ID = "prototype";
    public static final String NAK_DELAY_PARAM_NAME = "nak-delay";
    public static final String UNTETHERED_WINDOW_LIMIT_TIMEOUT_PARAM_NAME = "untethered-window-limit-timeout";
    public static final String UNTETHERED_LINGER_TIMEOUT_PARAM_NAME = "untethered-linger-timeout";
    public static final String UNTETHERED_RESTING_TIMEOUT_PARAM_NAME = "untethered-resting-timeout";
    public static final String MAX_RESEND_PARAM_NAME = "max-resend";
    public static final String STREAM_ID_PARAM_NAME = "stream-id";
    public static final String PUBLICATION_WINDOW_LENGTH_PARAM_NAME = "pub-wnd";
    public static final String SECURE_RANDOM_ALGORITHM_PROP_NAME = "aeron.secure.random.algorithm";
    public static final String SECURE_RANDOM_ALGORITHM_DEFAULT;
    private static final PrintStream NO_OP_LOGGER;
    private static final Map<String, Boolean> DEBUG_FIELDS_SEEN;
    private static final VarHandle IS_CONCLUDED_VH;
    private volatile boolean isConcluded;
    private long driverTimeoutMs = DRIVER_TIMEOUT_MS;
    private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
    private File aeronDirectory;
    private File cncFile;
    private UnsafeBuffer countersMetaDataBuffer;
    private UnsafeBuffer countersValuesBuffer;
    private boolean enableExperimentalFeatures = Boolean.getBoolean("aeron.enable.experimental.features");

    public static boolean shouldPrintConfigurationOnStart() {
        return "true".equals(System.getProperty(PRINT_CONFIGURATION_ON_START_PROP_NAME));
    }

    public static String getSecureRandomAlgorithm() {
        return System.getProperty(SECURE_RANDOM_ALGORITHM_PROP_NAME, SECURE_RANDOM_ALGORITHM_DEFAULT);
    }

    public static PrintStream fallbackLogger() {
        String fallbackLoggerName;
        return switch (fallbackLoggerName = System.getProperty(FALLBACK_LOGGER_PROP_NAME, "stderr")) {
            case "stdout" -> System.out;
            case "no_op" -> NO_OP_LOGGER;
            default -> System.err;
        };
    }

    public CommonContext clone() {
        try {
            return (CommonContext)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getAeronDirectoryName() {
        return System.getProperty(AERON_DIR_PROP_NAME, AERON_DIR_PROP_DEFAULT);
    }

    public static String generateRandomDirName() {
        return AERON_DIR_PROP_DEFAULT + "-" + String.valueOf(UUID.randomUUID());
    }

    public CommonContext conclude() {
        if (IS_CONCLUDED_VH.getAndSet(this, true)) {
            throw new ConcurrentConcludeException();
        }
        this.concludeAeronDirectory();
        this.cncFile = new File(this.aeronDirectory, "cnc.dat");
        return this;
    }

    public boolean isConcluded() {
        return this.isConcluded;
    }

    public CommonContext concludeAeronDirectory() {
        if (null == this.aeronDirectory) {
            try {
                this.aeronDirectory = new File(this.aeronDirectoryName).getCanonicalFile();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this;
    }

    public String aeronDirectoryName() {
        return this.aeronDirectoryName;
    }

    public File aeronDirectory() {
        return this.aeronDirectory;
    }

    public CommonContext aeronDirectoryName(String dirName) {
        this.aeronDirectoryName = dirName;
        return this;
    }

    public static File newDefaultCncFile() {
        return new File(System.getProperty(AERON_DIR_PROP_NAME, AERON_DIR_PROP_DEFAULT), "cnc.dat");
    }

    public static File newCncFile(String aeronDirectoryName) {
        return new File(aeronDirectoryName, "cnc.dat");
    }

    public UnsafeBuffer countersMetaDataBuffer() {
        return this.countersMetaDataBuffer;
    }

    public CommonContext countersMetaDataBuffer(UnsafeBuffer countersMetaDataBuffer) {
        this.countersMetaDataBuffer = countersMetaDataBuffer;
        return this;
    }

    public UnsafeBuffer countersValuesBuffer() {
        return this.countersValuesBuffer;
    }

    public CommonContext countersValuesBuffer(UnsafeBuffer countersValuesBuffer) {
        this.countersValuesBuffer = countersValuesBuffer;
        return this;
    }

    public File cncFile() {
        return this.cncFile;
    }

    public CommonContext driverTimeoutMs(long driverTimeoutMs) {
        this.driverTimeoutMs = driverTimeoutMs;
        return this;
    }

    public long driverTimeoutMs() {
        return CommonContext.checkDebugTimeout(this.driverTimeoutMs, TimeUnit.MILLISECONDS);
    }

    public boolean enableExperimentalFeatures() {
        return this.enableExperimentalFeatures;
    }

    public CommonContext enableExperimentalFeatures(boolean enableExperimentalFeatures) {
        this.enableExperimentalFeatures = enableExperimentalFeatures;
        return this;
    }

    public static long checkDebugTimeout(long timeout, TimeUnit timeUnit) {
        return CommonContext.checkDebugTimeout(timeout, timeUnit, 1.0);
    }

    public static long checkDebugTimeout(long timeout, TimeUnit timeUnit, double factor) {
        String debugTimeoutString = System.getProperty(DEBUG_TIMEOUT_PROP_NAME);
        if (null == debugTimeoutString || !SystemUtil.isDebuggerAttached()) {
            return timeout;
        }
        try {
            long debugTimeoutNs = (long)(factor * (double)SystemUtil.parseDuration(DEBUG_TIMEOUT_PROP_NAME, debugTimeoutString));
            long debugTimeout = timeUnit.convert(debugTimeoutNs, TimeUnit.NANOSECONDS);
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            Object debugFieldName = "<unknown>";
            for (int i = 0; i < stackTrace.length; ++i) {
                String methodName = stackTrace[i].getMethodName();
                if ("checkDebugTimeout".equals(methodName) || "getStackTrace".equals(methodName)) continue;
                String className = stackTrace[i].getClassName();
                debugFieldName = className + "." + methodName;
                break;
            }
            if (null == DEBUG_FIELDS_SEEN.putIfAbsent((String)debugFieldName, true)) {
                String message = "Using debug timeout [" + debugTimeout + "] for " + (String)debugFieldName + " replacing [" + timeout + "]";
                System.out.println(message);
            }
            return debugTimeout;
        }
        catch (NumberFormatException ignore) {
            return timeout;
        }
    }

    public void deleteAeronDirectory() {
        IoUtil.delete(this.aeronDirectory, false);
    }

    public MappedByteBuffer mapExistingCncFile(Consumer<String> logger) {
        File cncFile = new File(this.aeronDirectory, "cnc.dat");
        if (cncFile.exists() && cncFile.length() > 128L) {
            if (null != logger) {
                logger.accept("INFO: Aeron CnC file exists: " + String.valueOf(cncFile));
            }
            return IoUtil.mapExistingFile(cncFile, "cnc.dat");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDriverActive(File directory, long driverTimeoutMs, Consumer<String> logger) {
        File cncFile = new File(directory, "cnc.dat");
        if (cncFile.exists() && cncFile.length() > 128L) {
            logger.accept("INFO: Aeron CnC file exists: " + String.valueOf(cncFile));
            MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile(cncFile, "CnC file");
            try {
                boolean bl = CommonContext.isDriverActive(driverTimeoutMs, logger, cncByteBuffer);
                return bl;
            }
            finally {
                BufferUtil.free(cncByteBuffer);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDriverActive(long driverTimeoutMs, Consumer<String> logger) {
        MappedByteBuffer cncByteBuffer = this.mapExistingCncFile(logger);
        try {
            boolean bl = CommonContext.isDriverActive(driverTimeoutMs, logger, cncByteBuffer);
            return bl;
        }
        finally {
            BufferUtil.free(cncByteBuffer);
        }
    }

    public static boolean isDriverActive(long driverTimeoutMs, Consumer<String> logger, ByteBuffer cncByteBuffer) {
        int cncVersion;
        if (null == cncByteBuffer) {
            return false;
        }
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        long startTimeMs = System.currentTimeMillis();
        while (0 == (cncVersion = cncMetaDataBuffer.getIntVolatile(CncFileDescriptor.cncVersionOffset(0)))) {
            if (System.currentTimeMillis() > startTimeMs + driverTimeoutMs) {
                throw new DriverTimeoutException("CnC file is created but not initialised.");
            }
            CommonContext.sleep(1L);
        }
        CncFileDescriptor.checkVersion(cncVersion);
        ManyToOneRingBuffer toDriverBuffer = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(cncByteBuffer, cncMetaDataBuffer));
        long timestampMs = toDriverBuffer.consumerHeartbeatTime();
        long nowMs = System.currentTimeMillis();
        long timestampAgeMs = nowMs - timestampMs;
        logger.accept("INFO: Aeron toDriver consumer heartbeat age is (ms): " + timestampAgeMs);
        return timestampAgeMs <= driverTimeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean requestDriverTermination(File directory, DirectBuffer tokenBuffer, int tokenOffset, int tokenLength) {
        File cncFile = new File(directory, "cnc.dat");
        if (cncFile.exists() && cncFile.length() > 128L) {
            MappedByteBuffer cncByteBuffer = IoUtil.mapExistingFile(cncFile, "CnC file");
            try {
                UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
                int cncVersion = cncMetaDataBuffer.getIntVolatile(CncFileDescriptor.cncVersionOffset(0));
                if (cncVersion > 0) {
                    CncFileDescriptor.checkVersion(cncVersion);
                    ManyToOneRingBuffer toDriverBuffer = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(cncByteBuffer, cncMetaDataBuffer));
                    long clientId = toDriverBuffer.nextCorrelationId();
                    DriverProxy driverProxy = new DriverProxy(toDriverBuffer, clientId);
                    boolean bl = driverProxy.terminateDriver(tokenBuffer, tokenOffset, tokenLength);
                    return bl;
                }
            }
            finally {
                BufferUtil.free(cncByteBuffer);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int saveErrorLog(PrintStream out) {
        MappedByteBuffer cncByteBuffer = this.mapExistingCncFile(null);
        try {
            int n = this.saveErrorLog(out, cncByteBuffer);
            return n;
        }
        finally {
            BufferUtil.free(cncByteBuffer);
        }
    }

    public int saveErrorLog(PrintStream out, ByteBuffer cncByteBuffer) {
        if (null == cncByteBuffer) {
            return 0;
        }
        return CommonContext.printErrorLog(CommonContext.errorLogBuffer(cncByteBuffer), out);
    }

    public void close() {
    }

    public static int printErrorLog(AtomicBuffer errorBuffer, PrintStream out) {
        int distinctErrorCount = 0;
        if (ErrorLogReader.hasErrors(errorBuffer)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            ErrorConsumer errorConsumer = (count, firstTimestamp, lastTimestamp, encodedException) -> {
                String fromDate = dateFormat.format(new Date(firstTimestamp));
                String toDate = dateFormat.format(new Date(lastTimestamp));
                out.println();
                out.println(count + " observations from " + fromDate + " to " + toDate + " for:");
                out.println(encodedException);
            };
            distinctErrorCount = ErrorLogReader.read(errorBuffer, errorConsumer);
            out.println();
            out.println(distinctErrorCount + " distinct errors observed.");
        } else {
            out.println();
            out.println("O distinct errors observed");
        }
        return distinctErrorCount;
    }

    public static void saveExistingErrors(File markFile, AtomicBuffer errorBuffer, PrintStream logger, String errorFilePrefix) {
        block8: {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int observations = CommonContext.printErrorLog(errorBuffer, new PrintStream((OutputStream)baos, false, StandardCharsets.US_ASCII));
                if (observations <= 0) break block8;
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSSZ");
                File errorLogFile = new File(markFile.getParentFile(), errorFilePrefix + "-" + dateFormat.format(new Date()) + "-error.log");
                if (null != logger) {
                    logger.println("WARNING: existing errors saved to: " + String.valueOf(errorLogFile));
                }
                try (FileOutputStream out = new FileOutputStream(errorLogFile);){
                    baos.writeTo(out);
                }
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked(ex);
            }
        }
    }

    public static AtomicBuffer errorLogBuffer(ByteBuffer cncByteBuffer) {
        UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
        int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
        CncFileDescriptor.checkVersion(cncVersion);
        return CncFileDescriptor.createErrorLogBuffer(cncByteBuffer, cncMetaDataBuffer);
    }

    public static ErrorHandler setupErrorHandler(ErrorHandler userErrorHandler, DistinctErrorLog errorLog) {
        return CommonContext.setupErrorHandler(userErrorHandler, errorLog, CommonContext.fallbackLogger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int driverFilePageSize(File aeronDirectory, EpochClock clock, long timeoutMs) {
        UnsafeBuffer metadata = CommonContext.awaitCncFileCreation(new File(aeronDirectory, "cnc.dat"), clock, clock.time() + timeoutMs);
        try {
            int n = CommonContext.driverFilePageSize(metadata);
            return n;
        }
        finally {
            BufferUtil.free(metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextCorrelationId(File aeronDirectory, EpochClock clock, long timeoutMs) {
        UnsafeBuffer metadata = CommonContext.awaitCncFileCreation(new File(aeronDirectory, "cnc.dat"), clock, clock.time() + timeoutMs);
        try {
            int correlationIdOffset = metadata.getInt(CncFileDescriptor.TO_DRIVER_BUFFER_LENGTH_FIELD_OFFSET) - RingBufferDescriptor.TRAILER_LENGTH + RingBufferDescriptor.CORRELATION_COUNTER_OFFSET;
            UnsafeBuffer toDriverBuffer = CncFileDescriptor.createToDriverBuffer(metadata.byteBuffer(), metadata);
            long l = toDriverBuffer.getAndAddLong(correlationIdOffset, 1L);
            return l;
        }
        finally {
            BufferUtil.free(metadata);
        }
    }

    static int driverFilePageSize(DirectBuffer metadata) {
        int pageSize = CncFileDescriptor.filePageSize(metadata);
        return 0 != pageSize ? pageSize : 4096;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static UnsafeBuffer awaitCncFileCreation(File cncFile, EpochClock clock, long deadlineMs) {
        while (true) {
            UnsafeBuffer unsafeBuffer;
            long fileSize;
            FileChannel fileChannel2;
            block17: {
                if (!cncFile.exists() || cncFile.length() < 128L) {
                    if (clock.time() > deadlineMs) {
                        throw new DriverTimeoutException("CnC file not created: " + cncFile.getAbsolutePath());
                    }
                    CommonContext.sleep(16L);
                    continue;
                }
                fileChannel2 = FileChannel.open(cncFile.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);
                fileSize = fileChannel2.size();
                if (fileSize >= 128L) break block17;
                if (clock.time() > deadlineMs) {
                    throw new DriverTimeoutException("CnC file is created but not populated: " + cncFile.getAbsolutePath());
                }
                fileChannel2.close();
                CommonContext.sleep(16L);
                if (fileChannel2 == null) continue;
                fileChannel2.close();
                continue;
            }
            try {
                int cncVersion;
                UnsafeBuffer metaDataBuffer = CncFileDescriptor.createMetaDataBuffer(fileChannel2.map(FileChannel.MapMode.READ_WRITE, 0L, fileSize));
                while (0 == (cncVersion = metaDataBuffer.getIntVolatile(CncFileDescriptor.cncVersionOffset(0)))) {
                    if (clock.time() > deadlineMs) {
                        throw new DriverTimeoutException("CnC file is created but not initialised: " + cncFile.getAbsolutePath());
                    }
                    CommonContext.sleep(1L);
                }
                CncFileDescriptor.checkVersion(cncVersion);
                if (SemanticVersion.minor(cncVersion) < SemanticVersion.minor(CncFileDescriptor.CNC_VERSION)) {
                    throw new AeronException("driverVersion=" + SemanticVersion.toString(cncVersion) + " insufficient for clientVersion=" + SemanticVersion.toString(CncFileDescriptor.CNC_VERSION));
                }
                unsafeBuffer = metaDataBuffer;
                if (fileChannel2 == null) return unsafeBuffer;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel2 == null) throw throwable;
                    try {
                        fileChannel2.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (AccessDeniedException | NoSuchFileException fileChannel2) {
                    continue;
                }
                catch (FileSystemException ex) {
                    if (!SystemUtil.isWindows()) throw new AeronException(CommonContext.cncFileErrorMessage(cncFile, ex), ex);
                    continue;
                }
                catch (IOException ex) {
                    throw new AeronException(CommonContext.cncFileErrorMessage(cncFile, ex), ex);
                }
            }
            fileChannel2.close();
            return unsafeBuffer;
            break;
        }
    }

    static ErrorHandler setupErrorHandler(ErrorHandler userErrorHandler, DistinctErrorLog errorLog, PrintStream fallbackErrorStream) {
        LoggingErrorHandler loggingErrorHandler = new LoggingErrorHandler(errorLog, fallbackErrorStream);
        if (null == userErrorHandler) {
            return loggingErrorHandler;
        }
        return new ErrorHandlerWrapper(loggingErrorHandler, userErrorHandler);
    }

    static void sleep(long durationMs) {
        try {
            Thread.sleep(durationMs);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new AeronException("unexpected interrupt", ex);
        }
    }

    private static String cncFileErrorMessage(File file, Exception ex) {
        return "cannot open CnC file: " + file.getAbsolutePath() + " reason=" + String.valueOf(ex);
    }

    static {
        File devShmDir;
        DRIVER_TIMEOUT_MS = Long.getLong(DRIVER_TIMEOUT_PROP_NAME, 10000L);
        SECURE_RANDOM_ALGORITHM_DEFAULT = SystemUtil.isWindows() ? "Windows-PRNG" : "NativePRNGNonBlocking";
        NO_OP_LOGGER = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        });
        DEBUG_FIELDS_SEEN = new ConcurrentHashMap<String, Boolean>();
        try {
            IS_CONCLUDED_VH = MethodHandles.lookup().findVarHandle(CommonContext.class, "isConcluded", Boolean.TYPE);
        }
        catch (ReflectiveOperationException ex) {
            throw new ExceptionInInitializerError(ex);
        }
        Object baseDirName = null;
        if (SystemUtil.isLinux() && (devShmDir = new File("/dev/shm")).exists()) {
            baseDirName = "/dev/shm/aeron";
        }
        if (null == baseDirName) {
            baseDirName = SystemUtil.tmpDirName() + "aeron";
        }
        AERON_DIR_PROP_DEFAULT = (String)baseDirName + "-" + System.getProperty("user.name", "default");
    }

    private static final class ErrorHandlerWrapper
    implements ErrorHandler,
    AutoCloseable {
        private final LoggingErrorHandler loggingErrorHandler;
        private final ErrorHandler userErrorHandler;

        private ErrorHandlerWrapper(LoggingErrorHandler loggingErrorHandler, ErrorHandler userErrorHandler) {
            this.loggingErrorHandler = loggingErrorHandler;
            this.userErrorHandler = userErrorHandler;
        }

        @Override
        public void close() {
            this.loggingErrorHandler.close();
            if (this.userErrorHandler instanceof AutoCloseable) {
                CloseHelper.quietClose((AutoCloseable)((Object)this.userErrorHandler));
            }
        }

        @Override
        public void onError(Throwable throwable) {
            this.loggingErrorHandler.onError(throwable);
            this.userErrorHandler.onError(throwable);
        }
    }

    public static enum InferableBoolean {
        FORCE_FALSE,
        FORCE_TRUE,
        INFER;


        public static InferableBoolean parse(String value) {
            if (null == value || "infer".equals(value)) {
                return INFER;
            }
            return "true".equals(value) ? FORCE_TRUE : FORCE_FALSE;
        }
    }
}

