/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.ArchiveMarkFile;
import io.aeron.archive.ArchiveMigrationStep;
import io.aeron.archive.Catalog;
import io.aeron.archive.MigrationUtils;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import io.aeron.archive.codecs.RecordingDescriptorEncoder;
import io.aeron.archive.codecs.RecordingDescriptorHeaderDecoder;
import io.aeron.archive.codecs.RecordingDescriptorHeaderEncoder;
import io.aeron.archive.codecs.RecordingState;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import org.agrona.AsciiEncoding;
import org.agrona.LangUtil;
import org.agrona.SemanticVersion;
import org.agrona.collections.ArrayUtil;

class ArchiveMigration_1_2
implements ArchiveMigrationStep {
    private static final int MINIMUM_VERSION = SemanticVersion.compose(2, 0, 0);

    ArchiveMigration_1_2() {
    }

    @Override
    public int minimumVersion() {
        return MINIMUM_VERSION;
    }

    @Override
    public void migrate(PrintStream stream, ArchiveMarkFile markFile, Catalog catalog, File archiveDir) {
        try (FileChannel ignore = MigrationUtils.createMigrationTimestampFile(archiveDir, markFile.decoder().version(), this.minimumVersion());){
            catalog.forEach((recordingDescriptorOffset, headerEncoder, headerDecoder, encoder, decoder) -> {
                String version1Prefix = decoder.recordingId() + "-";
                String version1Suffix = ".rec";
                String[] segmentFiles = archiveDir.list((dir, filename) -> filename.startsWith(version1Prefix) && filename.endsWith(".rec"));
                if (null == segmentFiles) {
                    segmentFiles = ArrayUtil.EMPTY_STRING_ARRAY;
                }
                this.migrateRecording(stream, archiveDir, segmentFiles, version1Prefix, ".rec", headerEncoder, headerDecoder, encoder, decoder);
            });
            markFile.encoder().version(this.minimumVersion());
            catalog.updateVersion(this.minimumVersion());
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
    }

    private void migrateRecording(PrintStream stream, File archiveDir, String[] segmentFiles, String prefix, String suffix, RecordingDescriptorHeaderEncoder headerEncoder, RecordingDescriptorHeaderDecoder headerDecoder, RecordingDescriptorEncoder encoder, RecordingDescriptorDecoder decoder) {
        long recordingId = decoder.recordingId();
        long startPosition = decoder.startPosition();
        long termLength = decoder.termBufferLength();
        long segmentLength = decoder.segmentFileLength();
        long startTermBasePosition = startPosition - (startPosition & termLength - 1L);
        if (headerDecoder.state() == RecordingState.INVALID) {
            return;
        }
        if (startTermBasePosition == 0L || termLength == segmentLength) {
            stream.println("(recordingId=" + recordingId + ") OK - skipped.");
            return;
        }
        stream.println("(recordingId=" + recordingId + ") startTermBasePosition=" + startTermBasePosition + ")");
        Arrays.sort(segmentFiles);
        for (String filename : segmentFiles) {
            long segmentPosition;
            int offset;
            int length = filename.length();
            int remaining = length - (offset = prefix.length()) - suffix.length();
            if (remaining <= 0) continue;
            try {
                segmentPosition = AsciiEncoding.parseLongAscii(filename, offset, remaining);
            }
            catch (Exception ex) {
                stream.println("(recordingId=" + recordingId + ") ERR: malformed recording filename:" + filename);
                throw ex;
            }
            long newSegmentPosition = startTermBasePosition + segmentPosition;
            String newFilename = prefix + newSegmentPosition + suffix;
            Path sourcePath = new File(archiveDir, filename).toPath();
            Path targetPath = sourcePath.resolveSibling(newFilename);
            stream.println("(recordingId=" + recordingId + ") renaming " + String.valueOf(sourcePath) + " -> " + String.valueOf(targetPath));
            try {
                Files.move(sourcePath, targetPath, new CopyOption[0]);
                Files.setLastModifiedTime(targetPath, FileTime.fromMillis(System.currentTimeMillis()));
            }
            catch (Exception ex) {
                stream.println("(recordingId=" + recordingId + ") ERR: could not rename filename: " + String.valueOf(sourcePath) + " -> " + String.valueOf(targetPath));
                LangUtil.rethrowUnchecked(ex);
            }
        }
        stream.println("(recordingId=" + recordingId + ") OK");
    }

    public String toString() {
        return "to " + MigrationUtils.fullVersionString(this.minimumVersion());
    }
}

