/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.ChallengeDecoder;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.ControlResponseDecoder;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.archive.codecs.RecordingSignalEventDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.SemanticVersion;

public final class ControlResponsePoller {
    public static final int FRAGMENT_LIMIT = 10;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ControlResponseDecoder controlResponseDecoder = new ControlResponseDecoder();
    private final ChallengeDecoder challengeDecoder = new ChallengeDecoder();
    private final RecordingSignalEventDecoder recordingSignalEventDecoder = new RecordingSignalEventDecoder();
    private final Subscription subscription;
    private final ControlledFragmentAssembler fragmentAssembler = new ControlledFragmentAssembler(this::onFragment);
    private final int fragmentLimit;
    private long controlSessionId = -1L;
    private long correlationId = -1L;
    private long relevantId = -1L;
    private int templateId = -1;
    private int version = 0;
    private ControlResponseCode code = null;
    private String errorMessage = null;
    private long recordingId = -1L;
    private long subscriptionId = -1L;
    private long position = -1L;
    private RecordingSignal recordingSignal = null;
    private byte[] encodedChallenge = null;
    private boolean isPollComplete = false;

    public ControlResponsePoller(Subscription subscription) {
        this(subscription, 10);
    }

    public ControlResponsePoller(Subscription subscription, int fragmentLimit) {
        this.subscription = Objects.requireNonNull(subscription);
        this.fragmentLimit = fragmentLimit;
    }

    public Subscription subscription() {
        return this.subscription;
    }

    public int poll() {
        if (this.isPollComplete) {
            this.controlSessionId = -1L;
            this.correlationId = -1L;
            this.relevantId = -1L;
            this.templateId = -1;
            this.version = 0;
            this.code = null;
            this.errorMessage = null;
            this.recordingId = -1L;
            this.subscriptionId = -1L;
            this.position = -1L;
            this.encodedChallenge = null;
            this.recordingSignal = null;
            this.isPollComplete = false;
        }
        return this.subscription.controlledPoll(this.fragmentAssembler, this.fragmentLimit);
    }

    public int templateId() {
        return this.templateId;
    }

    public long controlSessionId() {
        return this.controlSessionId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public long relevantId() {
        return this.relevantId;
    }

    public long recordingId() {
        return this.recordingId;
    }

    public long subscriptionId() {
        return this.subscriptionId;
    }

    public long position() {
        return this.position;
    }

    public RecordingSignal recordingSignal() {
        return this.recordingSignal;
    }

    public int version() {
        return this.version;
    }

    public boolean isPollComplete() {
        return this.isPollComplete;
    }

    public ControlResponseCode code() {
        return this.code;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public boolean wasChallenged() {
        return null != this.encodedChallenge;
    }

    public byte[] encodedChallenge() {
        return this.encodedChallenge;
    }

    ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        if (this.isPollComplete) {
            return ControlledFragmentHandler.Action.ABORT;
        }
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 101) {
            throw new ArchiveException("expected schemaId=101, actual=" + schemaId);
        }
        this.templateId = this.messageHeaderDecoder.templateId();
        switch (this.templateId) {
            case 1: {
                this.controlResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.controlSessionId = this.controlResponseDecoder.controlSessionId();
                this.correlationId = this.controlResponseDecoder.correlationId();
                this.relevantId = this.controlResponseDecoder.relevantId();
                this.code = this.controlResponseDecoder.code();
                this.version = this.controlResponseDecoder.version();
                this.errorMessage = this.controlResponseDecoder.errorMessage();
                this.isPollComplete = true;
                return ControlledFragmentHandler.Action.BREAK;
            }
            case 59: {
                this.challengeDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.controlSessionId = this.challengeDecoder.controlSessionId();
                this.correlationId = this.challengeDecoder.correlationId();
                this.relevantId = -1L;
                this.code = ControlResponseCode.NULL_VAL;
                this.version = this.challengeDecoder.version();
                this.errorMessage = "";
                int encodedChallengeLength = this.challengeDecoder.encodedChallengeLength();
                this.encodedChallenge = new byte[encodedChallengeLength];
                this.challengeDecoder.getEncodedChallenge(this.encodedChallenge, 0, encodedChallengeLength);
                this.isPollComplete = true;
                return ControlledFragmentHandler.Action.BREAK;
            }
            case 24: {
                this.recordingSignalEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                this.controlSessionId = this.recordingSignalEventDecoder.controlSessionId();
                this.correlationId = this.recordingSignalEventDecoder.correlationId();
                this.recordingId = this.recordingSignalEventDecoder.recordingId();
                this.subscriptionId = this.recordingSignalEventDecoder.subscriptionId();
                this.position = this.recordingSignalEventDecoder.position();
                this.recordingSignal = this.recordingSignalEventDecoder.signal();
                this.isPollComplete = true;
                return ControlledFragmentHandler.Action.BREAK;
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public String toString() {
        return "ControlResponsePoller{templateId=" + this.templateId + ", controlSessionId=" + this.controlSessionId + ", correlationId=" + this.correlationId + ", relevantId=" + this.relevantId + ", recordingId=" + this.recordingId + ", subscriptionId=" + this.subscriptionId + ", position=" + this.position + ", recordingSignal=" + String.valueOf((Object)this.recordingSignal) + ", code=" + String.valueOf((Object)this.code) + ", version=" + SemanticVersion.toString(this.version) + ", errorMessage='" + this.errorMessage + "', isPollComplete=" + this.isPollComplete + "}";
    }
}

