/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.FragmentAssembler;
import io.aeron.Subscription;
import io.aeron.cluster.ClusterMember;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ClusterMembersExtendedResponseDecoder;
import io.aeron.cluster.codecs.ClusterMembersResponseDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.logbuffer.Header;
import java.util.ArrayList;
import java.util.List;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;

final class ClusterControlAdapter
implements AutoCloseable {
    private final Subscription subscription;
    private final Listener listener;
    private final FragmentAssembler fragmentAssembler = new FragmentAssembler(this::onFragment);
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final ClusterMembersResponseDecoder clusterMembersResponseDecoder = new ClusterMembersResponseDecoder();
    private final ClusterMembersExtendedResponseDecoder clusterMembersExtendedResponseDecoder = new ClusterMembersExtendedResponseDecoder();

    ClusterControlAdapter(Subscription subscription, Listener listener) {
        this.subscription = subscription;
        this.listener = listener;
    }

    @Override
    public void close() {
        CloseHelper.close(this.subscription);
    }

    int poll() {
        return this.subscription.poll(this.fragmentAssembler, 1);
    }

    boolean isBound() {
        return this.subscription.isConnected();
    }

    private void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 111) {
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        int templateId = this.messageHeaderDecoder.templateId();
        if (templateId == 41) {
            this.clusterMembersResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long correlationId = this.clusterMembersResponseDecoder.correlationId();
            int leaderMemberId = this.clusterMembersResponseDecoder.leaderMemberId();
            String activeMembers = this.clusterMembersResponseDecoder.activeMembers();
            this.clusterMembersResponseDecoder.skipPassiveFollowers();
            this.listener.onClusterMembersResponse(correlationId, leaderMemberId, activeMembers);
        } else if (templateId == 43) {
            this.clusterMembersExtendedResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
            long correlationId = this.clusterMembersExtendedResponseDecoder.correlationId();
            long currentTimeNs = this.clusterMembersExtendedResponseDecoder.currentTimeNs();
            int leaderMemberId = this.clusterMembersExtendedResponseDecoder.leaderMemberId();
            int memberId = this.clusterMembersExtendedResponseDecoder.memberId();
            ArrayList<ClusterMember> activeMembers = new ArrayList<ClusterMember>();
            for (ClusterMembersExtendedResponseDecoder.ActiveMembersDecoder activeMembersDecoder : this.clusterMembersExtendedResponseDecoder.activeMembers()) {
                int id = activeMembersDecoder.memberId();
                String ingressEndpoint = activeMembersDecoder.ingressEndpoint();
                String consensusEndpoint = activeMembersDecoder.consensusEndpoint();
                String logEndpoint = activeMembersDecoder.logEndpoint();
                String catchupEndpoint = activeMembersDecoder.catchupEndpoint();
                String archiveEndpoint = activeMembersDecoder.archiveEndpoint();
                String endpoints = String.join((CharSequence)",", ingressEndpoint, consensusEndpoint, logEndpoint, catchupEndpoint, archiveEndpoint);
                activeMembers.add(new ClusterMember(id, ingressEndpoint, consensusEndpoint, logEndpoint, catchupEndpoint, archiveEndpoint, endpoints).isLeader(id == leaderMemberId).leadershipTermId(activeMembersDecoder.leadershipTermId()).logPosition(activeMembersDecoder.logPosition()).timeOfLastAppendPositionNs(activeMembersDecoder.timeOfLastAppendNs()));
            }
            for (ClusterMembersExtendedResponseDecoder.PassiveMembersDecoder passiveMembersDecoder : this.clusterMembersExtendedResponseDecoder.passiveMembers()) {
                passiveMembersDecoder.sbeSkip();
            }
            this.listener.onClusterMembersExtendedResponse(correlationId, currentTimeNs, leaderMemberId, memberId, activeMembers);
        }
    }

    static interface Listener {
        public void onClusterMembersResponse(long var1, int var3, String var4);

        public void onClusterMembersExtendedResponse(long var1, long var3, int var5, int var6, List<ClusterMember> var7);
    }
}

