/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.Aeron;
import io.aeron.ChannelUri;
import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.cluster.ClusterControl;
import io.aeron.cluster.ClusterMembership;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.ConsensusModuleSnapshotAdapter;
import io.aeron.cluster.ConsensusModuleSnapshotPrinter;
import io.aeron.cluster.ElectionState;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.ToggleApplication;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.mark.ClusterComponentType;
import io.aeron.cluster.codecs.mark.MarkFileHeaderDecoder;
import io.aeron.cluster.service.Cluster;
import io.aeron.cluster.service.ClusterMarkFile;
import io.aeron.cluster.service.ClusterNodeControlProperties;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.agrona.BufferUtil;
import org.agrona.IoUtil;
import org.agrona.Strings;
import org.agrona.collections.MutableBoolean;
import org.agrona.collections.MutableLong;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public class ClusterToolOperator {
    public static final int SUCCESS = 0;
    private static final int MARK_FILE_VERSION_WITH_CLUSTER_SERVICES_DIR = 1;
    private static final int FAILURE = -1;
    private final String toolChannel;
    private final int toolStreamId;
    private final long timeoutMs;

    protected ClusterToolOperator(String toolChannel, int toolStreamId, long timeoutMs) {
        this.toolChannel = toolChannel;
        this.toolStreamId = toolStreamId;
        this.timeoutMs = timeoutMs;
    }

    protected int pid(File clusterDir, PrintStream out) {
        if (this.markFileExists(clusterDir) || this.timeoutMs > 0L) {
            try (ClusterMarkFile markFile = this.openMarkFile(clusterDir);){
                out.println(markFile.decoder().pid());
            }
        } else {
            return -1;
        }
        return 0;
    }

    protected int recoveryPlan(PrintStream out, File clusterDir, int serviceCount) {
        try (AeronArchive archive = AeronArchive.connect(new AeronArchive.Context().clientName("cluster-tool"));
             RecordingLog recordingLog = new RecordingLog(clusterDir, false);){
            out.println(recordingLog.createRecoveryPlan(archive, serviceCount, -1L));
        }
        return 0;
    }

    protected int recordingLog(File clusterDir, PrintStream out) {
        try (RecordingLog recordingLog = new RecordingLog(clusterDir, false);){
            out.println(recordingLog);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int sortRecordingLog(File clusterDir) {
        List<RecordingLog.Entry> entries;
        try (RecordingLog recordingLog = new RecordingLog(clusterDir, false);){
            entries = recordingLog.entries();
            if (this.isRecordingLogSorted(entries)) {
                int n = -1;
                return n;
            }
        }
        catch (RuntimeException ex) {
            return -1;
        }
        this.updateRecordingLog(clusterDir, entries);
        return 0;
    }

    protected int seedRecordingLogFromSnapshot(File clusterDir) {
        List<RecordingLog.Entry> entries;
        int snapshotIndex = -1;
        try (RecordingLog recordingLog = new RecordingLog(clusterDir, false);){
            entries = recordingLog.entries();
            for (int i = entries.size() - 1; i >= 0; --i) {
                RecordingLog.Entry entry = entries.get(i);
                if (!RecordingLog.isValidSnapshot(entry) || -1 != entry.serviceId) continue;
                snapshotIndex = i;
                break;
            }
        }
        Path recordingLogBackup = clusterDir.toPath().resolve("recording.log.bak");
        try {
            Files.copy(clusterDir.toPath().resolve("recording.log"), recordingLogBackup, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        if (-1 == snapshotIndex) {
            this.updateRecordingLog(clusterDir, Collections.emptyList());
        } else {
            RecordingLog.Entry entry;
            ArrayList<RecordingLog.Entry> truncatedEntries = new ArrayList<RecordingLog.Entry>();
            int serviceId = -1;
            for (int i = snapshotIndex; i >= 0 && RecordingLog.isValidSnapshot(entry = entries.get(i)) && entry.serviceId == serviceId; ++serviceId, --i) {
                truncatedEntries.add(new RecordingLog.Entry(entry.recordingId, entry.leadershipTermId, 0L, 0L, entry.timestamp, entry.serviceId, entry.type, null, entry.isValid, -1));
            }
            Collections.reverse(truncatedEntries);
            this.updateRecordingLog(clusterDir, truncatedEntries);
        }
        return 0;
    }

    protected int errors(File clusterDir, PrintStream out) {
        ClusterMarkFile[] serviceMarkFiles;
        File clusterServicesDir = clusterDir;
        if (this.markFileExists(clusterDir) || this.timeoutMs > 0L) {
            try (ClusterMarkFile markFile = this.openMarkFile(clusterDir);){
                this.printTypeAndActivityTimestamp(out, markFile);
                this.printErrors(out, markFile);
                String aeronDirectory = markFile.decoder().aeronDirectory();
                out.println();
                this.printDriverErrors(out, aeronDirectory);
                clusterServicesDir = this.resolveClusterServicesDir(clusterDir, markFile.decoder());
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
        }
        for (ClusterMarkFile serviceMarkFile : serviceMarkFiles = this.openServiceMarkFiles(clusterServicesDir, out::println)) {
            this.printTypeAndActivityTimestamp(out, serviceMarkFile);
            this.printErrors(out, serviceMarkFile);
            serviceMarkFile.close();
        }
        return 0;
    }

    protected int listMembers(File clusterDir, PrintStream out) {
        block8: {
            if (this.markFileExists(clusterDir) || this.timeoutMs > 0L) {
                try (ClusterMarkFile markFile = this.openMarkFile(clusterDir);){
                    ClusterMembership clusterMembership = new ClusterMembership();
                    long timeoutMsToUse = Math.max(TimeUnit.SECONDS.toMillis(1L), this.timeoutMs);
                    if (this.queryClusterMembers(markFile, timeoutMsToUse, clusterMembership)) {
                        out.println("currentTimeNs=" + clusterMembership.currentTimeNs + ", leaderMemberId=" + clusterMembership.leaderMemberId + ", memberId=" + clusterMembership.memberId + ", activeMembers=" + String.valueOf(clusterMembership.activeMembers));
                        break block8;
                    }
                    out.println("timeout waiting for response from node");
                    int n = -1;
                    return n;
                }
            }
            out.println("cluster-mark.dat does not exist.");
            return -1;
        }
        return 0;
    }

    protected int printNextBackupQuery(File clusterDir, PrintStream out) {
        if (this.markFileExists(clusterDir) || this.timeoutMs > 0L) {
            try (ClusterMarkFile markFile = this.openMarkFile(clusterDir);){
                if (markFile.decoder().componentType() != ClusterComponentType.BACKUP) {
                    out.println("not a cluster backup node");
                    int n = -1;
                    return n;
                }
                out.format("%2$tF %1$tH:%1$tM:%1$tS next: %2$tF %2$tH:%2$tM:%2$tS%n", new Date(), new Date(this.nextBackupQueryDeadlineMs(markFile)));
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
            return -1;
        }
        return 0;
    }

    protected int nextBackupQuery(File clusterDir, PrintStream out, long delayMs) {
        if (this.markFileExists(clusterDir) || this.timeoutMs > 0L) {
            try (ClusterMarkFile markFile = this.openMarkFile(clusterDir);){
                if (markFile.decoder().componentType() != ClusterComponentType.BACKUP) {
                    out.println("not a cluster backup node");
                    int n = -1;
                    return n;
                }
                SystemEpochClock epochClock = SystemEpochClock.INSTANCE;
                this.nextBackupQueryDeadlineMs(markFile, epochClock.time() + delayMs);
                out.format("%2$tF %1$tH:%1$tM:%1$tS setting next: %2$tF %2$tH:%2$tM:%2$tS%n", new Date(), new Date(this.nextBackupQueryDeadlineMs(markFile)));
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
            return -1;
        }
        return 0;
    }

    protected void describe(PrintStream out, ClusterMarkFile[] serviceMarkFiles) {
        for (ClusterMarkFile serviceMarkFile : serviceMarkFiles) {
            this.printTypeAndActivityTimestamp(out, serviceMarkFile);
            out.println(serviceMarkFile.decoder());
            serviceMarkFile.close();
        }
    }

    protected int isLeader(File clusterDir, PrintStream out) {
        if (this.markFileExists(clusterDir)) {
            try (ClusterMarkFile markFile = this.openMarkFile(clusterDir);){
                String aeronDirectoryName = markFile.decoder().aeronDirectory();
                MutableLong nodeRoleCounter = new MutableLong(-1L);
                MutableLong electionStateCounter = new MutableLong(-1L);
                try (Aeron aeron = Aeron.connect(new Aeron.Context().aeronDirectoryName(aeronDirectoryName));){
                    CountersReader countersReader = aeron.countersReader();
                    countersReader.forEach((counterId, typeId, keyBuffer, label) -> {
                        if (201 == typeId) {
                            nodeRoleCounter.set(countersReader.getCounterValue(counterId));
                        } else if (207 == typeId) {
                            electionStateCounter.set(countersReader.getCounterValue(counterId));
                        }
                    });
                }
                if (nodeRoleCounter.get() == (long)Cluster.Role.LEADER.code() && electionStateCounter.get() == (long)ElectionState.CLOSED.code()) {
                    int n = 0;
                    return n;
                }
                int n = 1;
                return n;
            }
        }
        out.println("cluster-mark.dat does not exist.");
        return -1;
    }

    protected boolean markFileExists(File clusterDir) {
        File markFileDir = this.resolveClusterMarkFileDir(clusterDir);
        File markFile = new File(markFileDir, "cluster-mark.dat");
        return markFile.exists();
    }

    protected boolean listMembers(ClusterMembership clusterMembership, File clusterDir, long timeoutMs) {
        if (this.markFileExists(clusterDir) || timeoutMs > 0L) {
            try (ClusterMarkFile markFile = this.openMarkFile(clusterDir);){
                boolean bl = this.queryClusterMembers(markFile, timeoutMs, clusterMembership);
                return bl;
            }
        }
        return false;
    }

    protected boolean queryClusterMembers(ClusterMarkFile markFile, long timeoutMs, ClusterMembership clusterMembership) {
        return this.queryClusterMembers(markFile.loadControlProperties(), timeoutMs, clusterMembership);
    }

    /*
     * Exception decompiling
     */
    protected boolean queryClusterMembers(ClusterNodeControlProperties controlProperties, long timeoutMs, ClusterMembership clusterMembership) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 34[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected long nextBackupQueryDeadlineMs(File clusterDir) {
        if (this.markFileExists(clusterDir) || this.timeoutMs > 0L) {
            try (ClusterMarkFile markFile = this.openMarkFile(clusterDir);){
                long l = this.nextBackupQueryDeadlineMs(markFile);
                return l;
            }
        }
        return -1L;
    }

    protected long nextBackupQueryDeadlineMs(ClusterMarkFile markFile) {
        String aeronDirectoryName = markFile.decoder().aeronDirectory();
        MutableLong nextQueryMs = new MutableLong(-1L);
        try (Aeron aeron = Aeron.connect(new Aeron.Context().aeronDirectoryName(aeronDirectoryName));){
            aeron.countersReader().forEach((counterId, typeId, keyBuffer, label) -> {
                if (210 == typeId) {
                    nextQueryMs.set(aeron.countersReader().getCounterValue(counterId));
                }
            });
        }
        return nextQueryMs.get();
    }

    protected boolean nextBackupQueryDeadlineMs(File clusterDir, long timeMs) {
        if (this.markFileExists(clusterDir) || this.timeoutMs > 0L) {
            try (ClusterMarkFile markFile = this.openMarkFile(clusterDir);){
                boolean bl = this.nextBackupQueryDeadlineMs(markFile, timeMs);
                return bl;
            }
        }
        return false;
    }

    protected boolean nextBackupQueryDeadlineMs(ClusterMarkFile markFile, long timeMs) {
        String aeronDirectoryName = markFile.decoder().aeronDirectory();
        MutableBoolean result = new MutableBoolean(false);
        try (Aeron aeron = Aeron.connect(new Aeron.Context().aeronDirectoryName(aeronDirectoryName));){
            CountersReader countersReader = aeron.countersReader();
            countersReader.forEach((counterId, typeId, keyBuffer, label) -> {
                if (210 == typeId) {
                    AtomicCounter atomicCounter = new AtomicCounter(countersReader.valuesBuffer(), counterId, null);
                    atomicCounter.setRelease(timeMs);
                    result.value = true;
                }
            });
        }
        return result.value;
    }

    protected int invalidateLatestSnapshot(File clusterDir, PrintStream out) {
        try (RecordingLog recordingLog = new RecordingLog(clusterDir, false);){
            boolean result = recordingLog.invalidateLatestSnapshot();
            out.println(" invalidate latest snapshot: " + result);
            int n = result ? 0 : -1;
            return n;
        }
    }

    protected int describeLatestConsensusModuleSnapshot(File clusterDir, PrintStream out) {
        return this.describeLatestConsensusModuleSnapshot(clusterDir, out, null);
    }

    protected int describeLatestConsensusModuleSnapshot(File clusterDir, PrintStream out, BiConsumer<Image, Aeron> postConsensusImageDescriber) {
        RecordingLog.Entry entry = this.findLatestValidSnapshot(clusterDir);
        if (null == entry) {
            out.println("Snapshot not found");
            return -1;
        }
        ClusterNodeControlProperties properties = this.loadControlProperties(clusterDir);
        AeronArchive.Context archiveCtx = new AeronArchive.Context().clientName("cluster-tool").controlRequestChannel("aeron:ipc").controlResponseChannel("aeron:ipc");
        try (Aeron aeron = Aeron.connect(new Aeron.Context().aeronDirectoryName(properties.aeronDirectoryName));
             AeronArchive archive = AeronArchive.connect(archiveCtx.aeron(aeron));){
            int sessionId = (int)archive.startReplay(entry.recordingId, 0L, -1L, this.toolChannel, this.toolStreamId);
            String replayChannel = ChannelUri.addSessionId(this.toolChannel, sessionId);
            try (Subscription subscription = aeron.addSubscription(replayChannel, this.toolStreamId);){
                Image image;
                while ((image = subscription.imageBySessionId(sessionId)) == null) {
                    archive.checkForErrorResponse();
                    Thread.yield();
                }
                ConsensusModuleSnapshotAdapter adapter = new ConsensusModuleSnapshotAdapter(image, new ConsensusModuleSnapshotPrinter(out));
                while (true) {
                    int fragments = adapter.poll();
                    if (adapter.isDone()) break;
                    if (0 != fragments) continue;
                    if (image.isClosed()) {
                        throw new ClusterException("snapshot ended unexpectedly: " + String.valueOf(image));
                    }
                    archive.checkForErrorResponse();
                    Thread.yield();
                }
                out.println("Consensus Module Snapshot End: memberId=" + properties.memberId + " recordingId=" + entry.recordingId + " length=" + image.position());
                if (null != postConsensusImageDescriber) {
                    postConsensusImageDescriber.accept(image, aeron);
                }
            }
        }
        return 0;
    }

    protected int snapshot(File clusterDir, PrintStream out) {
        return this.toggleClusterState(out, clusterDir, ConsensusModule.State.ACTIVE, ClusterControl.ToggleState.SNAPSHOT, true, TimeUnit.SECONDS.toMillis(30L)) ? 0 : -1;
    }

    protected int suspend(File clusterDir, PrintStream out) {
        return this.toggleClusterState(out, clusterDir, ConsensusModule.State.ACTIVE, ClusterControl.ToggleState.SUSPEND, false, TimeUnit.SECONDS.toMillis(1L)) ? 0 : -1;
    }

    protected int resume(File clusterDir, PrintStream out) {
        return this.toggleClusterState(out, clusterDir, ConsensusModule.State.SUSPENDED, ClusterControl.ToggleState.RESUME, true, TimeUnit.SECONDS.toMillis(1L)) ? 0 : -1;
    }

    protected int shutdown(File clusterDir, PrintStream out) {
        return this.toggleClusterState(out, clusterDir, ConsensusModule.State.ACTIVE, ClusterControl.ToggleState.SHUTDOWN, false, TimeUnit.SECONDS.toMillis(1L)) ? 0 : -1;
    }

    protected int abort(File clusterDir, PrintStream out) {
        return this.toggleClusterState(out, clusterDir, ConsensusModule.State.ACTIVE, ClusterControl.ToggleState.ABORT, false, TimeUnit.SECONDS.toMillis(1L)) ? 0 : -1;
    }

    protected RecordingLog.Entry findLatestValidSnapshot(File clusterDir) {
        try (RecordingLog recordingLog = new RecordingLog(clusterDir, false);){
            RecordingLog.Entry entry = recordingLog.getLatestSnapshot(-1);
            return entry;
        }
    }

    protected ClusterNodeControlProperties loadControlProperties(File clusterDir) {
        ClusterNodeControlProperties properties;
        try (ClusterMarkFile markFile = this.openMarkFile(clusterDir);){
            properties = markFile.loadControlProperties();
        }
        return properties;
    }

    boolean toggleClusterState(PrintStream out, File clusterDir, ConsensusModule.State expectedState, ClusterControl.ToggleState toggleState, boolean waitForToggleToComplete, long defaultTimeoutMs) {
        return this.toggleState(out, clusterDir, true, expectedState, toggleState, ToggleApplication.CLUSTER_CONTROL, waitForToggleToComplete, defaultTimeoutMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends Enum<T>> boolean toggleState(PrintStream out, File clusterDir, boolean isLeaderRequired, ConsensusModule.State expectedState, T targetState, ToggleApplication<T> toggleApplication, boolean waitForToggleToComplete, long defaultTimeoutMs) {
        ClusterNodeControlProperties clusterNodeControlProperties;
        int clusterId;
        if (!this.markFileExists(clusterDir) && this.timeoutMs <= 0L) {
            out.println("cluster-mark.dat does not exist.");
            return false;
        }
        try (ClusterMarkFile markFile = this.openMarkFile(clusterDir);){
            clusterId = markFile.clusterId();
            clusterNodeControlProperties = markFile.loadControlProperties();
        }
        ClusterMembership clusterMembership = new ClusterMembership();
        long queryTimeoutMs = Math.max(TimeUnit.SECONDS.toMillis(1L), this.timeoutMs);
        if (!this.queryClusterMembers(clusterNodeControlProperties, queryTimeoutMs, clusterMembership)) {
            out.println("Timed out querying cluster.");
            return false;
        }
        String prefix = "Member [" + clusterMembership.memberId + "]: ";
        if (isLeaderRequired && clusterMembership.leaderMemberId != clusterMembership.memberId) {
            out.println(prefix + "Current node is not the leader (leaderMemberId = " + clusterMembership.leaderMemberId + "), unable to " + String.valueOf(targetState));
            return false;
        }
        File cncFile = new File(clusterNodeControlProperties.aeronDirectoryName, "cnc.dat");
        if (!cncFile.exists()) {
            out.println(prefix + "Unable to locate media driver. C`n`C file [" + cncFile.getAbsolutePath() + "] does not exist.");
            return false;
        }
        CountersReader countersReader = ClusterControl.mapCounters(cncFile);
        try {
            ConsensusModule.State moduleState = ConsensusModule.State.find(countersReader, clusterId);
            if (null == moduleState) {
                out.println(prefix + "Unable to resolve state of consensus module.");
                boolean bl = false;
                return bl;
            }
            if (expectedState != moduleState) {
                out.println(prefix + "Unable to " + String.valueOf(targetState) + " as the state of the consensus module is " + String.valueOf((Object)moduleState) + ", but needs to be " + String.valueOf((Object)expectedState));
                boolean bl = false;
                return bl;
            }
            AtomicCounter controlToggle = toggleApplication.find(countersReader, clusterId);
            if (null == controlToggle) {
                out.println(prefix + "Failed to find control toggle");
                boolean bl = false;
                return bl;
            }
            if (!toggleApplication.apply(controlToggle, targetState)) {
                out.println(prefix + "Failed to apply " + String.valueOf(targetState) + ", current toggle value = " + String.valueOf((Object)ClusterControl.ToggleState.get(controlToggle)));
                boolean bl = false;
                return bl;
            }
            if (waitForToggleToComplete) {
                long toggleTimeoutMs = Math.max(defaultTimeoutMs, this.timeoutMs);
                long deadlineMs = System.currentTimeMillis() + toggleTimeoutMs;
                Object currentState = null;
                do {
                    Thread.yield();
                } while (System.currentTimeMillis() <= deadlineMs && !toggleApplication.isNeutral(currentState = (Object)toggleApplication.get(controlToggle)));
                if (!toggleApplication.isNeutral(currentState)) {
                    out.println(prefix + "Timed out after " + toggleTimeoutMs + "ms waiting for " + String.valueOf(targetState) + " to complete.");
                }
            }
            out.println(prefix + String.valueOf(targetState) + " applied successfully");
            boolean bl = true;
            return bl;
        }
        finally {
            IoUtil.unmap(countersReader.valuesBuffer().byteBuffer());
        }
    }

    protected int describeClusterMarkFile(File clusterDir, PrintStream out) {
        File clusterServicesDir;
        if (this.markFileExists(clusterDir) || this.timeoutMs > 0L) {
            try (ClusterMarkFile markFile = this.openMarkFile(clusterDir);){
                MarkFileHeaderDecoder decoder = markFile.decoder();
                this.printTypeAndActivityTimestamp(out, markFile);
                out.println(decoder);
                clusterServicesDir = this.resolveClusterServicesDir(clusterDir, decoder);
            }
        } else {
            out.println("cluster-mark.dat does not exist.");
            return -1;
        }
        ClusterMarkFile[] serviceMarkFiles = this.openServiceMarkFiles(clusterServicesDir, out::println);
        this.describe(out, serviceMarkFiles);
        return 0;
    }

    File resolveClusterServicesDir(File clusterDir, MarkFileHeaderDecoder decoder) {
        File clusterServicesDir;
        if (1 <= decoder.sbeSchemaVersion()) {
            decoder.sbeRewind();
            decoder.skipAeronDirectory();
            decoder.skipControlChannel();
            decoder.skipIngressChannel();
            decoder.skipServiceName();
            decoder.skipAuthenticator();
            String servicesClusterDir = decoder.servicesClusterDir();
            clusterServicesDir = Strings.isEmpty(servicesClusterDir) ? clusterDir : new File(servicesClusterDir);
        } else {
            clusterServicesDir = clusterDir;
        }
        return clusterServicesDir;
    }

    ClusterMarkFile openMarkFile(File clusterDir) {
        File markFileDir = this.resolveClusterMarkFileDir(clusterDir);
        return new ClusterMarkFile(markFileDir, "cluster-mark.dat", System::currentTimeMillis, this.timeoutMs, null);
    }

    private ClusterMarkFile[] openServiceMarkFiles(File clusterDir, Consumer<String> logger) {
        File[] clusterMarkFileNames = clusterDir.listFiles((dir, name) -> name.startsWith("cluster-mark-service-") && (name.endsWith(".dat") || name.endsWith(".lnk")));
        if (null == clusterMarkFileNames) {
            clusterMarkFileNames = new File[]{};
        }
        ArrayList<File> resolvedMarkFileNames = new ArrayList<File>();
        this.resolveServiceMarkFileNames(clusterMarkFileNames, resolvedMarkFileNames);
        ClusterMarkFile[] clusterMarkFiles = new ClusterMarkFile[clusterMarkFileNames.length];
        int n = resolvedMarkFileNames.size();
        for (int i = 0; i < n; ++i) {
            File resolvedMarkFile = resolvedMarkFileNames.get(i);
            clusterMarkFiles[i] = new ClusterMarkFile(resolvedMarkFile.getParentFile(), resolvedMarkFile.getName(), System::currentTimeMillis, this.timeoutMs, logger);
        }
        return clusterMarkFiles;
    }

    private void resolveServiceMarkFileNames(File[] clusterMarkFiles, ArrayList<File> resolvedFiles) {
        String name;
        String filename;
        HashSet<String> resolvedServices = new HashSet<String>();
        for (File clusterMarkFile : clusterMarkFiles) {
            filename = clusterMarkFile.getName();
            if (!filename.endsWith(".lnk")) continue;
            name = filename.substring(0, filename.length() - ".lnk".length());
            File markFileDir = this.resolveDirectoryFromLinkFile(clusterMarkFile);
            resolvedFiles.add(new File(markFileDir, name + ".dat"));
            resolvedServices.add(name);
        }
        for (File clusterMarkFile : clusterMarkFiles) {
            filename = clusterMarkFile.getName();
            if (!filename.endsWith(".dat") || resolvedServices.contains(name = filename.substring(0, filename.length() - ".dat".length()))) continue;
            resolvedFiles.add(clusterMarkFile);
            resolvedServices.add(name);
        }
    }

    void printTypeAndActivityTimestamp(PrintStream out, ClusterMarkFile markFile) {
        this.printTypeAndActivityTimestamp(out, markFile.decoder().componentType().toString(), markFile.decoder().startTimestamp(), markFile.activityTimestampVolatile());
    }

    void printTypeAndActivityTimestamp(PrintStream out, String clusterComponentType, long startTimestampMs, long activityTimestampMs) {
        out.print("Type: " + clusterComponentType + " ");
        out.format("%1$tH:%1$tM:%1$tS (start: %2$tF %2$tH:%2$tM:%2$tS, activity: %3$tF %3$tH:%3$tM:%3$tS)%n", new Date(), new Date(startTimestampMs), new Date(activityTimestampMs));
    }

    void printErrors(PrintStream out, Supplier<AtomicBuffer> errorBuffer, String name) {
        out.println(name + " component error log:");
        CommonContext.printErrorLog(errorBuffer.get(), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printDriverErrors(PrintStream out, String aeronDirectory) {
        out.println("Aeron driver error log (directory: " + aeronDirectory + "):");
        File cncFile = new File(aeronDirectory, "cnc.dat");
        MappedByteBuffer cncByteBuffer = null;
        try {
            cncByteBuffer = IoUtil.mapExistingFile(cncFile, FileChannel.MapMode.READ_ONLY, "cnc");
            UnsafeBuffer cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(cncByteBuffer);
            int cncVersion = cncMetaDataBuffer.getInt(CncFileDescriptor.cncVersionOffset(0));
            CncFileDescriptor.checkVersion(cncVersion);
            CommonContext.printErrorLog(CncFileDescriptor.createErrorLogBuffer(cncByteBuffer, cncMetaDataBuffer), out);
        }
        finally {
            if (null != cncByteBuffer) {
                IoUtil.unmap(cncByteBuffer);
            }
        }
    }

    File resolveClusterMarkFileDir(File dir) {
        File linkFile = new File(dir, "cluster-mark.lnk");
        return linkFile.exists() ? this.resolveDirectoryFromLinkFile(linkFile) : dir;
    }

    File resolveDirectoryFromLinkFile(File linkFile) {
        File markFileDir;
        try {
            byte[] bytes = Files.readAllBytes(linkFile.toPath());
            String markFileDirPath = new String(bytes, StandardCharsets.US_ASCII).trim();
            markFileDir = new File(markFileDirPath);
        }
        catch (IOException ex) {
            throw new RuntimeException("failed to read link file=" + String.valueOf(linkFile), ex);
        }
        return markFileDir;
    }

    protected String toolChannel() {
        return this.toolChannel;
    }

    protected int toolStreamId() {
        return this.toolStreamId;
    }

    protected long timeoutMs() {
        return this.timeoutMs;
    }

    private void printErrors(PrintStream out, ClusterMarkFile markFile) {
        this.printErrors(out, markFile::errorBuffer, "Cluster");
    }

    private boolean isRecordingLogSorted(List<RecordingLog.Entry> entries) {
        for (int i = entries.size() - 1; i >= 0; --i) {
            if (entries.get((int)i).entryIndex == i) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecordingLog(File clusterDir, List<RecordingLog.Entry> entries) {
        block14: {
            Path recordingLog = clusterDir.toPath().resolve("recording.log");
            try {
                if (entries.isEmpty()) {
                    Files.delete(recordingLog);
                    break block14;
                }
                Path newRecordingLog = clusterDir.toPath().resolve("recording.log.tmp");
                Files.deleteIfExists(newRecordingLog);
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(4096).order(ByteOrder.LITTLE_ENDIAN);
                UnsafeBuffer buffer = new UnsafeBuffer(byteBuffer);
                try (FileChannel fileChannel = FileChannel.open(newRecordingLog, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                    long position = 0L;
                    for (RecordingLog.Entry e : entries) {
                        RecordingLog.writeEntryToBuffer(e, buffer);
                        byteBuffer.limit(e.length()).position(0);
                        if (e.length() != fileChannel.write(byteBuffer, position)) {
                            throw new ClusterException("failed to write recording");
                        }
                        position += (long)e.length();
                    }
                }
                finally {
                    BufferUtil.free(byteBuffer);
                }
                Files.delete(recordingLog);
                Files.move(newRecordingLog, recordingLog, new CopyOption[0]);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }
}

