/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.ClusterSession;
import io.aeron.cluster.client.AeronCluster;
import io.aeron.cluster.codecs.AdminRequestType;
import io.aeron.cluster.codecs.AdminResponseCode;
import io.aeron.cluster.codecs.AdminResponseEncoder;
import io.aeron.cluster.codecs.ChallengeEncoder;
import io.aeron.cluster.codecs.EventCode;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.NewLeaderEventEncoder;
import io.aeron.cluster.codecs.SessionEventEncoder;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.collections.ArrayUtil;

class EgressPublisher {
    private static final int SEND_ATTEMPTS = 3;
    private final BufferClaim bufferClaim = new BufferClaim();
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(4096);
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final SessionEventEncoder sessionEventEncoder = new SessionEventEncoder();
    private final ChallengeEncoder challengeEncoder = new ChallengeEncoder();
    private final NewLeaderEventEncoder newLeaderEventEncoder = new NewLeaderEventEncoder();
    private final AdminResponseEncoder adminResponseEncoder = new AdminResponseEncoder();
    private final long leaderHeartbeatTimeoutNs;

    EgressPublisher(long leaderHeartbeatTimeoutNs) {
        this.leaderHeartbeatTimeoutNs = leaderHeartbeatTimeoutNs;
    }

    boolean sendEvent(ClusterSession session, long leadershipTermId, int leaderMemberId, EventCode code, String detail) {
        int length = 52 + SessionEventEncoder.detailHeaderLength() + detail.length();
        int attempts = 3;
        do {
            long position;
            if ((position = session.tryClaim(length, this.bufferClaim)) <= 0L) continue;
            this.sessionEventEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).clusterSessionId(session.id()).correlationId(session.correlationId()).leadershipTermId(leadershipTermId).leaderMemberId(leaderMemberId).code(code).version(AeronCluster.Configuration.PROTOCOL_SEMANTIC_VERSION).leaderHeartbeatTimeoutNs(this.leaderHeartbeatTimeoutNs).detail(detail);
            this.bufferClaim.commit();
            return true;
        } while (--attempts > 0);
        return false;
    }

    boolean sendChallenge(ClusterSession session, byte[] encodedChallenge) {
        this.challengeEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).clusterSessionId(session.id()).correlationId(session.correlationId()).putEncodedChallenge(encodedChallenge, 0, encodedChallenge.length);
        int length = 8 + this.challengeEncoder.encodedLength();
        int attempts = 3;
        do {
            long position;
            if ((position = session.offer(this.buffer, 0, length)) <= 0L) continue;
            return true;
        } while (--attempts > 0);
        return false;
    }

    boolean newLeader(ClusterSession session, long leadershipTermId, int leaderMemberId, String ingressEndpoints) {
        int length = 28 + NewLeaderEventEncoder.ingressEndpointsHeaderLength() + ingressEndpoints.length();
        int attempts = 3;
        do {
            long position;
            if ((position = session.tryClaim(length, this.bufferClaim)) <= 0L) continue;
            this.newLeaderEventEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).clusterSessionId(session.id()).leadershipTermId(leadershipTermId).leaderMemberId(leaderMemberId).ingressEndpoints(ingressEndpoints);
            this.bufferClaim.commit();
            return true;
        } while (--attempts > 0);
        return false;
    }

    boolean sendAdminResponse(ClusterSession session, long correlationId, AdminRequestType adminRequestType, AdminResponseCode responseCode, String message) {
        this.adminResponseEncoder.wrapAndApplyHeader(this.buffer, 0, this.messageHeaderEncoder).clusterSessionId(session.id()).correlationId(correlationId).requestType(adminRequestType).responseCode(responseCode).message(message).putPayload(ArrayUtil.EMPTY_BYTE_ARRAY, 0, 0);
        int length = 8 + this.adminResponseEncoder.encodedLength();
        int attempts = 3;
        do {
            long position;
            if ((position = session.offer(this.buffer, 0, length)) <= 0L) continue;
            return true;
        } while (--attempts > 0);
        return false;
    }

    public String toString() {
        return "EgressPublisher{}";
    }
}

