/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.cluster.client.ClusterException;
import java.util.ArrayDeque;

final class ServiceAck {
    static final ServiceAck[] EMPTY_SERVICE_ACKS = new ServiceAck[0];
    private final long ackId;
    private final long logPosition;
    private final long relevantId;

    ServiceAck(long ackId, long logPosition, long relevantId) {
        this.logPosition = logPosition;
        this.ackId = ackId;
        this.relevantId = relevantId;
    }

    long ackId() {
        return this.ackId;
    }

    long logPosition() {
        return this.logPosition;
    }

    long relevantId() {
        return this.relevantId;
    }

    static boolean hasReached(long logPosition, long ackId, ArrayDeque<ServiceAck>[] queues) {
        int serviceCount = queues.length;
        for (int serviceId = 0; serviceId < serviceCount; ++serviceId) {
            ServiceAck serviceAck = queues[serviceId].peek();
            if (null == serviceAck) {
                return false;
            }
            if (serviceAck.ackId == ackId && serviceAck.logPosition == logPosition) continue;
            throw new ClusterException("ack out of sequence: expected [ackId=" + ackId + ", logPosition=" + logPosition + "] vs received [ackId=" + serviceAck.ackId + ", logPosition=" + serviceAck.logPosition + ", relevantId=" + serviceAck.relevantId + ", serviceId=" + serviceId + "]");
        }
        return true;
    }

    static void removeHead(ArrayDeque<ServiceAck>[] queues) {
        for (ArrayDeque<ServiceAck> queue : queues) {
            queue.pollFirst();
        }
    }

    static ArrayDeque<ServiceAck>[] newArrayOfQueues(int serviceCount) {
        ArrayDeque[] queues = new ArrayDeque[serviceCount];
        for (int serviceId = 0; serviceId < serviceCount; ++serviceId) {
            queues[serviceId] = new ArrayDeque();
        }
        return queues;
    }

    public String toString() {
        return "ServiceAck{ackId=" + this.ackId + ", logPosition=" + this.logPosition + ", relevantId=" + this.relevantId + "}";
    }
}

