/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.client;

import io.aeron.ControlledFragmentAssembler;
import io.aeron.Subscription;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.client.ControlledEgressListener;
import io.aeron.cluster.client.ControlledEgressListenerExtension;
import io.aeron.cluster.codecs.AdminRequestType;
import io.aeron.cluster.codecs.AdminResponseCode;
import io.aeron.cluster.codecs.AdminResponseDecoder;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.NewLeaderEventDecoder;
import io.aeron.cluster.codecs.SessionEventDecoder;
import io.aeron.cluster.codecs.SessionMessageHeaderDecoder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public final class ControlledEgressAdapter
implements ControlledFragmentHandler {
    private final long clusterSessionId;
    private final int fragmentLimit;
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final SessionEventDecoder sessionEventDecoder = new SessionEventDecoder();
    private final NewLeaderEventDecoder newLeaderEventDecoder = new NewLeaderEventDecoder();
    private final AdminResponseDecoder adminResponseDecoder = new AdminResponseDecoder();
    private final SessionMessageHeaderDecoder sessionMessageHeaderDecoder = new SessionMessageHeaderDecoder();
    private final ControlledFragmentAssembler fragmentAssembler = new ControlledFragmentAssembler(this);
    private final ControlledEgressListener listener;
    private final ControlledEgressListenerExtension listenerExtension;
    private final Subscription subscription;

    public ControlledEgressAdapter(ControlledEgressListener listener, long clusterSessionId, Subscription subscription, int fragmentLimit) {
        this(listener, null, clusterSessionId, subscription, fragmentLimit);
    }

    public ControlledEgressAdapter(ControlledEgressListener listener, ControlledEgressListenerExtension listenerExtension, long clusterSessionId, Subscription subscription, int fragmentLimit) {
        this.clusterSessionId = clusterSessionId;
        this.fragmentLimit = fragmentLimit;
        this.listener = listener;
        this.listenerExtension = listenerExtension;
        this.subscription = subscription;
    }

    public int poll() {
        return this.subscription.controlledPoll(this.fragmentAssembler, this.fragmentLimit);
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        int templateId = this.messageHeaderDecoder.templateId();
        int schemaId = this.messageHeaderDecoder.schemaId();
        if (schemaId != 111) {
            if (this.listenerExtension != null) {
                return this.listenerExtension.onExtensionMessage(this.messageHeaderDecoder.blockLength(), templateId, schemaId, this.messageHeaderDecoder.version(), buffer, offset + 8, length - 8);
            }
            throw new ClusterException("expected schemaId=111, actual=" + schemaId);
        }
        switch (templateId) {
            case 1: {
                this.sessionMessageHeaderDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.sessionMessageHeaderDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                return this.listener.onMessage(sessionId, this.sessionMessageHeaderDecoder.timestamp(), buffer, offset + 32, length - 32, header);
            }
            case 2: {
                this.sessionEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.sessionEventDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                this.listener.onSessionEvent(this.sessionEventDecoder.correlationId(), sessionId, this.sessionEventDecoder.leadershipTermId(), this.sessionEventDecoder.leaderMemberId(), this.sessionEventDecoder.code(), this.sessionEventDecoder.detail());
                break;
            }
            case 6: {
                this.newLeaderEventDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.newLeaderEventDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                this.listener.onNewLeader(sessionId, this.newLeaderEventDecoder.leadershipTermId(), this.newLeaderEventDecoder.leaderMemberId(), this.newLeaderEventDecoder.ingressEndpoints());
                break;
            }
            case 27: {
                this.adminResponseDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                long sessionId = this.adminResponseDecoder.clusterSessionId();
                if (sessionId != this.clusterSessionId) break;
                long correlationId = this.adminResponseDecoder.correlationId();
                AdminRequestType requestType = this.adminResponseDecoder.requestType();
                AdminResponseCode responseCode = this.adminResponseDecoder.responseCode();
                String message = this.adminResponseDecoder.message();
                int payloadOffset = this.adminResponseDecoder.offset() + 24 + AdminResponseDecoder.messageHeaderLength() + message.length() + AdminResponseDecoder.payloadHeaderLength();
                int payloadLength = this.adminResponseDecoder.payloadLength();
                this.listener.onAdminResponse(sessionId, correlationId, requestType, responseCode, message, buffer, payloadOffset, payloadLength);
                break;
            }
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }
}

