/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.service;

import io.aeron.ExclusivePublication;
import io.aeron.cluster.codecs.ClientSessionEncoder;
import io.aeron.cluster.service.ClientSession;
import io.aeron.cluster.service.SnapshotTaker;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.IdleStrategy;

final class ServiceSnapshotTaker
extends SnapshotTaker {
    private final ExpandableArrayBuffer offerBuffer = new ExpandableArrayBuffer(1024);
    private final ClientSessionEncoder clientSessionEncoder = new ClientSessionEncoder();

    ServiceSnapshotTaker(ExclusivePublication publication, IdleStrategy idleStrategy, AgentInvoker aeronClientInvoker) {
        super(publication, idleStrategy, aeronClientInvoker);
    }

    void snapshotSession(ClientSession session) {
        block3: {
            String responseChannel = session.responseChannel();
            byte[] encodedPrincipal = session.encodedPrincipal();
            int length = 20 + ClientSessionEncoder.responseChannelHeaderLength() + responseChannel.length() + ClientSessionEncoder.encodedPrincipalHeaderLength() + encodedPrincipal.length;
            if (length <= this.publication.maxPayloadLength()) {
                this.idleStrategy.reset();
                while (true) {
                    long result;
                    if ((result = this.publication.tryClaim(length, this.bufferClaim)) > 0L) {
                        MutableDirectBuffer buffer = this.bufferClaim.buffer();
                        int offset = this.bufferClaim.offset();
                        this.encodeSession(session, responseChannel, encodedPrincipal, buffer, offset);
                        this.bufferClaim.commit();
                        break block3;
                    }
                    this.checkResultAndIdle(result);
                }
            }
            boolean offset = false;
            this.encodeSession(session, responseChannel, encodedPrincipal, this.offerBuffer, 0);
            this.offer(this.offerBuffer, 0, length);
        }
    }

    private void encodeSession(ClientSession session, String responseChannel, byte[] encodedPrincipal, MutableDirectBuffer buffer, int offset) {
        this.clientSessionEncoder.wrapAndApplyHeader(buffer, offset, this.messageHeaderEncoder).clusterSessionId(session.id()).responseStreamId(session.responseStreamId()).responseChannel(responseChannel).putEncodedPrincipal(encodedPrincipal, 0, encodedPrincipal.length);
    }
}

