/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.counter;

import io.aeron.counter.AeronCounter;
import io.aeron.counter.CounterInfo;
import io.aeron.utility.ElementIO;
import io.aeron.utility.Processor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.aeron.counter.AeronCounter"})
public class CounterProcessor
extends Processor {
    private static final String SYSTEM_COUNTER_ID_PREFIX = "SYSTEM_COUNTER_ID_";
    private static final String TYPE_ID_SUFFIX = "_TYPE_ID";

    @Override
    protected String getEnabledPropertyName() {
        return "aeron.build.counterProcessor.enabled";
    }

    @Override
    protected String getPrintNotesPropertyName() {
        return "aeron.build.counterProcessor.printNotes";
    }

    @Override
    protected String getFailOnErrorPropertyName() {
        return "aeron.build.counterProcessor.failOnError";
    }

    @Override
    public void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<String, CounterInfo> counterInfoMap = new HashMap<String, CounterInfo>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                try {
                    if (!(element instanceof VariableElement)) continue;
                    this.processElement(counterInfoMap, (VariableElement)element);
                }
                catch (Exception e) {
                    this.error("an error occurred processing an element: " + e.getMessage(), element);
                    e.printStackTrace(System.err);
                }
            }
        }
        if (!counterInfoMap.isEmpty()) {
            try {
                FileObject resourceFile = this.processingEnv.getFiler().createResource(StandardLocation.NATIVE_HEADER_OUTPUT, "", "counter-info.dat", new Element[0]);
                ElementIO.write(resourceFile, counterInfoMap.values());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "an error occurred while writing output: " + e.getMessage());
            }
        }
    }

    private void processElement(Map<String, CounterInfo> counterInfoMap, VariableElement element) {
        AeronCounter counter = element.getAnnotation(AeronCounter.class);
        if (Objects.isNull(counter)) {
            this.error("element found with no expected annotations", element);
            return;
        }
        String name = element.toString();
        boolean systemCounterId = name.startsWith(SYSTEM_COUNTER_ID_PREFIX);
        boolean typeId = name.endsWith(TYPE_ID_SUFFIX);
        if (!systemCounterId && !typeId) {
            this.error("unable to determine type and/or id", element);
            return;
        }
        CounterInfo counterInfo = new CounterInfo(systemCounterId ? name.substring(SYSTEM_COUNTER_ID_PREFIX.length()) : name.substring(0, name.length() - TYPE_ID_SUFFIX.length()));
        if (null != counterInfoMap.put(counterInfo.name, counterInfo)) {
            this.error("duplicate counters found", element);
            return;
        }
        counterInfo.counterDescription = this.getDocComment(element);
        Object constantValue = element.getConstantValue();
        if (constantValue instanceof Integer) {
            counterInfo.id = (Integer)constantValue;
        } else {
            this.error("Counter value must be an Integer", element);
        }
        if (!counter.existsInC()) {
            this.note("Counter isn't expected to exist in C", element);
            counterInfo.existsInC = false;
        }
        if (counterInfo.existsInC) {
            StringBuilder builder = new StringBuilder();
            builder.append("AERON_");
            if (systemCounterId) {
                builder.append(SYSTEM_COUNTER_ID_PREFIX);
            } else {
                builder.append("COUNTER_");
            }
            if (counter.expectedCName().isEmpty()) {
                if (typeId && counterInfo.name.startsWith("DRIVER_")) {
                    builder.append(counterInfo.name.substring(7));
                } else {
                    builder.append(counterInfo.name);
                }
            } else {
                this.note("Counter's C name is overridden", element);
                builder.append(counter.expectedCName());
            }
            if (typeId) {
                builder.append(TYPE_ID_SUFFIX);
            }
            counterInfo.expectedCName = builder.toString();
        }
    }
}

