/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.counter.validation;

import io.aeron.counter.CounterInfo;
import io.aeron.counter.validation.Validation;
import io.aeron.counter.validation.ValidationReport;
import io.aeron.validation.Grep;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class Validator {
    private final String sourceDir;
    private final ValidationReport report;

    static ValidationReport validate(Collection<CounterInfo> counterInfoCollection, String sourceDir) {
        return new Validator((String)sourceDir).validate(counterInfoCollection).report;
    }

    private Validator(String sourceDir) {
        this.sourceDir = sourceDir;
        this.report = new ValidationReport();
    }

    private Validator validate(Collection<CounterInfo> counterInfoCollection) {
        counterInfoCollection.forEach(this::validateCExpectations);
        this.identifyExtraCCounters(counterInfoCollection);
        return this;
    }

    private void identifyExtraCCounters(Collection<CounterInfo> counterInfoCollection) {
        Pattern compiledPattern = Pattern.compile("#define[ \t]+([A-Z_]+)[ \t]+\\([0-9]+\\)");
        List expectedCNames = counterInfoCollection.stream().filter(counterInfo -> counterInfo.existsInC).map(counterInfo -> counterInfo.expectedCName).collect(Collectors.toList());
        String pattern = "#define[ \t]+AERON_COUNTER_([A-Z_]+)_TYPE_ID[ \t]+\\([0-9]+\\)";
        Grep grep = Grep.execute("#define[ \t]+AERON_COUNTER_([A-Z_]+)_TYPE_ID[ \t]+\\([0-9]+\\)", this.sourceDir);
        grep.forEach((fileAndLineNo, line) -> {
            Matcher matcher = compiledPattern.matcher((CharSequence)line);
            if (matcher.find()) {
                String name = matcher.group(1);
                if (expectedCNames.stream().noneMatch(cName -> cName.equals(name))) {
                    this.report.addValidation(false, name, "Found C counter with no matching Java counter - " + fileAndLineNo);
                }
            } else {
                System.err.println("malformed line: " + line);
            }
        });
    }

    private void validateCExpectations(CounterInfo counterInfo) {
        if (counterInfo.existsInC) {
            this.report.addValidation(counterInfo, this::validate);
        }
    }

    private void validate(Validation validation, CounterInfo counterInfo) {
        block7: {
            String pattern = "#define[ \t]+" + counterInfo.expectedCName + "[ \t]+\\([0-9]+\\)";
            Grep grep = Grep.execute(pattern, this.sourceDir);
            if (grep.success()) {
                Matcher matcher = Pattern.compile("#define[ \t]+[A-Z_]+[ \t]+\\(([0-9]+)\\)").matcher(grep.getOutput());
                if (matcher.find()) {
                    String id = matcher.group(1);
                    try {
                        if (counterInfo.id == Integer.parseInt(id)) {
                            validation.valid("Expected ID found in " + grep.getFilenameAndLine());
                            break block7;
                        }
                        validation.invalid("Incorrect ID found.  Expected: " + counterInfo.id + " but found: " + id);
                    }
                    catch (NumberFormatException numberFormatException) {
                        validation.invalid("Unable to parse ID.  Expected a number but found: " + id);
                    }
                } else {
                    validation.invalid("WHAT??");
                }
            } else {
                validation.invalid("Expected ID NOT found.  `grep` command:\n" + grep.getCommandString());
            }
        }
    }
}

