/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.DriverConductor;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.SendChannelEndpoint;
import io.aeron.driver.media.UdpChannel;
import java.net.InetSocketAddress;
import org.agrona.concurrent.ManyToOneConcurrentLinkedQueue;
import org.agrona.concurrent.status.AtomicCounter;

public final class DriverConductorProxy {
    private DriverConductor driverConductor;
    private final ThreadingMode threadingMode;
    private final ManyToOneConcurrentLinkedQueue<Runnable> commandQueue;
    private final AtomicCounter failCount;
    private final boolean notConcurrent;

    DriverConductorProxy(ThreadingMode threadingMode, ManyToOneConcurrentLinkedQueue<Runnable> commandQueue, AtomicCounter failCount) {
        this.threadingMode = threadingMode;
        this.commandQueue = commandQueue;
        this.failCount = failCount;
        this.notConcurrent = ThreadingMode.SHARED == threadingMode || ThreadingMode.INVOKER == threadingMode;
    }

    public boolean notConcurrent() {
        return this.notConcurrent;
    }

    public ThreadingMode threadingMode() {
        return this.threadingMode;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{threadingMode=" + String.valueOf((Object)this.threadingMode) + ", failCount=" + String.valueOf(this.failCount) + "}";
    }

    public void channelEndpointError(long statusIndicatorId, Exception ex) {
    }

    public void reResolveEndpoint(String endpoint, SendChannelEndpoint channelEndpoint, InetSocketAddress address) {
        if (this.notConcurrent()) {
            this.driverConductor.onReResolveEndpoint(endpoint, channelEndpoint, address);
        } else {
            this.offer(() -> this.driverConductor.onReResolveEndpoint(endpoint, channelEndpoint, address));
        }
    }

    public void reResolveControl(String endpoint, UdpChannel udpChannel, ReceiveChannelEndpoint channelEndpoint, InetSocketAddress address) {
        if (this.notConcurrent()) {
            this.driverConductor.onReResolveControl(endpoint, udpChannel, channelEndpoint, address);
        } else {
            this.offer(() -> this.driverConductor.onReResolveControl(endpoint, udpChannel, channelEndpoint, address));
        }
    }

    public void closeReceiveDestinationIndicators(ReceiveDestinationTransport destinationTransport) {
        if (this.notConcurrent()) {
            this.driverConductor.closeReceiveDestinationIndicators(destinationTransport);
        } else {
            this.offer(() -> this.driverConductor.closeReceiveDestinationIndicators(destinationTransport));
        }
    }

    public void responseSetup(long responseCorrelationId, int responseSessionId) {
        if (this.notConcurrent()) {
            this.driverConductor.responseSetup(responseCorrelationId, responseSessionId);
        } else {
            this.offer(() -> this.driverConductor.responseSetup(responseCorrelationId, responseSessionId));
        }
    }

    public void responseConnected(long responseCorrelationId) {
        if (this.notConcurrent()) {
            this.driverConductor.responseConnected(responseCorrelationId);
        } else {
            this.offer(() -> this.driverConductor.responseConnected(responseCorrelationId));
        }
    }

    void driverConductor(DriverConductor driverConductor) {
        this.driverConductor = driverConductor;
    }

    void createPublicationImage(int sessionId, int streamId, int initialTermId, int activeTermId, int termOffset, int termLength, int mtuLength, int transportIndex, short flags, InetSocketAddress controlAddress, InetSocketAddress srcAddress, ReceiveChannelEndpoint channelEndpoint) {
        if (this.notConcurrent()) {
            this.driverConductor.onCreatePublicationImage(sessionId, streamId, initialTermId, activeTermId, termOffset, termLength, mtuLength, transportIndex, flags, controlAddress, srcAddress, channelEndpoint);
        } else {
            this.offer(() -> this.driverConductor.onCreatePublicationImage(sessionId, streamId, initialTermId, activeTermId, termOffset, termLength, mtuLength, transportIndex, flags, controlAddress, srcAddress, channelEndpoint));
        }
    }

    void onPublicationError(long registrationId, long destinationRegistrationId, int sessionId, int streamId, long receiverId, long groupId, InetSocketAddress srcAddress, int errorCode, String errorMessage) {
        if (this.notConcurrent()) {
            this.driverConductor.onPublicationError(registrationId, destinationRegistrationId, sessionId, streamId, receiverId, groupId, srcAddress, errorCode, errorMessage);
        } else {
            this.offer(() -> this.driverConductor.onPublicationError(registrationId, destinationRegistrationId, sessionId, streamId, receiverId, groupId, srcAddress, errorCode, errorMessage));
        }
    }

    private void offer(Runnable cmd) {
        if (!this.commandQueue.offer(cmd)) {
            throw new IllegalStateException("offer failed");
        }
    }
}

