/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.CommonContext;
import io.aeron.driver.Configuration;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.media.UdpChannel;
import org.agrona.SystemUtil;

final class SubscriptionParams {
    int initialTermId = 0;
    int termId = 0;
    int termOffset = 0;
    int sessionId = 0;
    boolean hasJoinPosition = false;
    boolean hasSessionId = false;
    boolean isReliable = true;
    boolean isRejoin = true;
    boolean isSparse = true;
    boolean isTether = true;
    boolean isResponse = false;
    CommonContext.InferableBoolean group = CommonContext.InferableBoolean.INFER;
    int receiverWindowLength;
    long untetheredWindowLimitTimeoutNs;
    long untetheredLingerTimeoutNs;
    long untetheredRestingTimeoutNs;

    SubscriptionParams() {
    }

    static SubscriptionParams getSubscriptionParams(ChannelUri channelUri, MediaDriver.Context context, int publisherTermBufferLength) {
        String reliableStr;
        SubscriptionParams params = new SubscriptionParams();
        String sessionIdStr = channelUri.get("session-id");
        if (null != sessionIdStr) {
            params.sessionId = Integer.parseInt(sessionIdStr);
            params.hasSessionId = true;
        }
        if ("response".equals(channelUri.get("control-mode"))) {
            params.isResponse = true;
        }
        int count = 0;
        String initialTermIdStr = channelUri.get("init-term-id");
        count = initialTermIdStr != null ? count + 1 : count;
        String termIdStr = channelUri.get("term-id");
        count = termIdStr != null ? count + 1 : count;
        String termOffsetStr = channelUri.get("term-offset");
        int n = count = termOffsetStr != null ? count + 1 : count;
        if (count > 0) {
            if (count < 3) {
                throw new IllegalArgumentException("params must be used as a complete set: init-term-id term-id term-offset channel=" + String.valueOf(channelUri));
            }
            params.initialTermId = Integer.parseInt(initialTermIdStr);
            params.termId = Integer.parseInt(termIdStr);
            params.termOffset = Integer.parseInt(termOffsetStr);
            if (params.termOffset < 0 || params.termOffset > 0x40000000) {
                throw new IllegalArgumentException("term-offset=" + params.termOffset + " out of range: channel=" + String.valueOf(channelUri));
            }
            if ((params.termOffset & 0x1F) != 0) {
                throw new IllegalArgumentException("term-offset=" + params.termOffset + " must be a multiple of FRAME_ALIGNMENT: channel=" + String.valueOf(channelUri));
            }
            if (params.termId - params.initialTermId < 0) {
                throw new IllegalStateException("difference greater than 2^31 - 1: init-term-id=" + params.initialTermId + " when term-id=" + params.termId + " channel=" + String.valueOf(channelUri));
            }
            params.hasJoinPosition = true;
        }
        params.isReliable = null != (reliableStr = channelUri.get("reliable")) ? "true".equals(reliableStr) : context.reliableStream();
        String rejoinStr = channelUri.get("rejoin");
        params.isRejoin = null != rejoinStr ? "true".equals(rejoinStr) : context.rejoinStream();
        String tetherStr = channelUri.get("tether");
        params.isTether = null != tetherStr ? "true".equals(tetherStr) : context.tetherSubscriptions();
        String sparseStr = channelUri.get("sparse");
        params.isSparse = null != sparseStr ? "true".equals(sparseStr) : context.termBufferSparseFile();
        String groupStr = channelUri.get("group");
        params.group = null != groupStr ? CommonContext.InferableBoolean.parse(groupStr) : context.receiverGroupConsideration();
        int rcvWndLength = UdpChannel.parseBufferLength(channelUri, "rcv-wnd");
        params.receiverWindowLength = Configuration.receiverWindowLength(0 != publisherTermBufferLength ? publisherTermBufferLength : (channelUri.isIpc() ? context.ipcTermBufferLength() : context.publicationTermBufferLength()), 0 != rcvWndLength ? rcvWndLength : context.initialWindowLength());
        params.getUntetheredWindowLimitTimeout(channelUri, context);
        params.getUntetheredLingerTimeout(channelUri, context);
        params.getUntetheredRestingTimeout(channelUri, context);
        return params;
    }

    private void getUntetheredWindowLimitTimeout(ChannelUri channelUri, MediaDriver.Context ctx) {
        this.untetheredWindowLimitTimeoutNs = SubscriptionParams.getTimeoutNs(channelUri, "untethered-window-limit-timeout", ctx.untetheredWindowLimitTimeoutNs());
    }

    private void getUntetheredLingerTimeout(ChannelUri channelUri, MediaDriver.Context ctx) {
        this.untetheredLingerTimeoutNs = SubscriptionParams.getTimeoutNs(channelUri, "untethered-linger-timeout", ctx.untetheredLingerTimeoutNs());
        if (-1L == this.untetheredLingerTimeoutNs) {
            this.untetheredLingerTimeoutNs = this.untetheredWindowLimitTimeoutNs;
        }
    }

    private void getUntetheredRestingTimeout(ChannelUri channelUri, MediaDriver.Context ctx) {
        this.untetheredRestingTimeoutNs = SubscriptionParams.getTimeoutNs(channelUri, "untethered-resting-timeout", ctx.untetheredRestingTimeoutNs());
    }

    private static long getTimeoutNs(ChannelUri channelUri, String paramName, long defaultValue) {
        String timeoutString = channelUri.get(paramName);
        return null != timeoutString ? SystemUtil.parseDuration(paramName, timeoutString) : defaultValue;
    }

    static void validateInitialWindowForRcvBuf(SubscriptionParams params, String channel, int channelSocketRcvbufLength, MediaDriver.Context ctx, String existingChannel) {
        if (0 != channelSocketRcvbufLength && params.receiverWindowLength > channelSocketRcvbufLength) {
            throw new IllegalStateException("Initial window greater than SO_RCVBUF for channel: rcv-wnd=" + params.receiverWindowLength + " so-rcvbuf=" + channelSocketRcvbufLength + (String)(null == existingChannel ? "" : " existingChannel=" + existingChannel) + " channel=" + channel);
        }
        if (0 == channelSocketRcvbufLength && params.receiverWindowLength > ctx.osDefaultSocketRcvbufLength()) {
            throw new IllegalStateException("Initial window greater than SO_RCVBUF for channel: rcv-wnd=" + params.receiverWindowLength + " so-rcvbuf=" + ctx.osDefaultSocketRcvbufLength() + " (OS default)" + (String)(null == existingChannel ? "" : " existingChannel=" + existingChannel) + " channel=" + channel);
        }
    }

    public String toString() {
        return "SubscriptionParams\n{\n    initialTermId=" + this.initialTermId + "\n    termId=" + this.termId + "\n    termOffset=" + this.termOffset + "\n    sessionId=" + this.sessionId + "\n    hasJoinPosition=" + this.hasJoinPosition + "\n    hasSessionId=" + this.hasSessionId + "\n    isReliable=" + this.isReliable + "\n    isRejoin=" + this.isRejoin + "\n    isSparse=" + this.isSparse + "\n    isTether=" + this.isTether + "\n    isResponse=" + this.isResponse + "\n    group=" + String.valueOf((Object)this.group) + "\n    receiverWindowLength=" + this.receiverWindowLength + "\n    untetheredWindowLimitTimeoutNs=" + this.untetheredWindowLimitTimeoutNs + "\n    untetheredRestingTimeoutNs=" + this.untetheredRestingTimeoutNs + "\n    untetheredLingerTimeoutNs=" + this.untetheredLingerTimeoutNs + "\n}";
    }
}

