/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.buffer;

import io.aeron.driver.buffer.LogFactory;
import io.aeron.driver.buffer.MappedRawLog;
import io.aeron.driver.buffer.RawLog;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.StorageSpaceException;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.status.AtomicCounter;

public class FileStoreLogFactory
implements LogFactory {
    private static final String PUBLICATIONS = "publications";
    private static final String IMAGES = "images";
    private final long lowStorageWarningThreshold;
    private final int filePageSize;
    private final boolean checkStorage;
    private final ErrorHandler errorHandler;
    private final File publicationsDir;
    private final File imagesDir;
    private final FileStore fileStore;
    private final AtomicCounter mappedBytesCounter;

    public FileStoreLogFactory(String dataDirectoryName, int filePageSize, boolean checkStorage, long lowStorageWarningThreshold, ErrorHandler errorHandler, AtomicCounter mappedBytesCounter) {
        this.filePageSize = filePageSize;
        this.lowStorageWarningThreshold = lowStorageWarningThreshold;
        this.checkStorage = checkStorage;
        this.errorHandler = errorHandler;
        this.mappedBytesCounter = mappedBytesCounter;
        File dataDir = new File(dataDirectoryName);
        this.publicationsDir = new File(dataDir, PUBLICATIONS);
        this.imagesDir = new File(dataDir, IMAGES);
        IoUtil.ensureDirectoryExists(this.publicationsDir, PUBLICATIONS);
        IoUtil.ensureDirectoryExists(this.imagesDir, IMAGES);
        try {
            this.fileStore = checkStorage ? Files.getFileStore(dataDir.toPath()) : null;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public RawLog newPublication(long correlationId, int termBufferLength, boolean useSparseFiles) {
        return this.newInstance(this.publicationsDir, correlationId, termBufferLength, useSparseFiles);
    }

    @Override
    public RawLog newImage(long correlationId, int termBufferLength, boolean useSparseFiles) {
        return this.newInstance(this.imagesDir, correlationId, termBufferLength, useSparseFiles);
    }

    private RawLog newInstance(File rootDir, long correlationId, int termLength, boolean useSparseFiles) {
        long logLength = LogBufferDescriptor.computeLogLength(termLength, this.filePageSize);
        this.checkStorage(logLength);
        File location = FileStoreLogFactory.streamLocation(rootDir, correlationId);
        return new MappedRawLog(location, useSparseFiles, logLength, termLength, this.filePageSize, this.errorHandler, this.mappedBytesCounter);
    }

    private void checkStorage(long logLength) {
        if (this.checkStorage) {
            long usableSpace = this.getUsableSpace();
            if (usableSpace < logLength) {
                throw new StorageSpaceException("insufficient usable storage for new log of length=" + logLength + " usable=" + usableSpace + " in " + String.valueOf(this.fileStore));
            }
            if (usableSpace <= this.lowStorageWarningThreshold) {
                String msg = "space is running low: threshold=" + this.lowStorageWarningThreshold + " usable=" + usableSpace + " in " + String.valueOf(this.fileStore);
                this.errorHandler.onError(new AeronException(msg, AeronException.Category.WARN));
            }
        }
    }

    private long getUsableSpace() {
        long usableSpace = 0L;
        try {
            usableSpace = this.fileStore.getUsableSpace();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked(ex);
        }
        return usableSpace;
    }

    private static File streamLocation(File rootDir, long correlationId) {
        String fileName = correlationId + ".logbuffer";
        return new File(rootDir, fileName);
    }
}

