/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.protocol;

import io.aeron.protocol.HeaderFlyweight;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.agrona.concurrent.UnsafeBuffer;

public class SetupFlyweight
extends HeaderFlyweight {
    public static final int HEADER_LENGTH = 40;
    public static final short SEND_RESPONSE_SETUP_FLAG = 128;
    public static final short GROUP_FLAG = 64;
    private static final int TERM_OFFSET_FIELD_OFFSET = 8;
    private static final int SESSION_ID_FIELD_OFFSET = 12;
    private static final int STREAM_ID_FIELD_OFFSET = 16;
    private static final int INITIAL_TERM_ID_FIELD_OFFSET = 20;
    private static final int ACTIVE_TERM_ID_FIELD_OFFSET = 24;
    private static final int TERM_LENGTH_FIELD_OFFSET = 28;
    private static final int MTU_LENGTH_FIELD_OFFSET = 32;
    private static final int TTL_FIELD_OFFSET = 36;

    public SetupFlyweight() {
    }

    public SetupFlyweight(UnsafeBuffer buffer) {
        super(buffer);
    }

    public SetupFlyweight(ByteBuffer buffer) {
        super(buffer);
    }

    public int termOffset() {
        return this.getInt(8, ByteOrder.LITTLE_ENDIAN);
    }

    public SetupFlyweight termOffset(int termOffset) {
        this.putInt(8, termOffset, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int sessionId() {
        return this.getInt(12, ByteOrder.LITTLE_ENDIAN);
    }

    public SetupFlyweight sessionId(int sessionId) {
        this.putInt(12, sessionId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int streamId() {
        return this.getInt(16, ByteOrder.LITTLE_ENDIAN);
    }

    public SetupFlyweight streamId(int streamId) {
        this.putInt(16, streamId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int initialTermId() {
        return this.getInt(20, ByteOrder.LITTLE_ENDIAN);
    }

    public SetupFlyweight initialTermId(int termId) {
        this.putInt(20, termId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int activeTermId() {
        return this.getInt(24, ByteOrder.LITTLE_ENDIAN);
    }

    public SetupFlyweight activeTermId(int termId) {
        this.putInt(24, termId, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int termLength() {
        return this.getInt(28, ByteOrder.LITTLE_ENDIAN);
    }

    public SetupFlyweight termLength(int termLength) {
        this.putInt(28, termLength, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int mtuLength() {
        return this.getInt(32, ByteOrder.LITTLE_ENDIAN);
    }

    public SetupFlyweight mtuLength(int mtuLength) {
        this.putInt(32, mtuLength, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public int ttl() {
        return this.getInt(36, ByteOrder.LITTLE_ENDIAN);
    }

    public SetupFlyweight ttl(int ttl) {
        this.putInt(36, ttl, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    @Override
    public String toString() {
        return "SETUP{frame-length=" + this.frameLength() + " version=" + this.version() + " flags=" + String.valueOf(SetupFlyweight.flagsToChars(this.flags())) + " type=" + this.headerType() + " term-offset=" + this.termOffset() + " session-id=" + this.sessionId() + " stream-id=" + this.streamId() + " initial-term-id=" + this.initialTermId() + " active-term-id=" + this.activeTermId() + " term-length=" + this.termLength() + " mtu-length=" + this.mtuLength() + " ttl=" + this.ttl() + "}";
    }
}

