/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.samples.CncFileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.agrona.DirectBuffer;
import org.agrona.SystemUtil;
import org.agrona.concurrent.ShutdownSignalBarrier;
import org.agrona.concurrent.status.CountersReader;

public class AeronStat {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final String ANSI_CLS = "\u001b[2J";
    private static final String ANSI_HOME = "\u001b[H";
    private static final String DELAY = "delay";
    private static final String WATCH = "watch";
    private static final String COUNTER_TYPE_ID = "type";
    private static final String COUNTER_IDENTITY = "identity";
    private static final String COUNTER_SESSION_ID = "session";
    private static final String COUNTER_STREAM_ID = "stream";
    private static final String COUNTER_CHANNEL = "channel";

    public static void main(String[] args) throws IOException, InterruptedException {
        long delayMs = 1000L;
        boolean watch = true;
        Pattern typeFilter = null;
        Pattern identityFilter = null;
        Pattern sessionFilter = null;
        Pattern streamFilter = null;
        Pattern channelFilter = null;
        if (0 != args.length) {
            AeronStat.checkForHelp(args);
            block18: for (String arg : args) {
                int equalsIndex = arg.indexOf(61);
                if (-1 == equalsIndex) {
                    System.out.println("Arguments must be in name=pattern format: Invalid '" + arg + "'");
                    return;
                }
                String argName = arg.substring(0, equalsIndex);
                String argValue = arg.substring(equalsIndex + 1);
                switch (argName) {
                    case "watch": {
                        watch = Boolean.parseBoolean(argValue);
                        continue block18;
                    }
                    case "delay": {
                        delayMs = Long.parseLong(argValue) * 1000L;
                        continue block18;
                    }
                    case "type": {
                        typeFilter = Pattern.compile(argValue);
                        continue block18;
                    }
                    case "identity": {
                        identityFilter = Pattern.compile(argValue);
                        continue block18;
                    }
                    case "session": {
                        sessionFilter = Pattern.compile(argValue);
                        continue block18;
                    }
                    case "stream": {
                        streamFilter = Pattern.compile(argValue);
                        continue block18;
                    }
                    case "channel": {
                        channelFilter = Pattern.compile(argValue);
                        continue block18;
                    }
                    default: {
                        System.out.println("Unrecognised argument: '" + arg + "'");
                        return;
                    }
                }
            }
        }
        CncFileReader cncFileReader = CncFileReader.map();
        CounterFilter counterFilter = new CounterFilter(typeFilter, identityFilter, sessionFilter, streamFilter, channelFilter);
        if (watch) {
            AeronStat.workLoop(delayMs, () -> AeronStat.printOutput(cncFileReader, counterFilter));
        } else {
            AeronStat.printOutput(cncFileReader, counterFilter);
        }
    }

    private static void workLoop(long delayMs, Runnable outputPrinter) throws IOException, InterruptedException {
        AtomicBoolean running = new AtomicBoolean(true);
        try (ShutdownSignalBarrier ignore = new ShutdownSignalBarrier(() -> running.set(false));){
            do {
                AeronStat.clearScreen();
                outputPrinter.run();
                Thread.sleep(delayMs);
            } while (running.get());
        }
    }

    private static void printOutput(CncFileReader cncFileReader, CounterFilter counterFilter) {
        System.out.print(DATE_FORMAT.format(new Date()));
        System.out.println(" - Aeron Stat (CnC v" + cncFileReader.semanticVersion() + "), pid " + cncFileReader.driverPid() + ", heartbeat age " + cncFileReader.driverHeartbeatAgeMs() + "ms");
        System.out.println("======================================================================");
        CountersReader counters = cncFileReader.countersReader();
        counters.forEach((counterId, typeId, keyBuffer, label) -> {
            if (counterFilter.filter(typeId, keyBuffer)) {
                long value = counters.getCounterValue(counterId);
                System.out.format("%3d: %,20d - %s%n", counterId, value, label);
            }
        });
        System.out.println("--");
    }

    private static void checkForHelp(String[] args) {
        for (String arg : args) {
            if (!"-?".equals(arg) && !"-h".equals(arg) && !"-help".equals(arg)) continue;
            System.out.format("Usage: [-Daeron.dir=<directory containing CnC file>] AeronStat%n\t[delay=<seconds between updates>]%n\t[watch=<true|false>]%nfilter by optional regex patterns:%n\t[type=<pattern>]%n\t[identity=<pattern>]%n\t[session=<pattern>]%n\t[stream=<pattern>]%n\t[channel=<pattern>]%n", new Object[0]);
            System.exit(0);
        }
    }

    private static void clearScreen() throws IOException, InterruptedException {
        if (SystemUtil.isWindows()) {
            new ProcessBuilder("C:\\Windows\\System32\\cmd.exe", "/c", "cls").inheritIO().start().waitFor();
        } else {
            System.out.print("\u001b[2J\u001b[H");
        }
    }

    static class CounterFilter {
        private final Pattern typeFilter;
        private final Pattern identityFilter;
        private final Pattern sessionFilter;
        private final Pattern streamFilter;
        private final Pattern channelFilter;

        CounterFilter(Pattern typeFilter, Pattern identityFilter, Pattern sessionFilter, Pattern streamFilter, Pattern channelFilter) {
            this.typeFilter = typeFilter;
            this.identityFilter = identityFilter;
            this.sessionFilter = sessionFilter;
            this.streamFilter = streamFilter;
            this.channelFilter = channelFilter;
        }

        private static boolean match(Pattern pattern, Supplier<String> supplier) {
            return null == pattern || pattern.matcher(supplier.get()).find();
        }

        boolean filter(int typeId, DirectBuffer keyBuffer) {
            if (!CounterFilter.match(this.typeFilter, () -> Integer.toString(typeId))) {
                return false;
            }
            if (0 == typeId && !CounterFilter.match(this.identityFilter, () -> Integer.toString(keyBuffer.getInt(0)))) {
                return false;
            }
            if (typeId >= 1 && typeId <= 5 || typeId == 9 || typeId == 10 || typeId == 12) {
                return CounterFilter.match(this.identityFilter, () -> Long.toString(keyBuffer.getLong(0))) && CounterFilter.match(this.sessionFilter, () -> Integer.toString(keyBuffer.getInt(8))) && CounterFilter.match(this.streamFilter, () -> Integer.toString(keyBuffer.getInt(12))) && CounterFilter.match(this.channelFilter, () -> keyBuffer.getStringAscii(16));
            }
            if (typeId >= 6 && typeId <= 7) {
                return CounterFilter.match(this.channelFilter, () -> keyBuffer.getStringAscii(0));
            }
            return true;
        }
    }
}

