/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.ConcurrentPublication;
import io.aeron.driver.MediaDriver;
import io.aeron.samples.SampleConfiguration;
import java.util.concurrent.TimeUnit;
import org.agrona.BufferUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class BasicPublisher {
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;
    private static final long NUMBER_OF_MESSAGES = SampleConfiguration.NUMBER_OF_MESSAGES;
    private static final long LINGER_TIMEOUT_MS = SampleConfiguration.LINGER_TIMEOUT_MS;
    private static final boolean EMBEDDED_MEDIA_DRIVER = SampleConfiguration.EMBEDDED_MEDIA_DRIVER;

    public static void main(String[] args) throws InterruptedException {
        System.out.println("Publishing to " + CHANNEL + " on stream id " + STREAM_ID);
        try (MediaDriver driver = EMBEDDED_MEDIA_DRIVER ? MediaDriver.launchEmbedded() : null;){
            Aeron.Context ctx = new Aeron.Context();
            if (EMBEDDED_MEDIA_DRIVER) {
                ctx.aeronDirectoryName(driver.aeronDirectoryName());
            }
            try (Aeron aeron = Aeron.connect(ctx);
                 ConcurrentPublication publication = aeron.addPublication(CHANNEL, STREAM_ID);){
                UnsafeBuffer buffer = new UnsafeBuffer(BufferUtil.allocateDirectAligned(256, 64));
                for (long i = 0L; i < NUMBER_OF_MESSAGES; ++i) {
                    System.out.print("Offering " + i + "/" + NUMBER_OF_MESSAGES + " - ");
                    int length = buffer.putStringWithoutLengthAscii(0, "Hello World! " + i);
                    long position = publication.offer(buffer, 0, length);
                    if (position > 0L) {
                        System.out.println("yay!");
                    } else if (position == -2L) {
                        System.out.println("Offer failed due to back pressure");
                    } else if (position == -1L) {
                        System.out.println("Offer failed because publisher is not connected to a subscriber");
                    } else if (position == -3L) {
                        System.out.println("Offer failed because of an administration action in the system");
                    } else {
                        if (position == -4L) {
                            System.out.println("Offer failed because publication is closed");
                            break;
                        }
                        if (position == -5L) {
                            System.out.println("Offer failed due to publication reaching its max position");
                            break;
                        }
                        System.out.println("Offer failed due to unknown reason: " + position);
                    }
                    if (!publication.isConnected()) {
                        System.out.println("No active subscribers detected");
                    }
                    Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
                }
                System.out.println("Done sending.");
                if (LINGER_TIMEOUT_MS > 0L) {
                    System.out.println("Lingering for " + LINGER_TIMEOUT_MS + " milliseconds...");
                    Thread.sleep(LINGER_TIMEOUT_MS);
                }
            }
        }
    }
}

