/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.Subscription;
import io.aeron.driver.MediaDriver;
import io.aeron.samples.RateReporter;
import io.aeron.samples.SampleConfiguration;
import io.aeron.samples.SamplesUtil;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.concurrent.ShutdownSignalBarrier;

public class RateSubscriber {
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;
    private static final int FRAGMENT_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final boolean EMBEDDED_MEDIA_DRIVER = SampleConfiguration.EMBEDDED_MEDIA_DRIVER;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        System.out.println("Subscribing to " + CHANNEL + " on stream id " + STREAM_ID);
        AtomicBoolean running = new AtomicBoolean(true);
        try (ShutdownSignalBarrier barrier = new ShutdownSignalBarrier(() -> running.set(false));
             MediaDriver driver = EMBEDDED_MEDIA_DRIVER ? MediaDriver.launchEmbedded(new MediaDriver.Context().terminationHook(barrier::signalAll)) : null;){
            ExecutorService executor = Executors.newFixedThreadPool(2);
            Aeron.Context ctx = new Aeron.Context().availableImageHandler(SamplesUtil::printAvailableImage).unavailableImageHandler(SamplesUtil::printUnavailableImage);
            if (EMBEDDED_MEDIA_DRIVER) {
                ctx.aeronDirectoryName(driver.aeronDirectoryName());
            }
            RateReporter reporter = new RateReporter(TimeUnit.SECONDS.toNanos(1L), SamplesUtil::printRate);
            try (Aeron aeron = Aeron.connect(ctx);
                 Subscription subscription = aeron.addSubscription(CHANNEL, STREAM_ID);){
                executor.submit(() -> SamplesUtil.subscriberLoop(SamplesUtil.rateReporterHandler(reporter), FRAGMENT_COUNT_LIMIT, running).accept(subscription));
                executor.submit(reporter);
                barrier.await();
                System.out.println("Shutting down...");
                executor.shutdown();
                if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    System.out.println("Warning: not all tasks completed promptly");
                }
            }
        }
    }
}

