/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.archive;

public class RecordingDescriptor {
    private long controlSessionId;
    private long correlationId;
    private long recordingId;
    private long startTimestamp;
    private long stopTimestamp;
    private long startPosition;
    private long stopPosition;
    private int initialTermId;
    private int segmentFileLength;
    private int termBufferLength;
    private int mtuLength;
    private int sessionId;
    private int streamId;
    private String strippedChannel;
    private String originalChannel;
    private String sourceIdentity;
    private boolean isRetained = false;

    RecordingDescriptor reset() {
        this.controlSessionId = -1L;
        this.correlationId = -1L;
        this.recordingId = -1L;
        this.startTimestamp = -1L;
        this.stopTimestamp = -1L;
        this.startPosition = -1L;
        this.stopPosition = -1L;
        this.initialTermId = 0;
        this.segmentFileLength = 0;
        this.termBufferLength = 0;
        this.mtuLength = 0;
        this.sessionId = 0;
        this.streamId = 0;
        this.strippedChannel = null;
        this.originalChannel = null;
        this.sourceIdentity = null;
        return this;
    }

    RecordingDescriptor set(long controlSessionId, long correlationId, long recordingId, long startTimestamp, long stopTimestamp, long startPosition, long stopPosition, int initialTermId, int segmentFileLength, int termBufferLength, int mtuLength, int sessionId, int streamId, String strippedChannel, String originalChannel, String sourceIdentity) {
        this.controlSessionId = controlSessionId;
        this.correlationId = correlationId;
        this.recordingId = recordingId;
        this.startTimestamp = startTimestamp;
        this.stopTimestamp = stopTimestamp;
        this.startPosition = startPosition;
        this.stopPosition = stopPosition;
        this.initialTermId = initialTermId;
        this.segmentFileLength = segmentFileLength;
        this.termBufferLength = termBufferLength;
        this.mtuLength = mtuLength;
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.strippedChannel = strippedChannel;
        this.originalChannel = originalChannel;
        this.sourceIdentity = sourceIdentity;
        return this;
    }

    public long controlSessionId() {
        return this.controlSessionId;
    }

    public long correlationId() {
        return this.correlationId;
    }

    public long recordingId() {
        return this.recordingId;
    }

    public long startTimestamp() {
        return this.startTimestamp;
    }

    public long stopTimestamp() {
        return this.stopTimestamp;
    }

    public long startPosition() {
        return this.startPosition;
    }

    public long stopPosition() {
        return this.stopPosition;
    }

    public int initialTermId() {
        return this.initialTermId;
    }

    public int segmentFileLength() {
        return this.segmentFileLength;
    }

    public int termBufferLength() {
        return this.termBufferLength;
    }

    public int mtuLength() {
        return this.mtuLength;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    public String strippedChannel() {
        return this.strippedChannel;
    }

    public String originalChannel() {
        return this.originalChannel;
    }

    public String sourceIdentity() {
        return this.sourceIdentity;
    }

    public RecordingDescriptor retain() {
        this.isRetained = true;
        return this;
    }

    public boolean isRetained() {
        return this.isRetained;
    }

    public String toString() {
        return "RecordingDescriptor{controlSessionId=" + this.controlSessionId + ", correlationId=" + this.correlationId + ", recordingId=" + this.recordingId + ", startTimestamp=" + this.startTimestamp + ", stopTimestamp=" + this.stopTimestamp + ", startPosition=" + this.startPosition + ", stopPosition=" + this.stopPosition + ", initialTermId=" + this.initialTermId + ", segmentFileLength=" + this.segmentFileLength + ", termBufferLength=" + this.termBufferLength + ", mtuLength=" + this.mtuLength + ", sessionId=" + this.sessionId + ", streamId=" + this.streamId + ", strippedChannel='" + this.strippedChannel + "', originalChannel='" + this.originalChannel + "', sourceIdentity='" + this.sourceIdentity + "'}";
    }
}

