/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.cluster;

import io.aeron.cluster.ClusteredMediaDriver;
import io.aeron.cluster.service.ClusteredService;
import io.aeron.cluster.service.ClusteredServiceContainer;
import io.aeron.samples.cluster.ClusterConfig;
import io.aeron.samples.cluster.EchoService;
import java.util.Arrays;
import java.util.List;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.ShutdownSignalBarrier;

public final class EchoServiceNode {
    private static final int PORT_BASE = 9000;

    private static ErrorHandler errorHandler(String context) {
        return throwable -> {
            System.err.println(context);
            throwable.printStackTrace(System.err);
        };
    }

    public static void main(String[] args) {
        int nodeId = Integer.parseInt(System.getProperty("aeron.cluster.tutorial.nodeId"));
        String hostnamesStr = System.getProperty("aeron.cluster.tutorial.hostnames", "localhost,localhost,localhost");
        String internalHostnamesStr = System.getProperty("aeron.cluster.tutorial.hostnames.internal", hostnamesStr);
        List<String> hostnames = Arrays.asList(hostnamesStr.split(","));
        List<String> internalHostnames = Arrays.asList(internalHostnamesStr.split(","));
        ClusterConfig clusterConfig = ClusterConfig.create(nodeId, hostnames, internalHostnames, 9000, new EchoService(), new ClusteredService[0]);
        clusterConfig.mediaDriverContext().errorHandler(EchoServiceNode.errorHandler("Media Driver"));
        clusterConfig.archiveContext().errorHandler(EchoServiceNode.errorHandler("Archive"));
        clusterConfig.aeronArchiveContext().errorHandler(EchoServiceNode.errorHandler("Aeron Archive"));
        clusterConfig.consensusModuleContext().errorHandler(EchoServiceNode.errorHandler("Consensus Module"));
        clusterConfig.clusteredServiceContext().errorHandler(EchoServiceNode.errorHandler("Clustered Service"));
        try (ShutdownSignalBarrier barrier = new ShutdownSignalBarrier();
             ClusteredMediaDriver ignore = ClusteredMediaDriver.launch(clusterConfig.mediaDriverContext().terminationHook(barrier::signalAll), clusterConfig.archiveContext(), clusterConfig.consensusModuleContext().terminationHook(barrier::signalAll));
             ClusteredServiceContainer ignore2 = ClusteredServiceContainer.launch(clusterConfig.clusteredServiceContext().terminationHook(barrier::signalAll));){
            System.out.println("[" + nodeId + "] Started Cluster Node on " + hostnames.get(nodeId) + "...");
            barrier.await();
            System.out.println("[" + nodeId + "] Exiting");
        }
    }
}

