/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.cluster.tutorial;

import io.aeron.ExclusivePublication;
import io.aeron.Image;
import io.aeron.cluster.codecs.CloseReason;
import io.aeron.cluster.service.ClientSession;
import io.aeron.cluster.service.Cluster;
import io.aeron.cluster.service.ClusteredService;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.MutableBoolean;
import org.agrona.concurrent.IdleStrategy;

public class BasicAuctionClusteredService
implements ClusteredService {
    static final int CORRELATION_ID_OFFSET = 0;
    static final int CUSTOMER_ID_OFFSET = 8;
    static final int PRICE_OFFSET = 16;
    static final int BID_MESSAGE_LENGTH = 24;
    static final int BID_SUCCEEDED_OFFSET = 24;
    static final int EGRESS_MESSAGE_LENGTH = 25;
    static final int SNAPSHOT_CUSTOMER_ID_OFFSET = 0;
    static final int SNAPSHOT_PRICE_OFFSET = 8;
    static final int SNAPSHOT_MESSAGE_LENGTH = 16;
    private final MutableDirectBuffer egressMessageBuffer = new ExpandableArrayBuffer();
    private final MutableDirectBuffer snapshotBuffer = new ExpandableArrayBuffer();
    private final Auction auction = new Auction();
    private Cluster cluster;
    private IdleStrategy idleStrategy;

    @Override
    public void onStart(Cluster cluster, Image snapshotImage) {
        this.cluster = cluster;
        this.idleStrategy = cluster.idleStrategy();
        if (null != snapshotImage) {
            this.loadSnapshot(cluster, snapshotImage);
        }
    }

    @Override
    public void onSessionMessage(ClientSession session, long timestamp, DirectBuffer buffer, int offset, int length, Header header) {
        long correlationId = buffer.getLong(offset + 0);
        long customerId = buffer.getLong(offset + 8);
        long price = buffer.getLong(offset + 16);
        boolean bidSucceeded = this.auction.attemptBid(price, customerId);
        if (null != session) {
            this.egressMessageBuffer.putLong(0, correlationId);
            this.egressMessageBuffer.putLong(8, this.auction.getCurrentWinningCustomerId());
            this.egressMessageBuffer.putLong(16, this.auction.getBestPrice());
            this.egressMessageBuffer.putByte(24, bidSucceeded ? (byte)1 : 0);
            this.idleStrategy.reset();
            while (session.offer(this.egressMessageBuffer, 0, 25) < 0L) {
                this.idleStrategy.idle();
            }
        }
    }

    @Override
    public void onTakeSnapshot(ExclusivePublication snapshotPublication) {
        this.snapshotBuffer.putLong(0, this.auction.getCurrentWinningCustomerId());
        this.snapshotBuffer.putLong(8, this.auction.getBestPrice());
        this.idleStrategy.reset();
        while (snapshotPublication.offer(this.snapshotBuffer, 0, 16) < 0L) {
            this.idleStrategy.idle();
        }
    }

    private void loadSnapshot(Cluster cluster, Image snapshotImage) {
        MutableBoolean isAllDataLoaded = new MutableBoolean(false);
        FragmentHandler fragmentHandler = (buffer, offset, length, header) -> {
            assert (length >= 16);
            long customerId = buffer.getLong(offset + 0);
            long price = buffer.getLong(offset + 8);
            this.auction.loadInitialState(price, customerId);
            isAllDataLoaded.set(true);
        };
        while (!snapshotImage.isEndOfStream()) {
            int fragmentsPolled = snapshotImage.poll(fragmentHandler, 1);
            if (isAllDataLoaded.value) break;
            this.idleStrategy.idle(fragmentsPolled);
        }
        assert (snapshotImage.isEndOfStream());
        assert (isAllDataLoaded.value);
    }

    @Override
    public void onRoleChange(Cluster.Role newRole) {
    }

    @Override
    public void onTerminate(Cluster cluster) {
    }

    @Override
    public void onSessionOpen(ClientSession session, long timestamp) {
        System.out.println("onSessionOpen(" + String.valueOf(session) + ")");
    }

    @Override
    public void onSessionClose(ClientSession session, long timestamp, CloseReason closeReason) {
        System.out.println("onSessionClose(" + String.valueOf(session) + ")");
    }

    @Override
    public void onTimerEvent(long correlationId, long timestamp) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicAuctionClusteredService that = (BasicAuctionClusteredService)o;
        return this.auction.equals(that.auction);
    }

    public int hashCode() {
        return Objects.hash(this.auction);
    }

    public String toString() {
        return "BasicAuctionClusteredService{auction=" + String.valueOf(this.auction) + "}";
    }

    static class Auction {
        private long bestPrice = 0L;
        private long currentWinningCustomerId = -1L;

        Auction() {
        }

        void loadInitialState(long price, long customerId) {
            this.bestPrice = price;
            this.currentWinningCustomerId = customerId;
        }

        boolean attemptBid(long price, long customerId) {
            System.out.println("attemptBid(this=" + String.valueOf(this) + ", price=" + price + ",customerId=" + customerId + ")");
            if (price <= this.bestPrice) {
                return false;
            }
            this.bestPrice = price;
            this.currentWinningCustomerId = customerId;
            return true;
        }

        long getBestPrice() {
            return this.bestPrice;
        }

        long getCurrentWinningCustomerId() {
            return this.currentWinningCustomerId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Auction auction = (Auction)o;
            return this.bestPrice == auction.bestPrice && this.currentWinningCustomerId == auction.currentWinningCustomerId;
        }

        public int hashCode() {
            return Objects.hash(this.bestPrice, this.currentWinningCustomerId);
        }

        public String toString() {
            return "Auction{bestPrice=" + this.bestPrice + ", currentWinningCustomerId=" + this.currentWinningCustomerId + "}";
        }
    }
}

